/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.screen.rc;

import com.whyvo.chatscreen.screen.rc.RCButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class RCContext {
    private final int oX;
    private final int oY;
    private final int minX;
    private final int minY;
    private final int maxX;
    private final int maxY;
    private final List<RCButton> buttons;
    private int hoveredButton = -1;

    protected RCContext(int oX, int oY, int minX, int minY, int maxX, int maxY, List<RCButton> buttons) {
        this.oX = oX;
        this.oY = oY;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.buttons = buttons;
    }

    private int getButtonHeight() {
        return 18;
    }

    public void render(class_332 context, int mouseX, int mouseY, class_327 font) {
        if (this.buttons.isEmpty()) {
            return;
        }
        int bHeight = this.getButtonHeight();
        int height = bHeight * this.buttons.size();
        int startY = Math.max(this.minY, Math.min(this.maxY - height, this.oY));
        int m = 0;
        for (RCButton button : this.buttons) {
            int n = font.method_27525((class_5348)button.getNameText());
            if (n <= m) continue;
            m = n;
        }
        int width = m + 8;
        int startX = Math.max(this.minX, Math.min(this.maxX - width, this.oX));
        context.method_25294(startX, startY, startX + width, startY + height, -16777216);
        this.hoveredButton = -1;
        if (mouseX >= startX && mouseX < startX + width) {
            int d = mouseY - startY;
            int i = d / bHeight;
            if (d >= 0 && i >= 0 && i < this.buttons.size()) {
                if (this.buttons.get((int)i).active) {
                    int startY0 = startY + i * bHeight;
                    context.method_25294(startX, startY0, startX + width, startY0 + bHeight, -12303292);
                }
                this.hoveredButton = i;
            }
        }
        int x = startX + 5;
        int y = startY + 4;
        for (RCButton button : this.buttons) {
            context.method_51439(font, button.getNameText(), x, y, button.active ? -1 : -11184811, false);
            y += bHeight;
        }
    }

    public boolean onMouseClicked(int mouseX, int mouseY) {
        if (this.hoveredButton < 0) {
            return true;
        }
        RCButton button = this.buttons.get(this.hoveredButton);
        return button.onClick();
    }

    public static Builder builder(int oX, int oY) {
        return new Builder(oX, oY);
    }

    public static class Builder {
        private final int oX;
        private final int oY;
        private int minX = 0;
        private int minY = 0;
        private int maxX = Integer.MAX_VALUE;
        private int maxY = Integer.MAX_VALUE;
        private final List<RCButton> buttons = new ArrayList<RCButton>();

        protected Builder(int oX, int oY) {
            this.oX = oX;
            this.oY = oY;
        }

        public Builder border(int minX, int minY, int maxX, int maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
            return this;
        }

        public Builder addButton(class_2561 name, Runnable action) {
            this.buttons.add(new RCButton(name, action));
            return this;
        }

        public Builder addButtonInactive(class_2561 name) {
            this.buttons.add(new RCButton(name));
            return this;
        }

        public RCContext build() {
            return new RCContext(this.oX, this.oY, this.minX, this.minY, this.maxX, this.maxY, this.buttons);
        }
    }
}

