/*
 * Decompiled with CFR 0.152.
 */
package com.whyvo.chatscreen.chat;

import com.whyvo.chatscreen.chat.Message;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public abstract class Chat {
    public class_2561 name;
    private final Deque<Message> messages;
    private final Deque<Message> newMessages;
    private boolean scrolled = false;
    public long lastMessageTime;
    private String tempMessage = null;
    public int unreadMessages = 0;
    private double scrollAmount = 0.0;
    private boolean lastScrollDown = false;

    public Chat(class_2561 name) {
        this.name = name;
        this.messages = new ArrayDeque<Message>();
        this.newMessages = new ArrayDeque<Message>();
    }

    public void newMessage(Message message) {
        this.lastMessageTime = message.time;
        if (this.scrolled) {
            this.newMessages.addLast(message);
        } else {
            this.messages.addFirst(message);
        }
        this.tempMessage = message.getTempMessage();
    }

    public abstract boolean isGroup();

    public boolean isScrolled() {
        return this.scrolled;
    }

    public void scroll(double scrollAmount) {
        if (!this.scrolled && scrollAmount < 0.0) {
            this.lastScrollDown = false;
            return;
        }
        this.scrollAmount += scrollAmount;
        if (scrollAmount < 0.0) {
            this.lastScrollDown = true;
        } else if (scrollAmount > 0.0) {
            this.lastScrollDown = false;
        }
    }

    public boolean isLastScrollDown() {
        return this.lastScrollDown;
    }

    public int newMessagesCount() {
        return this.newMessages.size();
    }

    protected int getNameColor() {
        return -1;
    }

    public void render(class_332 context, int x, int y, class_327 font) {
        context.method_51439(font, this.name, x + 24, y + 5, this.getNameColor(), false);
        String tempMessage = this.tempMessage;
        if (tempMessage != null) {
            class_5250 temp = class_2561.method_43470((String)font.method_27523(tempMessage, 66));
            context.method_51439(font, (class_2561)temp, x + 24, y + 17, -1846063, false);
        }
        this.renderAvatar(context, x + 4, y + 8);
        if (this.unreadMessages > 0) {
            String unread = this.unreadMessages < 100 ? String.valueOf(this.unreadMessages) : "99+";
            int width = font.method_1727(unread);
            context.method_51433(font, unread, x + 20 - width, y + 3, -65536, true);
        }
    }

    public void scrollToBottom() {
        Message message;
        this.scrolled = false;
        while ((message = this.newMessages.poll()) != null) {
            this.messages.addFirst(message);
        }
        this.scrollAmount = 0.0;
        this.lastScrollDown = false;
    }

    public Message renderMessages(class_332 context, int left, int top, int right, int bottom, class_327 font, boolean mouseIn, int mouseY) {
        int width = right - left;
        if (this.scrollAmount < 0.0) {
            if (!this.scrolled) {
                this.scrollAmount = 0.0;
            } else {
                Message message;
                while ((message = this.newMessages.poll()) != null) {
                    int h = this.estimateMessageHeight(message, font, width);
                    this.scrollAmount += (double)h;
                    this.messages.addFirst(message);
                    if (!(this.scrollAmount >= 0.0)) continue;
                    break;
                }
                if (this.scrollAmount < 0.0) {
                    this.scrollAmount = 0.0;
                }
            }
        }
        boolean bl = this.scrolled = !this.newMessages.isEmpty() || this.scrollAmount != 0.0;
        if (!this.scrolled) {
            this.lastScrollDown = false;
        }
        Message hoveredMessage = null;
        int msa = (int)this.scrollAmount;
        int yb = bottom + msa;
        for (Message message : this.messages) {
            int h = message.render(context, left, yb, bottom, right, font, this.isGroup());
            if (mouseIn && mouseY >= (yb -= h) && mouseY < yb + h) {
                hoveredMessage = message;
            }
            if (yb >= top) continue;
            break;
        }
        if ((yb -= 2) > top) {
            this.scrollAmount -= (double)(yb - top);
        }
        return hoveredMessage;
    }

    public int estimateMessageHeight(Message message, class_327 font, int width) {
        int contentMaxWidth = width - 28;
        List lines = font.method_1728((class_5348)message.content, contentMaxWidth);
        int contentHeight = lines.size() * 10;
        return contentHeight + (this.isGroup() ? 17 : 5);
    }

    public abstract void renderAvatar(class_332 var1, int var2, int var3);
}

