/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.entity.EntityClickEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketSentEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.compat.PacketCompatKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C02PacketUseEntity;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.network.play.client.C0APacketAnimation;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/data/ItemClickData;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;", "event", "", "onItemClickSend", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;)V", "1.8.9"})
public final class ItemClickData {
    @NotNull
    public static final ItemClickData INSTANCE = new ItemClickData();

    private ItemClickData() {
    }

    @HandleEvent
    public final void onItemClickSend(@NotNull PacketSentEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter(event, "event");
        Packet<?> packet = event.getPacket();
        if (packet instanceof C08PacketPlayerBlockPlacement) {
            boolean didntMiss;
            boolean clickCancelled = new ItemClickEvent(InventoryUtils.INSTANCE.getItemInHand(), ClickType.RIGHT_CLICK).post();
            boolean bl2 = didntMiss = ((C08PacketPlayerBlockPlacement)packet).func_149568_f() != 255;
            if (didntMiss) {
                BlockPos blockPos = ((C08PacketPlayerBlockPlacement)packet).func_179724_a();
                Intrinsics.checkNotNullExpressionValue(blockPos, "getPosition(...)");
                LorenzVec position = LorenzVecKt.toLorenzVec(blockPos);
                bl = new BlockClickEvent(ClickType.RIGHT_CLICK, position, PacketCompatKt.getUsedItem((C08PacketPlayerBlockPlacement)packet)).post() || clickCancelled;
            } else {
                bl = clickCancelled;
            }
        } else if (packet instanceof C07PacketPlayerDigging && ((C07PacketPlayerDigging)packet).func_180762_c() == C07PacketPlayerDigging.Action.START_DESTROY_BLOCK) {
            ItemClickEvent itemClickEvent;
            BlockPos blockPos = ((C07PacketPlayerDigging)packet).func_179715_a();
            Intrinsics.checkNotNullExpressionValue(blockPos, "getPosition(...)");
            LorenzVec position = LorenzVecKt.toLorenzVec(blockPos);
            boolean blockClickCancelled = new BlockClickEvent(ClickType.LEFT_CLICK, position, InventoryUtils.INSTANCE.getItemInHand()).post();
            ItemClickEvent it = itemClickEvent = new ItemClickEvent(InventoryUtils.INSTANCE.getItemInHand(), ClickType.LEFT_CLICK);
            boolean bl3 = false;
            if (blockClickCancelled) {
                it.cancel();
            }
            bl = itemClickEvent.post();
        } else if (packet instanceof C0APacketAnimation) {
            bl = new ItemClickEvent(InventoryUtils.INSTANCE.getItemInHand(), ClickType.LEFT_CLICK).post();
        } else if (packet instanceof C02PacketUseEntity) {
            ClickType clickType;
            C02PacketUseEntity.Action action = ((C02PacketUseEntity)packet).func_149565_c();
            switch (action == null ? -1 : WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
                case 1: {
                    clickType = ClickType.RIGHT_CLICK;
                    break;
                }
                case 2: {
                    clickType = ClickType.LEFT_CLICK;
                    break;
                }
                case 3: {
                    clickType = ClickType.RIGHT_CLICK;
                    break;
                }
                default: {
                    return;
                }
            }
            ClickType clickType2 = clickType;
            Entity entity = ((C02PacketUseEntity)packet).func_149564_a((World)MinecraftCompat.INSTANCE.getLocalWorld());
            if (entity == null) {
                return;
            }
            Entity clickedEntity = entity;
            C02PacketUseEntity.Action action2 = ((C02PacketUseEntity)packet).func_149565_c();
            Intrinsics.checkNotNullExpressionValue(action2, "getAction(...)");
            bl = new EntityClickEvent(clickType2, action2, clickedEntity, InventoryUtils.INSTANCE.getItemInHand()).post();
        } else {
            return;
        }
        boolean cancelled = bl;
        if (cancelled) {
            event.cancel();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[C02PacketUseEntity.Action.values().length];
            try {
                nArray[C02PacketUseEntity.Action.INTERACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[C02PacketUseEntity.Action.ATTACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[C02PacketUseEntity.Action.INTERACT_AT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

