/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.slayer.SlayerConfig;
import at.hannibal2.skyhanni.config.features.slayer.SlayerProfitTrackerConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.ScoreboardData;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.SlayerQuestCompleteEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.events.slayer.SlayerChangeEvent;
import at.hannibal2.skyhanni.events.slayer.SlayerProgressChangeEvent;
import at.hannibal2.skyhanni.features.slayer.SlayerType;
import at.hannibal2.skyhanni.utils.ItemPriceUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.RecalculatingValue;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.collection.TimeLimitedCache;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.util.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0011\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001aR\u0011\u0010\"\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010&\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R8\u0010(\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\"\u0010+\u001a\u00020*8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\"\u00101\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b1\u0010\u0006\"\u0004\b3\u00104R\"\u00105\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u00102\u001a\u0004\b5\u0010\u0006\"\u0004\b6\u00104R\"\u00107\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\"\u0010=\u001a\u00020*8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010,\u001a\u0004\b>\u0010.\"\u0004\b?\u00100R\"\u0010@\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u00108\u001a\u0004\bA\u0010:\"\u0004\bB\u0010<R\u001d\u0010F\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010\u001aR\u001d\u0010I\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010D\u001a\u0004\bH\u0010\u001a\u00a8\u0006J"}, d2={"Lat/hannibal2/skyhanni/data/SlayerApi;", "", "<init>", "()V", "", "hasActiveSlayerQuest", "()Z", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "internalName", "", "amount", "Lkotlin/Pair;", "", "", "getItemNameAndPrice", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;I)Lkotlin/Pair;", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "grabActiveSlayer", "()Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;)V", "checkSlayerTypeForCurrentArea", "Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "config", "Lat/hannibal2/skyhanni/config/features/slayer/SlayerProfitTrackerConfig;", "getTrackerConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/SlayerProfitTrackerConfig;", "trackerConfig", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "nameCache", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "questStartTime", "J", "getQuestStartTime-uFjCsEo", "()J", "setQuestStartTime-gJLAdNM", "(J)V", "isInCorrectArea", "Z", "setInCorrectArea", "(Z)V", "isInAnyArea", "setInAnyArea", "latestSlayerCategory", "Ljava/lang/String;", "getLatestSlayerCategory", "()Ljava/lang/String;", "setLatestSlayerCategory", "(Ljava/lang/String;)V", "latestWrongAreaWarning", "getLatestWrongAreaWarning-uFjCsEo", "setLatestWrongAreaWarning-gJLAdNM", "latestSlayerProgress", "getLatestSlayerProgress", "setLatestSlayerProgress", "currentAreaType$delegate", "Lat/hannibal2/skyhanni/utils/RecalculatingValue;", "getCurrentAreaType", "currentAreaType", "activeSlayer$delegate", "getActiveSlayer", "activeSlayer", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSlayerApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlayerApi.kt\nat/hannibal2/skyhanni/data/SlayerApi\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,172:1\n381#2,7:173\n*S KotlinDebug\n*F\n+ 1 SlayerApi.kt\nat/hannibal2/skyhanni/data/SlayerApi\n*L\n50#1:173,7\n*E\n"})
public final class SlayerApi {
    @NotNull
    public static final SlayerApi INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final TimeLimitedCache<Pair<NeuInternalName, Integer>, Pair<String, Double>> nameCache;
    private static long questStartTime;
    private static boolean isInCorrectArea;
    private static boolean isInAnyArea;
    @NotNull
    private static String latestSlayerCategory;
    private static long latestWrongAreaWarning;
    @NotNull
    private static String latestSlayerProgress;
    @NotNull
    private static final RecalculatingValue currentAreaType$delegate;
    @NotNull
    private static final RecalculatingValue activeSlayer$delegate;

    private SlayerApi() {
    }

    @NotNull
    public final SlayerConfig getConfig() {
        return SkyHanniMod.feature.getSlayer();
    }

    private final SlayerProfitTrackerConfig getTrackerConfig() {
        return this.getConfig().getItemProfitTracker();
    }

    public final long getQuestStartTime-uFjCsEo() {
        return questStartTime;
    }

    public final void setQuestStartTime-gJLAdNM(long l) {
        questStartTime = l;
    }

    public final boolean isInCorrectArea() {
        return isInCorrectArea;
    }

    public final void setInCorrectArea(boolean bl) {
        isInCorrectArea = bl;
    }

    public final boolean isInAnyArea() {
        return isInAnyArea;
    }

    public final void setInAnyArea(boolean bl) {
        isInAnyArea = bl;
    }

    @NotNull
    public final String getLatestSlayerCategory() {
        return latestSlayerCategory;
    }

    public final void setLatestSlayerCategory(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        latestSlayerCategory = string;
    }

    public final long getLatestWrongAreaWarning-uFjCsEo() {
        return latestWrongAreaWarning;
    }

    public final void setLatestWrongAreaWarning-gJLAdNM(long l) {
        latestWrongAreaWarning = l;
    }

    @NotNull
    public final String getLatestSlayerProgress() {
        return latestSlayerProgress;
    }

    public final void setLatestSlayerProgress(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        latestSlayerProgress = string;
    }

    @Nullable
    public final SlayerType getCurrentAreaType() {
        return (SlayerType)((Object)currentAreaType$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]));
    }

    public final boolean hasActiveSlayerQuest() {
        return !Intrinsics.areEqual(latestSlayerCategory, "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<String, Double> getItemNameAndPrice(@NotNull NeuInternalName internalName2, int amount) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(internalName2, "internalName");
        Map map2 = nameCache;
        Pair<NeuInternalName, Integer> key$iv = TuplesKt.to(internalName2, amount);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            double price = ItemPriceUtils.getPrice$default(ItemPriceUtils.INSTANCE, internalName2, null, null, 3, null);
            Double d = ItemPriceUtils.INSTANCE.getNpcPriceOrNull(internalName2);
            double npcPrice = d != null ? d : 0.0;
            double maxPrice = RangesKt.coerceAtLeast(npcPrice, price);
            double totalPrice = maxPrice * (double)amount;
            Pair<String, Double> answer$iv = TuplesKt.to(ItemPriceUtils.INSTANCE.getPriceName(internalName2, amount, maxPrice), totalPrice);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Pair)object;
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.title("Slayer");
        if (!this.hasActiveSlayerQuest()) {
            event.addIrrelevant("no active slayer quest");
            return;
        }
        event.addData(SlayerApi::onDebug$lambda$3);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (StringsKt.contains$default((CharSequence)event.getMessage(), "\u00a7r\u00a75\u00a7lSLAYER QUEST STARTED!", false, 2, null)) {
            questStartTime = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        if (Intrinsics.areEqual(event.getMessage(), "  \u00a7r\u00a7a\u00a7lSLAYER QUEST COMPLETE!")) {
            SlayerQuestCompleteEvent.INSTANCE.post();
        }
    }

    @Nullable
    public final SlayerType getActiveSlayer() {
        return (SlayerType)((Object)activeSlayer$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]));
    }

    private final SlayerType grabActiveSlayer() {
        for (String line : ScoreboardData.INSTANCE.getSidebarLinesFormatted()) {
            SlayerType slayerType = SlayerType.Companion.getByName(line);
            if (slayerType == null) continue;
            SlayerType it = slayerType;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onTick(@NotNull SkyHanniTickEvent event) {
        String slayerProgress;
        String string;
        String slayerQuest;
        Intrinsics.checkNotNullParameter(event, "event");
        if (ProfileStorageData.INSTANCE.getProfileSpecific() == null) {
            return;
        }
        String string2 = CollectionUtils.nextAfter$default(CollectionUtils.INSTANCE, ScoreboardData.INSTANCE.getSidebarLinesFormatted(), "Slayer Quest", 0, 2, null);
        if (string2 == null) {
            string2 = "";
        }
        if (!Intrinsics.areEqual(slayerQuest = string2, latestSlayerCategory)) {
            String old = latestSlayerCategory;
            latestSlayerCategory = slayerQuest;
            new SlayerChangeEvent(old, latestSlayerCategory).post();
        }
        if ((string = CollectionUtils.INSTANCE.nextAfter(ScoreboardData.INSTANCE.getSidebarLinesFormatted(), "Slayer Quest", 2)) == null) {
            string = "";
        }
        if (!Intrinsics.areEqual(latestSlayerProgress, slayerProgress = string)) {
            new SlayerProgressChangeEvent(latestSlayerProgress, slayerProgress).post();
            latestSlayerProgress = slayerProgress;
        }
        if (SkyHanniTickEvent.isMod$default(event, 5, 0, 2, null)) {
            if (SkyBlockUtils.INSTANCE.isStrandedProfile()) {
                isInAnyArea = true;
                isInCorrectArea = true;
            } else {
                isInAnyArea = this.getCurrentAreaType() != null;
                isInCorrectArea = this.getCurrentAreaType() == this.getActiveSlayer() && this.getCurrentAreaType() != null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SlayerType checkSlayerTypeForCurrentArea() {
        String string = SkyBlockUtils.INSTANCE.getGraphArea();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 70896026: {
                if (string.equals("Soul Cave")) {
                    n = 1;
                }
                break;
            }
            case 1848022370: {
                if (string.equals("Burning Desert")) {
                    n = 2;
                }
                break;
            }
            case -2064970994: {
                if (string.equals("Spider Mound")) {
                    n = 2;
                }
                break;
            }
            case 1451041782: {
                if (string.equals("Stronghold")) {
                    n = 3;
                }
                break;
            }
            case -1508640612: {
                if (string.equals("Arachne's Sanctuary")) {
                    n = 2;
                }
                break;
            }
            case -1895003037: {
                if (string.equals("Zealot Bruiser Hideout")) {
                    n = 4;
                }
                break;
            }
            case -112831786: {
                if (string.equals("The Wasteland")) {
                    n = 3;
                }
                break;
            }
            case 79318699: {
                if (string.equals("Ruins")) {
                    n = 1;
                }
                break;
            }
            case 2109729867: {
                if (string.equals("no_area")) {
                    n = 5;
                }
                break;
            }
            case 963454073: {
                if (string.equals("Oubliette")) {
                    n = 6;
                }
                break;
            }
            case -602844313: {
                if (string.equals("Howling Cave")) {
                    n = 1;
                }
                break;
            }
            case 1036208985: {
                if (string.equals("Dragon's Nest")) {
                    n = 7;
                }
                break;
            }
            case -1562428315: {
                if (string.equals("Stillgore Ch\u00e2teau")) {
                    n = 6;
                }
                break;
            }
            case -1877764152: {
                if (string.equals("Smoldering Tomb")) {
                    n = 3;
                }
                break;
            }
            case 99519154: {
                if (string.equals("Revenant Cave")) {
                    n = 8;
                }
                break;
            }
            case -344012029: {
                if (string.equals("Arachne's Burrow")) {
                    n = 2;
                }
                break;
            }
            case -1293792676: {
                if (string.equals("Spirit Cave")) {
                    n = 1;
                }
                break;
            }
            case 1000395423: {
                if (string.equals("Graveyard")) {
                    n = 9;
                }
                break;
            }
            case 641884637: {
                if (string.equals("Void Sepulture")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 9: {
                if (!this.getTrackerConfig().getRevenantInGraveyard()) return null;
                if (!IslandType.HUB.isCurrent()) return null;
                SlayerType slayerType = SlayerType.REVENANT;
                return slayerType;
            }
            case 8: {
                SlayerType slayerType = SlayerType.REVENANT;
                return slayerType;
            }
            case 2: {
                SlayerType slayerType = SlayerType.TARANTULA;
                return slayerType;
            }
            case 1: {
                SlayerType slayerType = SlayerType.SVEN;
                return slayerType;
            }
            case 4: {
                SlayerType slayerType = SlayerType.VOID;
                return slayerType;
            }
            case 7: {
                if (!this.getTrackerConfig().getVoidgloomInNest()) return null;
                if (!IslandType.THE_END.isCurrent()) return null;
                SlayerType slayerType = SlayerType.VOID;
                return slayerType;
            }
            case 5: {
                if (!this.getTrackerConfig().getVoidgloomInNoArea()) return null;
                if (!IslandType.THE_END.isCurrent()) return null;
                SlayerType slayerType = SlayerType.VOID;
                return slayerType;
            }
            case 3: {
                SlayerType slayerType = SlayerType.INFERNO;
                return slayerType;
            }
            case 6: {
                SlayerType slayerType = SlayerType.VAMPIRE;
                return slayerType;
            }
            default: {
                return null;
            }
        }
    }

    private static final SlayerType currentAreaType_delegate$lambda$0() {
        return INSTANCE.checkSlayerTypeForCurrentArea();
    }

    private static final Unit onDebug$lambda$3(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("activeSlayer: " + (Object)((Object)INSTANCE.getActiveSlayer()));
        $this$addData.add("isInCorrectArea: " + isInCorrectArea);
        if (!isInCorrectArea) {
            $this$addData.add("currentAreaType: " + (Object)((Object)INSTANCE.getCurrentAreaType()));
            $this$addData.add(" graph area: " + SkyBlockUtils.INSTANCE.getGraphArea());
            BlockPos blockPos = MinecraftCompat.INSTANCE.getLocalPlayer().func_180425_c();
            Intrinsics.checkNotNullExpressionValue(blockPos, "getPosition(...)");
            LorenzVec $this$onDebug_u24lambda_u243_u24lambda_u242 = LorenzVecKt.toLorenzVec(blockPos).roundTo(1);
            boolean bl = false;
            $this$addData.add(" /shtestwaypoint " + $this$onDebug_u24lambda_u243_u24lambda_u242.getX() + ' ' + $this$onDebug_u24lambda_u243_u24lambda_u242.getY() + ' ' + $this$onDebug_u24lambda_u243_u24lambda_u242.getZ() + " pathfind");
        }
        $this$addData.add("isInAnyArea: " + isInAnyArea);
        $this$addData.add("latestSlayerProgress: " + StringUtils.removeColor$default(StringUtils.INSTANCE, latestSlayerProgress, false, 1, null));
        return Unit.INSTANCE;
    }

    private static final SlayerType activeSlayer_delegate$lambda$4() {
        return INSTANCE.grabActiveSlayer();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(SlayerApi.class, "currentAreaType", "getCurrentAreaType()Lat/hannibal2/skyhanni/features/slayer/SlayerType;", 0)), Reflection.property1(new PropertyReference1Impl(SlayerApi.class, "activeSlayer", "getActiveSlayer()Lat/hannibal2/skyhanni/features/slayer/SlayerType;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SlayerApi();
        nameCache = new TimeLimitedCache(DurationKt.toDuration(1, DurationUnit.MINUTES), null, 2, null);
        questStartTime = SimpleTimeMark.Companion.farPast();
        latestSlayerCategory = "";
        latestWrongAreaWarning = SimpleTimeMark.Companion.farPast();
        latestSlayerProgress = "";
        currentAreaType$delegate = new RecalculatingValue(DurationKt.toDuration(500, DurationUnit.MILLISECONDS), SlayerApi::currentAreaType_delegate$lambda$0, null);
        activeSlayer$delegate = new RecalculatingValue(DurationKt.toDuration(1, DurationUnit.SECONDS), SlayerApi::activeSlayer_delegate$lambda$4, null);
    }
}

