/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.internal;

import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.MyResourceLocation;
import at.hannibal2.skyhanni.deps.moulconfig.common.TextureFilter;
import at.hannibal2.skyhanni.deps.moulconfig.internal.StackUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterAssertionCache {
    private static final Map<MyResourceLocation, TextureFilterAssertion> PERMANENT = new HashMap<MyResourceLocation, TextureFilterAssertion>();
    private static final Map<MyResourceLocation, TextureFilterAssertion> TEMPORARY = new HashMap<MyResourceLocation, TextureFilterAssertion>();

    public static void destroyGlobalFilter(MyResourceLocation resourceLocation) {
        PERMANENT.remove(resourceLocation);
        TEMPORARY.remove(resourceLocation);
    }

    public static void assertTextureFilter(MyResourceLocation resourceLocation, TextureFilter filter2) {
        Map<MyResourceLocation, TextureFilterAssertion> set = IMinecraft.INSTANCE.isGeneratedSentinel(resourceLocation) ? TEMPORARY : PERMANENT;
        TextureFilterAssertion existing = set.get(resourceLocation);
        Supplier<StackUtil> stack = () -> StackUtil.getWalker().skipWhile(StackUtil.defaultSkips().or(it -> !it.getClassName().startsWith(StackUtil.MOULCONFIG_BASE_PACKAGE + ".internal.") && !it.getClassName().startsWith(StackUtil.MOULCONFIG_BASE_PACKAGE + ".platform.")));
        if (existing == null) {
            set.put(resourceLocation, new TextureFilterAssertion(stack.get().takeOne(), filter2));
        } else if (existing.getFilter() != filter2) {
            stack.get().warn("setting filter to " + (Object)((Object)filter2) + " despite filter originally being set to " + (Object)((Object)existing.getFilter()) + " by " + existing.getAssertedBy());
        }
    }

    public static final class TextureFilterAssertion {
        @Nullable
        private final StackTraceElement assertedBy;
        @NotNull
        private final TextureFilter filter;

        public TextureFilterAssertion(@Nullable StackTraceElement assertedBy, @NotNull TextureFilter filter2) {
            if (filter2 == null) {
                throw new NullPointerException("filter is marked non-null but is null");
            }
            this.assertedBy = assertedBy;
            this.filter = filter2;
        }

        @Nullable
        public StackTraceElement getAssertedBy() {
            return this.assertedBy;
        }

        @NotNull
        public TextureFilter getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextureFilterAssertion)) {
                return false;
            }
            TextureFilterAssertion other = (TextureFilterAssertion)o;
            StackTraceElement this$assertedBy = this.getAssertedBy();
            StackTraceElement other$assertedBy = other.getAssertedBy();
            if (this$assertedBy == null ? other$assertedBy != null : !((Object)this$assertedBy).equals(other$assertedBy)) {
                return false;
            }
            TextureFilter this$filter = this.getFilter();
            TextureFilter other$filter = other.getFilter();
            return !(this$filter == null ? other$filter != null : !((Object)((Object)this$filter)).equals((Object)other$filter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            StackTraceElement $assertedBy = this.getAssertedBy();
            result2 = result2 * 59 + ($assertedBy == null ? 43 : ((Object)$assertedBy).hashCode());
            TextureFilter $filter = this.getFilter();
            result2 = result2 * 59 + ($filter == null ? 43 : ((Object)((Object)$filter)).hashCode());
            return result2;
        }

        public String toString() {
            return "FilterAssertionCache.TextureFilterAssertion(assertedBy=" + this.getAssertedBy() + ", filter=" + (Object)((Object)this.getFilter()) + ")";
        }
    }
}

