/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.observer;

import at.hannibal2.skyhanni.deps.moulconfig.observer.BaseObservable;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Observable;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Observer;
import java.util.function.Function;

public class MapObservable<T, V>
extends BaseObservable<V>
implements Observer<T> {
    V value;
    Observable<T> root;
    Function<T, V> mapper;

    MapObservable(Observable<T> root, Function<T, V> mapper) {
        this.root = root;
        this.mapper = mapper;
        this.value = mapper.apply(root.get());
        root.addObserver(this);
    }

    @Override
    public V get() {
        return this.value;
    }

    @Override
    public void observeChange(T oldT, T newT) {
        V oldV = this.value;
        this.value = this.mapper.apply(newT);
        this.notifyObservers(oldV, this.value);
    }
}

