/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming.lane;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.laneswitch.FarmingLaneConfig;
import at.hannibal2.skyhanni.config.features.garden.laneswitch.LaneSwitchNotificationConfig;
import at.hannibal2.skyhanni.config.features.garden.laneswitch.LaneSwitchSoundSettings;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.title.TitleContext;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.garden.GardenToolChangeEvent;
import at.hannibal2.skyhanni.events.garden.farming.FarmingLaneSwitchEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingDirection;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingLane;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingLaneApi;
import at.hannibal2.skyhanni.features.misc.MovementSpeedDisplay;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001AB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u000f\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u000fJ\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010\u001f\u001a\u00020\u001e*\u00020\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b$\u0010\u0003R\u0011\u0010(\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0018\u0010)\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0018\u00102\u001a\u0004\u0018\u0001018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0018\u00105\u001a\u0004\u0018\u0001048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00107\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u0010,R\u0016\u00109\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010;\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010:R\u0016\u0010<\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010@\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010=\u00a8\u0006B"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/garden/farming/FarmingLaneSwitchEvent;", "event", "", "onFarmingLaneSwitch", "(Lat/hannibal2/skyhanni/events/garden/farming/FarmingLaneSwitchEvent;)V", "Lat/hannibal2/skyhanni/events/garden/GardenToolChangeEvent;", "onGardenToolChange", "(Lat/hannibal2/skyhanni/events/garden/GardenToolChangeEvent;)V", "onTick", "", "calculateDistance", "()Z", "", "newPosition", "", "calculateDirection", "(D)Ljava/lang/Integer;", "showWarning", "calculateSpeed", "speed", "Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures$MovementState;", "calculateMovementState", "(D)Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures$MovementState;", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "capAtBuildHeight", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "playUserSound", "Lat/hannibal2/skyhanni/config/features/garden/laneswitch/FarmingLaneConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/laneswitch/FarmingLaneConfig;", "config", "currentPosition", "Ljava/lang/Double;", "currentDistance", "D", "", "", "display", "Ljava/util/List;", "Lat/hannibal2/skyhanni/data/title/TitleContext;", "titleContext", "Lat/hannibal2/skyhanni/data/title/TitleContext;", "Lkotlin/time/Duration;", "timeRemaining", "Lkotlin/time/Duration;", "lastSpeed", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastTimeFarming", "J", "lastPlaySound", "lastDirection", "I", "movementState", "Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures$MovementState;", "sameSpeedCounter", "MovementState", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFarmingLaneFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FarmingLaneFeatures.kt\nat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
public final class FarmingLaneFeatures {
    @NotNull
    public static final FarmingLaneFeatures INSTANCE = new FarmingLaneFeatures();
    @Nullable
    private static Double currentPosition;
    private static double currentDistance;
    @NotNull
    private static List<String> display;
    @Nullable
    private static TitleContext titleContext;
    @Nullable
    private static Duration timeRemaining;
    private static double lastSpeed;
    private static long lastTimeFarming;
    private static long lastPlaySound;
    private static int lastDirection;
    @NotNull
    private static MovementState movementState;
    private static int sameSpeedCounter;

    private FarmingLaneFeatures() {
    }

    @NotNull
    public final FarmingLaneConfig getConfig() {
        return FarmingLaneApi.INSTANCE.getConfig();
    }

    @HandleEvent
    public final void onFarmingLaneSwitch(@NotNull FarmingLaneSwitchEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        display = CollectionsKt.emptyList();
    }

    @HandleEvent
    public final void onGardenToolChange(@NotNull GardenToolChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        display = CollectionsKt.emptyList();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onTick() {
        if (!this.getConfig().getDistanceDisplay() && !this.getConfig().getLaneSwitchNotification().getEnabled()) {
            return;
        }
        if (!this.calculateDistance()) {
            return;
        }
        if (!GardenApi.INSTANCE.isCurrentlyFarming()) {
            return;
        }
        if (this.calculateSpeed()) {
            this.showWarning();
        }
        if (this.getConfig().getDistanceDisplay()) {
            List<String> list;
            List<String> $this$onTick_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$onTick_u24lambda_u240.add("\u00a77Distance until switch: \u00a7e" + NumberUtil.INSTANCE.roundTo(currentDistance, 1));
            boolean normal = movementState == MovementState.NORMAL;
            String color = normal ? "\u00a7b" : "\u00a78";
            Duration duration = timeRemaining;
            if (duration == null) {
            } else {
                long timeRemaining = duration.unbox-impl();
                String format = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, timeRemaining, null, Duration.compareTo-LRDsOJo(timeRemaining, DurationKt.toDuration(20, DurationUnit.SECONDS)) < 0, false, 0, false, false, 61, null);
                String suffix = !normal ? " \u00a77(" + movementState.getLabel() + "\u00a77)" : "";
                $this$onTick_u24lambda_u240.add("\u00a77Time remaining: " + color + format + suffix);
                if (MovementSpeedDisplay.INSTANCE.getUsingLegacySoulSandSpeed() && INSTANCE.getConfig().getDistanceSoulSandWarning()) {
                    $this$onTick_u24lambda_u240.add("\u00a77Using inaccurate soul sand speed!");
                }
            }
            display = CollectionsKt.build(list);
        }
    }

    private final boolean calculateDistance() {
        boolean outside;
        FarmingLane farmingLane = FarmingLaneApi.INSTANCE.getCurrentLane();
        if (farmingLane == null) {
            return false;
        }
        FarmingLane lane = farmingLane;
        double min = lane.getMin();
        double max = lane.getMax();
        double position = FarmingLaneApi.INSTANCE.getValue(lane.getDirection(), LocationUtils.INSTANCE.playerLocation());
        boolean bl = outside = !(min <= position ? position <= max : false);
        if (outside) {
            display = CollectionsKt.emptyList();
            return false;
        }
        Integer n = this.calculateDirection(position);
        if (n == null) {
            return false;
        }
        int direction = n;
        switch (direction) {
            case 1: {
                double d = Math.abs(min - position);
                break;
            }
            case -1: {
                double d = Math.abs(max - position);
                break;
            }
            default: {
                double d = currentDistance = currentDistance;
            }
        }
        if (direction != lastDirection) {
            lastTimeFarming = SimpleTimeMark.Companion.farPast();
            lastDirection = direction;
        }
        return true;
    }

    private final Integer calculateDirection(double newPosition) {
        Double d = currentPosition;
        if (d == null) {
            FarmingLaneFeatures $this$calculateDirection_u24lambda_u241 = this;
            boolean bl = false;
            currentPosition = newPosition;
            return null;
        }
        double position = d;
        currentPosition = newPosition;
        double diff = position - newPosition;
        return diff > 0.0 ? Integer.valueOf(1) : (diff < 0.0 ? Integer.valueOf(-1) : Integer.valueOf(0));
    }

    private final void showWarning() {
        TitleContext titleContext;
        LaneSwitchNotificationConfig $this$showWarning_u24lambda_u243 = this.getConfig().getLaneSwitchNotification();
        boolean bl = false;
        if (!$this$showWarning_u24lambda_u243.getEnabled()) {
            return;
        }
        if (FarmingLaneFeatures.titleContext == null) {
            titleContext = TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, StringsKt.replace$default($this$showWarning_u24lambda_u243.getText(), "&", "\u00a7", false, 4, null), null, DurationKt.toDuration($this$showWarning_u24lambda_u243.getSecondsBefore(), DurationUnit.SECONDS), null, null, null, 1.1, false, false, null, 0L, null, null, 0L, 16314, null);
        } else {
            TitleContext titleContext2;
            TitleContext it = titleContext2 = FarmingLaneFeatures.titleContext;
            boolean bl2 = false;
            TitleContext titleContext3 = it;
            titleContext = FarmingLaneFeatures.titleContext = (titleContext3 != null ? titleContext3.getAlive() : false) ? titleContext2 : null;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastPlaySound), TimeUtils.INSTANCE.getTicks-5sfh64U($this$showWarning_u24lambda_u243.getSound().getRepeatDuration())) >= 0) {
            lastPlaySound = SimpleTimeMark.Companion.now-uFjCsEo();
            FarmingLaneFeatures.playUserSound();
        }
    }

    private final boolean calculateSpeed() {
        double speed = NumberUtil.INSTANCE.roundTo(MovementSpeedDisplay.INSTANCE.getSpeed(), 2);
        movementState = this.calculateMovementState(speed);
        if (movementState != MovementState.NORMAL) {
            return false;
        }
        long timeRemaining = DurationKt.toDuration(currentDistance / speed, DurationUnit.SECONDS);
        FarmingLaneFeatures.timeRemaining = Duration.box-impl(timeRemaining);
        long warnAt = DurationKt.toDuration(this.getConfig().getLaneSwitchNotification().getSecondsBefore(), DurationUnit.SECONDS);
        if (Duration.compareTo-LRDsOJo(timeRemaining, warnAt) >= 0) {
            lastTimeFarming = SimpleTimeMark.Companion.now-uFjCsEo();
            return false;
        }
        return Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastTimeFarming), warnAt) < 0;
    }

    private final MovementState calculateMovementState(double speed) {
        boolean speedTooSlow;
        if (!(lastSpeed == speed)) {
            lastSpeed = speed;
            sameSpeedCounter = 0;
        }
        int n = sameSpeedCounter;
        sameSpeedCounter = n + 1;
        if (speed == 0.0 && sameSpeedCounter > 1) {
            return MovementState.NOT_MOVING;
        }
        boolean bl = speedTooSlow = speed < 1.0;
        if (speedTooSlow && sameSpeedCounter > 5) {
            return MovementState.TOO_SLOW;
        }
        if (!MovementSpeedDisplay.INSTANCE.getUsingLegacySoulSandSpeed() && sameSpeedCounter < 6) {
            return MovementState.CALCULATING;
        }
        return MovementState.NORMAL;
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getCornerWaypoints()) {
            return;
        }
        FarmingLane farmingLane = FarmingLaneApi.INSTANCE.getCurrentLane();
        if (farmingLane == null) {
            return;
        }
        FarmingLane lane = farmingLane;
        FarmingDirection direction = lane.getDirection();
        LorenzVec location = LocationUtils.INSTANCE.playerLocation();
        LorenzVec min = this.capAtBuildHeight(FarmingLaneApi.INSTANCE.setValue(direction, location, lane.getMin()));
        LorenzVec max = this.capAtBuildHeight(FarmingLaneApi.INSTANCE.setValue(direction, location, lane.getMax()));
        WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, min, LorenzColor.YELLOW.toColor(), false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
        WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, min, "\u00a7eLane Corner", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, max, LorenzColor.YELLOW.toColor(), false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
        WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, max, "\u00a7eLane Corner", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
    }

    private final LorenzVec capAtBuildHeight(LorenzVec $this$capAtBuildHeight) {
        return $this$capAtBuildHeight.getY() > 76.0 ? LorenzVec.copy$default($this$capAtBuildHeight, 0.0, 76.0, 0.0, 5, null) : $this$capAtBuildHeight;
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getDistanceDisplay()) {
            return;
        }
        RenderUtils.renderStrings$default(RenderUtils.INSTANCE, this.getConfig().getDistanceDisplayPosition(), display, 0, "Lane Display", 2, null);
    }

    @JvmStatic
    public static final void playUserSound() {
        LaneSwitchSoundSettings $this$playUserSound_u24lambda_u244 = INSTANCE.getConfig().getLaneSwitchNotification().getSound();
        boolean bl = false;
        SoundUtils.INSTANCE.playSound(SoundUtils.createSound$default(SoundUtils.INSTANCE, $this$playUserSound_u24lambda_u244.getName(), $this$playUserSound_u24lambda_u244.getPitch(), 0.0f, 4, null));
    }

    static {
        display = CollectionsKt.emptyList();
        lastTimeFarming = SimpleTimeMark.Companion.farPast();
        lastPlaySound = SimpleTimeMark.Companion.farPast();
        movementState = MovementState.CALCULATING;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures$MovementState;", "", "", "label", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getLabel", "()Ljava/lang/String;", "NOT_MOVING", "TOO_SLOW", "CALCULATING", "NORMAL", "1.8.9"})
    public static final class MovementState
    extends Enum<MovementState> {
        @NotNull
        private final String label;
        public static final /* enum */ MovementState NOT_MOVING = new MovementState("\u00a7ePaused");
        public static final /* enum */ MovementState TOO_SLOW = new MovementState("\u00a7cToo slow!");
        public static final /* enum */ MovementState CALCULATING = new MovementState("\u00a7aCalculating..");
        public static final /* enum */ MovementState NORMAL = new MovementState("");
        private static final /* synthetic */ MovementState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MovementState(String label) {
            this.label = label;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public static MovementState[] values() {
            return (MovementState[])$VALUES.clone();
        }

        public static MovementState valueOf(String value) {
            return Enum.valueOf(MovementState.class, value);
        }

        @NotNull
        public static EnumEntries<MovementState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = movementStateArray = new MovementState[]{MovementState.NOT_MOVING, MovementState.TOO_SLOW, MovementState.CALCULATING, MovementState.NORMAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

