/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.sensitivity;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.SensitivityReducerConfig;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R*\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00158\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/features/garden/sensitivity/MouseSensitivityManager;", "", "<init>", "()V", "", "original", "getSensitivity", "(F)F", "", "destroyCache", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/SensitivityReducerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/SensitivityReducerConfig;", "config", "lastIn", "F", "lastOut", "Lat/hannibal2/skyhanni/features/garden/sensitivity/MouseSensitivityManager$SensitivityState;", "value", "state", "Lat/hannibal2/skyhanni/features/garden/sensitivity/MouseSensitivityManager$SensitivityState;", "getState", "()Lat/hannibal2/skyhanni/features/garden/sensitivity/MouseSensitivityManager$SensitivityState;", "setState", "(Lat/hannibal2/skyhanni/features/garden/sensitivity/MouseSensitivityManager$SensitivityState;)V", "SensitivityState", "1.8.9"})
public final class MouseSensitivityManager {
    @NotNull
    public static final MouseSensitivityManager INSTANCE = new MouseSensitivityManager();
    private static float lastIn = Float.NaN;
    private static float lastOut = Float.NaN;
    @NotNull
    private static SensitivityState state = SensitivityState.UNCHANGED;

    private MouseSensitivityManager() {
    }

    private final SensitivityReducerConfig getConfig() {
        return SkyHanniMod.feature.getGarden().getSensitivityReducer();
    }

    @NotNull
    public final SensitivityState getState() {
        return state;
    }

    public final void setState(@NotNull SensitivityState value) {
        Intrinsics.checkNotNullParameter((Object)value, "value");
        state = value;
        this.destroyCache();
    }

    public final float getSensitivity(float original) {
        if (!(original == lastIn)) {
            lastIn = original;
            lastOut = state.apply(original);
        }
        return lastOut;
    }

    public final void destroyCache() {
        lastIn = Float.NaN;
        lastOut = Float.NaN;
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.title("Mouse Sensitivity");
        if (SensitivityState.UNCHANGED.isActive()) {
            event.addIrrelevant("not enabled");
            return;
        }
        event.addData(MouseSensitivityManager::onDebug$lambda$0);
    }

    private static final Unit onDebug$lambda$0(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("current state: " + (Object)((Object)state));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/features/garden/sensitivity/MouseSensitivityManager$SensitivityState;", "", "Lkotlin/Function1;", "", "transform", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "original", "apply", "(F)F", "", "isActive", "()Z", "Lkotlin/jvm/functions/Function1;", "UNCHANGED", "LOCKED", "AUTO_REDUCED", "MANUAL_REDUCED", "1.8.9"})
    public static final class SensitivityState
    extends Enum<SensitivityState> {
        @NotNull
        private final Function1<Float, Float> transform;
        public static final /* enum */ SensitivityState UNCHANGED = new SensitivityState(SensitivityState::_init_$lambda$0);
        public static final /* enum */ SensitivityState LOCKED = new SensitivityState(SensitivityState::_init_$lambda$1);
        public static final /* enum */ SensitivityState AUTO_REDUCED = new SensitivityState(SensitivityState::_init_$lambda$2);
        public static final /* enum */ SensitivityState MANUAL_REDUCED = new SensitivityState(SensitivityState::_init_$lambda$3);
        private static final /* synthetic */ SensitivityState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SensitivityState(Function1<? super Float, Float> transform2) {
            this.transform = transform2;
        }

        public final float apply(float original) {
            return ((Number)this.transform.invoke(Float.valueOf(original))).floatValue();
        }

        public final boolean isActive() {
            return this == INSTANCE.getState();
        }

        public static SensitivityState[] values() {
            return (SensitivityState[])$VALUES.clone();
        }

        public static SensitivityState valueOf(String value) {
            return Enum.valueOf(SensitivityState.class, value);
        }

        @NotNull
        public static EnumEntries<SensitivityState> getEntries() {
            return $ENTRIES;
        }

        private static final float _init_$lambda$0(float it) {
            return it;
        }

        private static final float _init_$lambda$1(float f) {
            return -0.33333334f;
        }

        private static final float _init_$lambda$2(float it) {
            Object t = INSTANCE.getConfig().getReducingFactor().get();
            Intrinsics.checkNotNullExpressionValue(t, "get(...)");
            return (it + 0.33333334f) / ((Number)t).floatValue() - 0.33333334f;
        }

        private static final float _init_$lambda$3(float it) {
            Object t = INSTANCE.getConfig().getReducingFactor().get();
            Intrinsics.checkNotNullExpressionValue(t, "get(...)");
            return (it + 0.33333334f) / ((Number)t).floatValue() - 0.33333334f;
        }

        static {
            $VALUES = sensitivityStateArray = new SensitivityState[]{SensitivityState.UNCHANGED, SensitivityState.LOCKED, SensitivityState.AUTO_REDUCED, SensitivityState.MANUAL_REDUCED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

