/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.GetFromSackApi;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.mining.MiningNotificationsConfig;
import at.hannibal2.skyhanni.data.IslandTypeTags;
import at.hannibal2.skyhanni.data.MiningApi;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ColdUpdateEvent;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0019\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001b\u0010\"\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u001b\u0010%\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001f\u001a\u0004\b$\u0010!R\u001b\u0010(\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u001f\u001a\u0004\b'\u0010!R\u001b\u0010+\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u001f\u001a\u0004\b*\u0010!R\u0014\u0010/\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0016\u00101\u001a\u0002008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00103\u001a\u0002008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00102\u00a8\u00065"}, d2={"Lat/hannibal2/skyhanni/features/mining/MiningNotifications;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/ColdUpdateEvent;", "onColdUpdate", "(Lat/hannibal2/skyhanni/events/ColdUpdateEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/features/mining/MiningNotifications$MiningNotificationList;", "type", "sendNotification", "(Lat/hannibal2/skyhanni/features/mining/MiningNotifications$MiningNotificationList;)V", "Lat/hannibal2/skyhanni/utils/PrimitiveItemStack;", "ASCENSION_ROPE$delegate", "Lkotlin/Lazy;", "getASCENSION_ROPE", "()Lat/hannibal2/skyhanni/utils/PrimitiveItemStack;", "ASCENSION_ROPE", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "mineshaftSpawn$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getMineshaftSpawn", "()Ljava/util/regex/Pattern;", "mineshaftSpawn", "scrapDrop$delegate", "getScrapDrop", "scrapDrop", "goldenGoblinSpawn$delegate", "getGoldenGoblinSpawn", "goldenGoblinSpawn", "diamondGoblinSpawn$delegate", "getDiamondGoblinSpawn", "diamondGoblinSpawn", "Lat/hannibal2/skyhanni/config/features/mining/MiningNotificationsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/MiningNotificationsConfig;", "config", "", "hasSentCold", "Z", "hasSentAscensionRope", "MiningNotificationList", "1.8.9"})
public final class MiningNotifications {
    @NotNull
    public static final MiningNotifications INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final Lazy ASCENSION_ROPE$delegate;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern mineshaftSpawn$delegate;
    @NotNull
    private static final RepoPattern scrapDrop$delegate;
    @NotNull
    private static final RepoPattern goldenGoblinSpawn$delegate;
    @NotNull
    private static final RepoPattern diamondGoblinSpawn$delegate;
    private static boolean hasSentCold;
    private static boolean hasSentAscensionRope;

    private MiningNotifications() {
    }

    private final PrimitiveItemStack getASCENSION_ROPE() {
        Lazy lazy = ASCENSION_ROPE$delegate;
        return (PrimitiveItemStack)lazy.getValue();
    }

    @NotNull
    public final Pattern getMineshaftSpawn() {
        return (Pattern)mineshaftSpawn$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getScrapDrop() {
        return (Pattern)scrapDrop$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @NotNull
    public final Pattern getGoldenGoblinSpawn() {
        return (Pattern)goldenGoblinSpawn$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    @NotNull
    public final Pattern getDiamondGoblinSpawn() {
        return (Pattern)diamondGoblinSpawn$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    private final MiningNotificationsConfig getConfig() {
        return SkyHanniMod.feature.getMining().getNotifications();
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!IslandTypeTags.INSTANCE.getMINING().inAny()) {
            return;
        }
        if (!this.getConfig().getEnabled()) {
            return;
        }
        String message = event.getMessage();
        if (RegexUtils.INSTANCE.matches(this.getMineshaftSpawn(), message)) {
            this.sendNotification(MiningNotificationList.MINESHAFT_SPAWN);
        } else if (RegexUtils.INSTANCE.matches(this.getScrapDrop(), message)) {
            this.sendNotification(MiningNotificationList.SCRAP);
        } else if (RegexUtils.INSTANCE.matches(this.getGoldenGoblinSpawn(), message)) {
            this.sendNotification(MiningNotificationList.GOLDEN_GOBLIN);
        } else if (RegexUtils.INSTANCE.matches(this.getDiamondGoblinSpawn(), message)) {
            this.sendNotification(MiningNotificationList.DIAMOND_GOBLIN);
        }
    }

    @HandleEvent
    public final void onColdUpdate(@NotNull ColdUpdateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!MiningApi.INSTANCE.inGlaciteArea()) {
            return;
        }
        if (!this.getConfig().getEnabled()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(MiningApi.INSTANCE.getLastColdReset-uFjCsEo()), DurationKt.toDuration(1, DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (event.getCold() >= ((Number)this.getConfig().getColdThreshold().get()).intValue() && !hasSentCold) {
            hasSentCold = true;
            this.sendNotification(MiningNotificationList.COLD);
        }
        if (MiningApi.INSTANCE.inMineshaft() && this.getConfig().getGetAscensionRope() && event.getCold() >= this.getConfig().getColdAmount() && !hasSentAscensionRope) {
            hasSentAscensionRope = true;
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(0.5, DurationUnit.SECONDS), MiningNotifications::onColdUpdate$lambda$1);
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        hasSentCold = false;
        hasSentAscensionRope = false;
    }

    @HandleEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Property[] propertyArray = new Property[]{this.getConfig().getColdThreshold()};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, MiningNotifications::onConfigLoad$lambda$2);
    }

    private final void sendNotification(MiningNotificationList type2) {
        if (!this.getConfig().getNotifications().contains((Object)type2)) {
            return;
        }
        TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, type2.getNotification(), null, DurationKt.toDuration(1.5, DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
        if (this.getConfig().getPlaySound()) {
            SoundUtils.INSTANCE.playPlingSound();
        }
    }

    private static final PrimitiveItemStack ASCENSION_ROPE_delegate$lambda$0() {
        return PrimitiveItemStack.Companion.makePrimitiveStack(NeuInternalName.Companion.toInternalName("ASCENSION_ROPE"), 1);
    }

    private static final Unit onColdUpdate$lambda$1() {
        GetFromSackApi.getFromChatMessageSackItems$default(GetFromSackApi.INSTANCE, INSTANCE.getASCENSION_ROPE(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final void onConfigLoad$lambda$2() {
        Integer n = (Integer)INSTANCE.getConfig().getColdThreshold().get();
        if (n == null || MiningApi.INSTANCE.getCold() != n.intValue()) {
            hasSentCold = false;
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MiningNotifications.class, "mineshaftSpawn", "getMineshaftSpawn()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MiningNotifications.class, "scrapDrop", "getScrapDrop()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MiningNotifications.class, "goldenGoblinSpawn", "getGoldenGoblinSpawn()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MiningNotifications.class, "diamondGoblinSpawn", "getDiamondGoblinSpawn()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new MiningNotifications();
        ASCENSION_ROPE$delegate = LazyKt.lazy(MiningNotifications::ASCENSION_ROPE_delegate$lambda$0);
        patternGroup = RepoPattern.Companion.group("mining.notifications");
        mineshaftSpawn$delegate = patternGroup.pattern("mineshaft.spawn", "\u00a75\u00a7lWOW! \u00a7r\u00a7aYou found a \u00a7r\u00a7bGlacite Mineshaft \u00a7r\u00a7aportal!");
        scrapDrop$delegate = patternGroup.pattern("scrapdrop", "\u00a76\u00a7lEXCAVATOR! \u00a7r\u00a7fYou found a \u00a7r\u00a79Suspicious Scrap\u00a7r\u00a7f!");
        goldenGoblinSpawn$delegate = patternGroup.pattern("goblin.goldspawn", "\u00a76A Golden Goblin has spawned!");
        diamondGoblinSpawn$delegate = patternGroup.pattern("goblin.diamondspawn", "\u00a76A \u00a7r\u00a7bDiamond Goblin \u00a7r\u00a76has spawned!");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\u000b\u0010\bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lat/hannibal2/skyhanni/features/mining/MiningNotifications$MiningNotificationList;", "", "", "str", "notification", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getStr", "getNotification", "MINESHAFT_SPAWN", "SCRAP", "GOLDEN_GOBLIN", "DIAMOND_GOBLIN", "COLD", "1.8.9"})
    public static final class MiningNotificationList
    extends Enum<MiningNotificationList> {
        @NotNull
        private final String str;
        @NotNull
        private final String notification;
        public static final /* enum */ MiningNotificationList MINESHAFT_SPAWN = new MiningNotificationList("\u00a7bGlacite Mineshaft", "\u00a7bMineshaft");
        public static final /* enum */ MiningNotificationList SCRAP = new MiningNotificationList("\u00a79Suspicious Scrap", "\u00a79Suspicious Scrap");
        public static final /* enum */ MiningNotificationList GOLDEN_GOBLIN = new MiningNotificationList("\u00a76Golden Goblin", "\u00a76Golden Goblin");
        public static final /* enum */ MiningNotificationList DIAMOND_GOBLIN = new MiningNotificationList("\u00a7bDiamond Goblin", "\u00a7bDiamond Goblin");
        public static final /* enum */ MiningNotificationList COLD = new MiningNotificationList("\u00a7bCold", "\u00a7bCold");
        private static final /* synthetic */ MiningNotificationList[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MiningNotificationList(String str, String notification) {
            this.str = str;
            this.notification = notification;
        }

        @NotNull
        public final String getStr() {
            return this.str;
        }

        @NotNull
        public final String getNotification() {
            return this.notification;
        }

        @NotNull
        public String toString() {
            return this.str;
        }

        public static MiningNotificationList[] values() {
            return (MiningNotificationList[])$VALUES.clone();
        }

        public static MiningNotificationList valueOf(String value) {
            return Enum.valueOf(MiningNotificationList.class, value);
        }

        @NotNull
        public static EnumEntries<MiningNotificationList> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = miningNotificationListArray = new MiningNotificationList[]{MiningNotificationList.MINESHAFT_SPAWN, MiningNotificationList.SCRAP, MiningNotificationList.GOLDEN_GOBLIN, MiningNotificationList.DIAMOND_GOBLIN, MiningNotificationList.COLD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

