/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.data.EntityData;
import at.hannibal2.skyhanni.events.entity.EntityRemovedEvent;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={World.class})
public class MixinWorld {
    @Inject(method={"unloadEntities"}, at={@At(value="HEAD")})
    private void unloadEntities(Collection<Entity> entityCollection, CallbackInfo ci) {
        for (Entity entity : entityCollection) {
            EntityData.despawnEntity(entity);
        }
    }

    @Inject(method={"onEntityRemoved"}, at={@At(value="HEAD")})
    private void onEntityRemoved(Entity entityIn, CallbackInfo ci) {
        EntityData.despawnEntity(entityIn);
        new EntityRemovedEvent<Entity>(entityIn).post();
    }
}

