/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.utils.LorenzVec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/utils/BezierCurve;", "", "", "", "coefficients", "<init>", "(Ljava/util/List;)V", "", "t", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "derivativeAt", "(D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "at", "Ljava/util/List;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPolynomialFitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolynomialFitter.kt\nat/hannibal2/skyhanni/utils/BezierCurve\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1#2:118\n1557#3:119\n1628#3,3:120\n1557#3:123\n1628#3,3:124\n*S KotlinDebug\n*F\n+ 1 PolynomialFitter.kt\nat/hannibal2/skyhanni/utils/BezierCurve\n*L\n96#1:119\n96#1:120,3\n107#1:123\n107#1:124,3\n*E\n"})
public final class BezierCurve {
    @NotNull
    private final List<double[]> coefficients;

    public BezierCurve(@NotNull List<double[]> coefficients) {
        Intrinsics.checkNotNullParameter(coefficients, "coefficients");
        this.coefficients = coefficients;
        if (!(this.coefficients.size() == 3)) {
            boolean bl = false;
            String string = "Coefficients must be for a 3d curve!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LorenzVec derivativeAt(double t) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.coefficients;
        LorenzVec.Companion companion = LorenzVec.Companion;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double[] dArray = (double[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double result2 = 0.0;
            List<Double> reversed = ArraysKt.dropLast(ArraysKt.reversedArray((double[])it), 1);
            Iterator iterator2 = ((Iterable)reversed).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i2 = n++;
                double coeff = ((Number)iterator2.next()).doubleValue();
                result2 = result2 * t + coeff * (double)(reversed.size() - i2);
            }
            collection.add(result2);
        }
        return companion.toLorenzVec((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LorenzVec at(double t) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.coefficients;
        LorenzVec.Companion companion = LorenzVec.Companion;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double[] dArray = (double[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double result2 = 0.0;
            List<Double> reversed = ArraysKt.reversed((double[])it);
            Iterator<Double> iterator2 = reversed.iterator();
            while (iterator2.hasNext()) {
                double coeff = ((Number)iterator2.next()).doubleValue();
                result2 = result2 * t + coeff;
            }
            collection.add(result2);
        }
        return companion.toLorenzVec((List)destination$iv$iv);
    }
}

