/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.utils.compat.InventoryCompat;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2DPacketOpenWindow;
import net.minecraft.network.play.server.S2EPacketCloseWindow;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0011\u0010 \u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Lat/hannibal2/skyhanni/data/OtherInventoryData;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$CloseWindowEvent;", "event", "", "onCloseWindow", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$CloseWindowEvent;)V", "", "title", "", "reopenSameName", "close", "(Ljava/lang/String;Z)V", "onTick", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onInventoryDataReceiveEvent", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;", "inventory", "done", "(Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;)V", "currentInventory", "Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;", "acceptItems", "Z", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "lateEvent", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "getCurrentInventoryName", "()Ljava/lang/String;", "currentInventoryName", "Inventory", "1.8.9"})
public final class OtherInventoryData {
    @NotNull
    public static final OtherInventoryData INSTANCE = new OtherInventoryData();
    @Nullable
    private static Inventory currentInventory;
    private static boolean acceptItems;
    @Nullable
    private static InventoryUpdatedEvent lateEvent;

    private OtherInventoryData() {
    }

    @NotNull
    public final String getCurrentInventoryName() {
        Inventory inventory = currentInventory;
        String string = inventory != null ? inventory.getTitle() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @HandleEvent
    public final void onCloseWindow(@NotNull GuiContainerEvent.CloseWindowEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        OtherInventoryData.close$default(this, null, false, 3, null);
    }

    public final void close(@NotNull String title, boolean reopenSameName) {
        Intrinsics.checkNotNullParameter(title, "title");
        new InventoryCloseEvent(title, reopenSameName).post();
        currentInventory = null;
    }

    public static /* synthetic */ void close$default(OtherInventoryData otherInventoryData, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = otherInventoryData.getCurrentInventoryName();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        otherInventoryData.close(string, bl);
    }

    @HandleEvent
    public final void onTick() {
        block0: {
            InventoryUpdatedEvent inventoryUpdatedEvent = lateEvent;
            if (inventoryUpdatedEvent == null) break block0;
            InventoryUpdatedEvent it = inventoryUpdatedEvent;
            boolean bl = false;
            it.post();
            lateEvent = null;
        }
    }

    @HandleEvent
    public final void onInventoryDataReceiveEvent(@NotNull PacketReceivedEvent event) {
        block12: {
            Intrinsics.checkNotNullParameter(event, "event");
            Packet<?> packet = event.getPacket();
            if (packet instanceof S2EPacketCloseWindow) {
                OtherInventoryData.close$default(this, null, false, 3, null);
            }
            if (packet instanceof S2DPacketOpenWindow) {
                String title = ((S2DPacketOpenWindow)packet).func_179840_c().func_150260_c();
                int windowId = ((S2DPacketOpenWindow)packet).func_148901_c();
                int slotCount = ((S2DPacketOpenWindow)packet).func_148898_f();
                Inventory inventory = currentInventory;
                OtherInventoryData.close$default(this, null, Intrinsics.areEqual(title, inventory != null ? inventory.getTitle() : null), 1, null);
                Intrinsics.checkNotNull(title);
                currentInventory = new Inventory(windowId, title, slotCount, null, false, 24, null);
                acceptItems = true;
            }
            if (!(packet instanceof S2FPacketSetSlot)) break block12;
            if (!acceptItems) {
                Inventory inventory = currentInventory;
                if (inventory != null) {
                    ItemStack itemStack;
                    Inventory it = inventory;
                    boolean bl = false;
                    if (it.getWindowId() != ((S2FPacketSetSlot)packet).func_149175_c()) {
                        return;
                    }
                    int slot = ((S2FPacketSetSlot)packet).func_149173_d();
                    if (slot < it.getSlotCount() && InventoryCompat.INSTANCE.isNotEmpty(itemStack = ((S2FPacketSetSlot)packet).func_149174_e())) {
                        Integer n = slot;
                        it.getItems().put(n, itemStack);
                        lateEvent = new InventoryUpdatedEvent(it);
                    }
                }
                return;
            }
            Inventory inventory = currentInventory;
            if (inventory != null) {
                Inventory it = inventory;
                boolean bl = false;
                if (it.getWindowId() != ((S2FPacketSetSlot)packet).func_149175_c()) {
                    return;
                }
                int slot = ((S2FPacketSetSlot)packet).func_149173_d();
                if (slot < it.getSlotCount()) {
                    ItemStack itemStack = ((S2FPacketSetSlot)packet).func_149174_e();
                    if (InventoryCompat.INSTANCE.isNotEmpty(itemStack)) {
                        Integer n = slot;
                        it.getItems().put(n, itemStack);
                    }
                } else {
                    INSTANCE.done(it);
                    return;
                }
                if (it.getItems().size() == it.getSlotCount()) {
                    INSTANCE.done(it);
                }
            }
        }
    }

    private final void done(Inventory inventory) {
        new InventoryFullyOpenedEvent(inventory).post();
        inventory.setFullyOpenedOnce(true);
        new InventoryUpdatedEvent(inventory).post();
        acceptItems = false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u0014\u0010\u0010R#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;", "", "", "windowId", "", "title", "slotCount", "", "Lnet/minecraft/item/ItemStack;", "items", "", "fullyOpenedOnce", "<init>", "(ILjava/lang/String;ILjava/util/Map;Z)V", "I", "getWindowId", "()I", "Ljava/lang/String;", "getTitle", "()Ljava/lang/String;", "getSlotCount", "Ljava/util/Map;", "getItems", "()Ljava/util/Map;", "Z", "getFullyOpenedOnce", "()Z", "setFullyOpenedOnce", "(Z)V", "1.8.9"})
    public static final class Inventory {
        private final int windowId;
        @NotNull
        private final String title;
        private final int slotCount;
        @NotNull
        private final Map<Integer, ItemStack> items;
        private boolean fullyOpenedOnce;

        public Inventory(int windowId, @NotNull String title, int slotCount, @NotNull Map<Integer, ItemStack> items, boolean fullyOpenedOnce) {
            Intrinsics.checkNotNullParameter(title, "title");
            Intrinsics.checkNotNullParameter(items, "items");
            this.windowId = windowId;
            this.title = title;
            this.slotCount = slotCount;
            this.items = items;
            this.fullyOpenedOnce = fullyOpenedOnce;
        }

        public /* synthetic */ Inventory(int n, String string, int n2, Map map2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                map2 = new LinkedHashMap();
            }
            if ((n3 & 0x10) != 0) {
                bl = false;
            }
            this(n, string, n2, map2, bl);
        }

        public final int getWindowId() {
            return this.windowId;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        public final int getSlotCount() {
            return this.slotCount;
        }

        @NotNull
        public final Map<Integer, ItemStack> getItems() {
            return this.items;
        }

        public final boolean getFullyOpenedOnce() {
            return this.fullyOpenedOnce;
        }

        public final void setFullyOpenedOnce(boolean bl) {
            this.fullyOpenedOnce = bl;
        }
    }
}

