/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.dungeon.DungeonsRaceGuideConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.DungeonHubRacesJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ParkourJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ParkourShortCut;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ActionBarUpdateEvent;
import at.hannibal2.skyhanni.events.OwnInventoryItemUpdateEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.ParkourHelper;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u000f\u0010\u0013\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0003R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001b\u0010 \u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0018\u0010)\u001a\u0004\u0018\u00010\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonsRaceGuide;", "", "<init>", "()V", "", "onIslandChange", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "onConfigLoad", "onOwnInventoryItemUpdate", "Lat/hannibal2/skyhanni/events/ActionBarUpdateEvent;", "onActionBarUpdate", "(Lat/hannibal2/skyhanni/events/ActionBarUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "updateConfig", "reset", "Lat/hannibal2/skyhanni/config/features/dungeon/DungeonsRaceGuideConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/DungeonsRaceGuideConfig;", "config", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "CANCEL_RACE_ITEM", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "Ljava/util/regex/Pattern;", "raceActivePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getRaceActivePattern", "()Ljava/util/regex/Pattern;", "raceActivePattern", "", "", "Lat/hannibal2/skyhanni/utils/ParkourHelper;", "parkourHelpers", "Ljava/util/Map;", "", "inRace", "Z", "currentRace", "Ljava/lang/String;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDungeonsRaceGuide.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonsRaceGuide.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonsRaceGuide\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 5 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,106:1\n13#2,7:107\n21#2,6:124\n169#3,5:114\n174#3,4:120\n24#4:119\n11#5:130\n1#6:131\n1#6:132\n1863#7,2:133\n216#8,2:135\n*S KotlinDebug\n*F\n+ 1 DungeonsRaceGuide.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonsRaceGuide\n*L\n47#1:107,7\n47#1:124,6\n47#1:114,5\n47#1:120,4\n47#1:119\n81#1:130\n81#1:131\n93#1:133,2\n103#1:135,2\n*E\n"})
public final class DungeonsRaceGuide {
    @NotNull
    public static final DungeonsRaceGuide INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final NeuInternalName CANCEL_RACE_ITEM;
    @NotNull
    private static final RepoPattern raceActivePattern$delegate;
    @NotNull
    private static final Map<String, ParkourHelper> parkourHelpers;
    private static boolean inRace;
    @Nullable
    private static String currentRace;

    private DungeonsRaceGuide() {
    }

    private final DungeonsRaceGuideConfig getConfig() {
        return SkyHanniMod.feature.getDungeon().getDungeonsRaceGuide();
    }

    private final Pattern getRaceActivePattern() {
        return (Pattern)raceActivePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @HandleEvent
    public final void onIslandChange() {
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter(event, "event");
        String constant$iv = "DungeonHubRaces";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(DungeonHubRacesJson.class)));
                Intrinsics.checkNotNullExpressionValue(object4, "fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl(object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl(ResultKt.createFailure(bl));
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + '\'', it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        DungeonHubRacesJson data2 = (DungeonHubRacesJson)object;
        for (Map.Entry<String, Map<String, ParkourJson>> entry : data2.getData().entrySet()) {
            ParkourJson nothingNoReturn;
            String key = entry.getKey();
            Map<String, ParkourJson> map2 = entry.getValue();
            ParkourJson parkourJson = nothingNoReturn = map2.get("nothing:no_return");
            List<LorenzVec> list = parkourJson != null ? parkourJson.getLocations() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            ParkourJson parkourJson2 = nothingNoReturn;
            List<ParkourShortCut> list2 = parkourJson2 != null ? parkourJson2.getShortCuts() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            parkourHelpers.put(key, new ParkourHelper(list, list2, 1.0, 7.0, false, null, false, 96, null));
        }
        this.updateConfig();
    }

    @HandleEvent
    public final void onConfigLoad() {
        Property[] propertyArray = new Property[]{this.getConfig().getRainbowColor(), this.getConfig().getMonochromeColor(), this.getConfig().getLookAhead()};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, DungeonsRaceGuide::onConfigLoad$lambda$0);
    }

    @HandleEvent(eventType=OwnInventoryItemUpdateEvent.class, onlyOnIsland=IslandType.DUNGEON_HUB)
    public final void onOwnInventoryItemUpdate() {
        ItemStack menuStack;
        ItemStack[] itemStackArray = InventoryUtils.INSTANCE.getItemsInOwnInventoryWithNull();
        ItemStack itemStack = menuStack = itemStackArray != null ? itemStackArray[8] : null;
        boolean nowInRace = Intrinsics.areEqual(itemStack != null ? ItemUtils.INSTANCE.getInternalNameOrNull(itemStack) : null, CANCEL_RACE_ITEM);
        if (inRace && !nowInRace) {
            this.reset();
        }
        inRace = nowInRace;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.DUNGEON_HUB)
    public final void onActionBarUpdate(@NotNull ActionBarUpdateEvent event) {
        void $this$findMatcher$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getEnabled()) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getRaceActivePattern();
        String text$iv = event.getActionBar();
        boolean $i$f$findMatcher = false;
        Matcher it$iv = $this$findMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.find()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onActionBarUpdate_u24lambda_u241 = it$iv;
            boolean bl2 = false;
            String string = $this$onActionBarUpdate_u24lambda_u241.group("race");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            String string2 = StringsKt.replace$default(string, " ", "_", false, 4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            currentRace = string2;
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.DUNGEON_HUB)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter(event, "event");
            if (!this.getConfig().getEnabled() || !inRace) {
                return;
            }
            String string = currentRace;
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            ParkourHelper parkourHelper = parkourHelpers.get(it);
            if (parkourHelper != null) {
                parkourHelper.render(event);
            }
        }
    }

    private final void updateConfig() {
        Iterable $this$forEach$iv = parkourHelpers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParkourHelper it = (ParkourHelper)element$iv;
            boolean bl = false;
            it.setRainbowColor((Boolean)INSTANCE.getConfig().getRainbowColor().get());
            it.setMonochromeColor((ChromaColour)INSTANCE.getConfig().getMonochromeColor().get());
            it.setLookAhead(((Number)INSTANCE.getConfig().getLookAhead().get()).intValue() + 1);
        }
    }

    private final void reset() {
        inRace = false;
        currentRace = null;
        Map<String, ParkourHelper> $this$forEach$iv = parkourHelpers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ParkourHelper>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ParkourHelper> element$iv;
            Map.Entry<String, ParkourHelper> it = element$iv = iterator2.next();
            boolean bl = false;
            it.getValue().reset();
        }
    }

    private static final void onConfigLoad$lambda$0() {
        INSTANCE.updateConfig();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(DungeonsRaceGuide.class, "raceActivePattern", "getRaceActivePattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new DungeonsRaceGuide();
        CANCEL_RACE_ITEM = NeuInternalName.Companion.toInternalName("CANCEL_RACE_ITEM");
        raceActivePattern$delegate = RepoPattern.Companion.pattern("dungeon.race.active", "\u00a7.\u00a7.(?<race>[\\w ]+) RACE \u00a7.[\\d:.]+");
        parkourHelpers = new LinkedHashMap();
    }
}

