/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory.stray;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.api.event.SkyHanniEvent;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.CFConfig;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.CFStrayRabbitWarningConfig;
import at.hannibal2.skyhanni.data.jsonobjects.repo.HoppityEggLocationsJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.hoppity.RabbitFoundEvent;
import at.hannibal2.skyhanni.events.inventory.AttemptedInventoryCloseEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityApi;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggType;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityTextureHandler;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.CFApi;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.data.CFDataLoader;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.GuiRenderUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzRarity;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.compat.GuiScreenUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u0004*\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0016J\u0013\u0010\u001c\u001a\u00020\u0004*\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0016J\u0017\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020&H\u0007\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020)H\u0007\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020,H\u0007\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020/H\u0007\u00a2\u0006\u0004\b0\u00101J\u0013\u00103\u001a\u00020\u0004*\u000202H\u0002\u00a2\u0006\u0004\b3\u00104R\u0014\u00108\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010<\u001a\u0002098BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010>\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010?R\u0014\u0010A\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010?R\u0016\u0010B\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u001c\u0010F\u001a\b\u0012\u0004\u0012\u00020E0D8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020E0D8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010G\u00a8\u0006I"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/stray/CFStrayWarning;", "", "<init>", "()V", "", "reset", "Lnet/minecraft/item/ItemStack;", "stack", "Lat/hannibal2/skyhanni/utils/LorenzRarity;", "rarity", "", "isRarityOrHigher", "(Lnet/minecraft/item/ItemStack;Lat/hannibal2/skyhanni/utils/LorenzRarity;)Z", "isSpecial", "(Lnet/minecraft/item/ItemStack;)Z", "item", "shouldWarnAboutStray", "handleRabbitWarnings", "(Lnet/minecraft/item/ItemStack;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "event", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent;", "Lnet/minecraft/inventory/ContainerChest;", "getEventChest", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent;)Lnet/minecraft/inventory/ContainerChest;", "partyModeHighlight", "strayHighlight", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "onInventoryUpdated", "(Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/hoppity/RabbitFoundEvent;", "onRabbitFound", "(Lat/hannibal2/skyhanni/events/hoppity/RabbitFoundEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "Lat/hannibal2/skyhanni/events/inventory/AttemptedInventoryCloseEvent;", "onAttemptedInventoryClose", "(Lat/hannibal2/skyhanni/events/inventory/AttemptedInventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/api/event/SkyHanniEvent$Cancellable;", "sendPreventCloseTitle", "(Lat/hannibal2/skyhanni/api/event/SkyHanniEvent$Cancellable;)V", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFConfig;", "config", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFStrayRabbitWarningConfig;", "getWarningConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFStrayRabbitWarningConfig;", "warningConfig", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "chromaColor", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "chromaColorAlt", "chromaColorAlt2", "flashScreen", "Z", "", "", "activeStraySlots", "Ljava/util/Set;", "destructiveSlots", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCFStrayWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CFStrayWarning.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/stray/CFStrayWarning\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 6 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 7 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,208:1\n1863#2,2:209\n774#2:211\n865#2,2:212\n1863#2,2:214\n774#2:216\n865#2,2:217\n1863#2,2:219\n216#3,2:221\n188#3,3:230\n503#4,7:223\n13#5,7:233\n21#5,6:250\n169#6,5:240\n174#6,4:246\n24#7:245\n*S KotlinDebug\n*F\n+ 1 CFStrayWarning.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/stray/CFStrayWarning\n*L\n109#1:209,2\n110#1:211\n110#1:212,2\n112#1:214,2\n119#1:216\n119#1:217,2\n121#1:219,2\n133#1:221,2\n136#1:230,3\n134#1:223,7\n179#1:233,7\n179#1:250,6\n179#1:240,5\n179#1:246,4\n179#1:245\n*E\n"})
public final class CFStrayWarning {
    @NotNull
    public static final CFStrayWarning INSTANCE = new CFStrayWarning();
    @NotNull
    private static final ChromaColour chromaColor = ChromaColour.Companion.fromRGB(255, 85, 85, 2500, 255);
    @NotNull
    private static final ChromaColour chromaColorAlt = ChromaColour.Companion.fromRGB(255, 85, 85, 2400, 255);
    @NotNull
    private static final ChromaColour chromaColorAlt2 = ChromaColour.Companion.fromRGB(255, 85, 85, 2300, 255);
    private static boolean flashScreen;
    @NotNull
    private static Set<Integer> activeStraySlots;
    @NotNull
    private static Set<Integer> destructiveSlots;

    private CFStrayWarning() {
    }

    private final CFConfig getConfig() {
        return CFApi.INSTANCE.getConfig();
    }

    private final CFStrayRabbitWarningConfig getWarningConfig() {
        return this.getConfig().getRabbitWarning();
    }

    private final void reset() {
        flashScreen = false;
        activeStraySlots = SetsKt.emptySet();
    }

    private final boolean isRarityOrHigher(ItemStack stack, LorenzRarity rarity) {
        boolean bl;
        String string = ItemUtils.INSTANCE.getSkullTexture(stack);
        if (string != null) {
            String skullTexture = string;
            boolean bl2 = false;
            LorenzRarity lorenzRarity = HoppityTextureHandler.INSTANCE.getRarityBySkullId(skullTexture);
            if (lorenzRarity != null) {
                LorenzRarity skullRarity = lorenzRarity;
                boolean bl3 = false;
                bl = skullRarity.ordinal() >= rarity.ordinal();
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isSpecial(ItemStack stack) {
        return RegexUtils.INSTANCE.matches(CFDataLoader.INSTANCE.getClickMeGoldenRabbitPattern(), stack.func_82833_r()) || CollectionsKt.contains((Iterable)CFApi.INSTANCE.getSpecialRabbitTextures(), ItemUtils.INSTANCE.getSkullTexture(stack));
    }

    private final boolean shouldWarnAboutStray(ItemStack item2) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getConfig().getRabbitWarning().getRabbitWarningLevel().ordinal()]) {
            case 1: {
                bl = this.isSpecial(item2);
                break;
            }
            case 2: {
                bl = this.isRarityOrHigher(item2, LorenzRarity.LEGENDARY);
                break;
            }
            case 3: {
                bl = this.isRarityOrHigher(item2, LorenzRarity.EPIC);
                break;
            }
            case 4: {
                bl = this.isRarityOrHigher(item2, LorenzRarity.RARE);
                break;
            }
            case 5: {
                bl = this.isRarityOrHigher(item2, LorenzRarity.UNCOMMON);
                break;
            }
            case 6: {
                if (RegexUtils.INSTANCE.matches(CFDataLoader.INSTANCE.getClickMeRabbitPattern(), item2.func_82833_r()) || this.isSpecial(item2)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 7: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final void handleRabbitWarnings(ItemStack item2) {
        boolean isSpecial;
        if (RegexUtils.INSTANCE.matches(CFApi.INSTANCE.getCaughtRabbitPattern(), ItemUtils.INSTANCE.getSingleLineLore(item2))) {
            return;
        }
        boolean clickMeMatches = RegexUtils.INSTANCE.matches(CFDataLoader.INSTANCE.getClickMeRabbitPattern(), item2.func_82833_r());
        boolean goldenClickMeMatches = RegexUtils.INSTANCE.matches(CFDataLoader.INSTANCE.getClickMeGoldenRabbitPattern(), item2.func_82833_r());
        if (!clickMeMatches && !goldenClickMeMatches || !this.shouldWarnAboutStray(item2)) {
            return;
        }
        boolean bl = isSpecial = goldenClickMeMatches || CollectionsKt.contains((Iterable)CFApi.INSTANCE.getSpecialRabbitTextures(), ItemUtils.INSTANCE.getSkullTexture(item2));
        if (isSpecial) {
            SoundUtils.INSTANCE.repeatSound(100L, this.getWarningConfig().getRepeatSound(), CFApi.INSTANCE.getWarningSound());
        } else {
            SoundUtils.playBeepSound$default(SoundUtils.INSTANCE, 0.0f, 1, null);
        }
    }

    @HandleEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!CFApi.INSTANCE.getInChocolateFactory()) {
            return;
        }
        if (((Boolean)this.getConfig().getPartyMode().get()).booleanValue()) {
            this.partyModeHighlight(event);
        } else {
            this.strayHighlight(event);
        }
    }

    private final ContainerChest getEventChest(GuiContainerEvent $this$getEventChest) {
        Container container = $this$getEventChest.getContainer();
        return container instanceof ContainerChest ? (ContainerChest)container : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void partyModeHighlight(GuiContainerEvent.BackgroundDrawnEvent $this$partyModeHighlight) {
        void $this$filterTo$iv$iv;
        ContainerChest containerChest = this.getEventChest($this$partyModeHighlight);
        if (containerChest == null) {
            return;
        }
        ContainerChest eventChest = containerChest;
        Iterable $this$forEach$iv = InventoryUtils.INSTANCE.getUpperItems(eventChest).keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Slot it = (Slot)element$iv;
            boolean bl = false;
            RenderUtils.INSTANCE.highlight(it, chromaColorAlt);
        }
        List list = eventChest.field_75151_b;
        Intrinsics.checkNotNullExpressionValue(list, "inventorySlots");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Slot it = (Slot)element$iv$iv;
            boolean bl = false;
            if (!(it.field_75222_d != it.getSlotIndex())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Slot it = (Slot)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            RenderUtils.INSTANCE.highlight(it, chromaColorAlt2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void strayHighlight(GuiContainerEvent.BackgroundDrawnEvent $this$strayHighlight) {
        void $this$filterTo$iv$iv;
        ContainerChest containerChest = this.getEventChest($this$strayHighlight);
        if (containerChest == null) {
            return;
        }
        ContainerChest eventChest = containerChest;
        Iterable $this$filter$iv = InventoryUtils.INSTANCE.getUpperItems(eventChest).keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Slot it = (Slot)element$iv$iv;
            boolean bl = false;
            if (!activeStraySlots.contains(it.field_75222_d)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Slot it = (Slot)element$iv;
            boolean bl = false;
            RenderUtils.INSTANCE.highlight(it, INSTANCE.getWarningConfig().getInventoryHighlightColor());
        }
    }

    @HandleEvent
    public final void onInventoryUpdated(@NotNull InventoryUpdatedEvent event) {
        boolean bl;
        block16: {
            Map<Integer, ItemStack> strayStacks;
            Intrinsics.checkNotNullParameter(event, "event");
            if (!CFApi.INSTANCE.getInChocolateFactory()) {
                flashScreen = false;
                return;
            }
            Map<Integer, ItemStack> $this$forEach$iv = strayStacks = HoppityApi.INSTANCE.filterMayBeStray(event.getInventoryItems());
            boolean $i$f$forEach = false;
            for (Map.Entry<Integer, ItemStack> element$iv : $this$forEach$iv.entrySet()) {
                Map.Entry<Integer, ItemStack> it = element$iv;
                boolean bl2 = false;
                INSTANCE.handleRabbitWarnings(it.getValue());
            }
            Map<Integer, ItemStack> $this$filterValues$iv = strayStacks;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
                ItemStack it = (ItemStack)entry.getValue();
                boolean bl3 = false;
                if (!(!RegexUtils.INSTANCE.matches(CFApi.INSTANCE.getCaughtRabbitPattern(), ItemUtils.INSTANCE.getSingleLineLore(it)))) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            Map activeStrays = result$iv;
            activeStraySlots = activeStrays.keySet();
            Map $this$any$iv = activeStrays;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    boolean bl3;
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl5 = false;
                    ItemStack stack = (ItemStack)entry.getValue();
                    switch (WhenMappings.$EnumSwitchMapping$0[INSTANCE.getConfig().getRabbitWarning().getFlashScreenLevel().ordinal()]) {
                        case 1: {
                            bl3 = INSTANCE.isSpecial(stack);
                            break;
                        }
                        case 2: {
                            bl3 = INSTANCE.isRarityOrHigher(stack, LorenzRarity.LEGENDARY);
                            break;
                        }
                        case 3: {
                            bl3 = INSTANCE.isRarityOrHigher(stack, LorenzRarity.EPIC);
                            break;
                        }
                        case 4: {
                            bl3 = INSTANCE.isRarityOrHigher(stack, LorenzRarity.RARE);
                            break;
                        }
                        case 5: {
                            bl3 = INSTANCE.isRarityOrHigher(stack, LorenzRarity.UNCOMMON);
                            break;
                        }
                        case 6: {
                            if (RegexUtils.INSTANCE.matches(CFDataLoader.INSTANCE.getClickMeRabbitPattern(), ((ItemStack)entry.getValue()).func_82833_r()) || INSTANCE.isSpecial(stack)) {
                                bl3 = true;
                                break;
                            }
                            bl3 = false;
                            break;
                        }
                        case 7: {
                            bl3 = false;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
        }
        flashScreen = bl;
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.reset();
    }

    @HandleEvent
    public final void onRabbitFound(@NotNull RabbitFoundEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEggType() != HoppityEggType.STRAY) {
            return;
        }
        flashScreen = false;
    }

    @HandleEvent(priority=-2)
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!CFApi.INSTANCE.getInChocolateFactory()) {
            return;
        }
        if (!flashScreen && !((Boolean)this.getConfig().getPartyMode().get()).booleanValue()) {
            return;
        }
        int alpha = RangesKt.coerceIn((int)(((double)2 + Math.sin((double)SimpleTimeMark.toMillis-impl(SimpleTimeMark.Companion.now-uFjCsEo()) / 1000.0)) * (double)255 / (double)4), new IntRange(0, 255));
        ChromaColour toUse = (Boolean)this.getConfig().getPartyMode().get() != false ? chromaColor : this.getWarningConfig().getFlashColor();
        int color = alpha << 24 | ColorUtils.INSTANCE.toColor(toUse).getRGB() & 0xFFFFFF;
        GuiRenderUtils.INSTANCE.drawRect(0, 0, GuiScreenUtils.INSTANCE.getDisplayWidth(), GuiScreenUtils.INSTANCE.getDisplayHeight(), color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter(event, "event");
        String constant$iv = "HoppityEggLocations";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(HoppityEggLocationsJson.class)));
                Intrinsics.checkNotNullExpressionValue(object4, "fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl(object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl(ResultKt.createFailure(bl));
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + '\'', it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        destructiveSlots = ((HoppityEggLocationsJson)object).getDestructiveSlots();
    }

    @HandleEvent(priority=-2)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!CFApi.INSTANCE.getInChocolateFactory() || !this.getWarningConfig().getBlockClosing()) {
            return;
        }
        if (activeStraySlots.isEmpty() || KeyboardManager.INSTANCE.isShiftKeyDown()) {
            return;
        }
        if (!destructiveSlots.contains(event.getSlotId())) {
            return;
        }
        this.sendPreventCloseTitle(event);
    }

    @HandleEvent
    public final void onAttemptedInventoryClose(@NotNull AttemptedInventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getRabbitWarning().getBlockClosing()) {
            return;
        }
        if (activeStraySlots.isEmpty()) {
            return;
        }
        this.sendPreventCloseTitle(event);
    }

    private final void sendPreventCloseTitle(SkyHanniEvent.Cancellable $this$sendPreventCloseTitle) {
        TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7cStray Rabbit Prevented Close", "\u00a77Hold \u00a7eShift \u00a77to bypass", DurationKt.toDuration(5, DurationUnit.SECONDS), null, TitleManager.TitleLocation.INVENTORY, null, 0.0, false, false, null, 0L, null, null, 0L, 16360, null);
        SoundUtils.INSTANCE.playErrorSound();
        $this$sendPreventCloseTitle.cancel();
    }

    static {
        activeStraySlots = SetsKt.emptySet();
        destructiveSlots = SetsKt.emptySet();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CFStrayRabbitWarningConfig.StrayTypeEntry.values().length];
            try {
                nArray[CFStrayRabbitWarningConfig.StrayTypeEntry.SPECIAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CFStrayRabbitWarningConfig.StrayTypeEntry.LEGENDARY_P.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CFStrayRabbitWarningConfig.StrayTypeEntry.EPIC_P.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CFStrayRabbitWarningConfig.StrayTypeEntry.RARE_P.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CFStrayRabbitWarningConfig.StrayTypeEntry.UNCOMMON_P.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CFStrayRabbitWarningConfig.StrayTypeEntry.ALL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CFStrayRabbitWarningConfig.StrayTypeEntry.NONE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

