/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.rift.everywhere;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.features.rift.RiftApi;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lat/hannibal2/skyhanni/features/rift/everywhere/HighlightRiftGuide;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "", "isEnabled", "()Z", "inInventory", "Z", "", "", "highlightedItems", "Ljava/util/List;", "1.8.9"})
public final class HighlightRiftGuide {
    @NotNull
    public static final HighlightRiftGuide INSTANCE = new HighlightRiftGuide();
    private static boolean inInventory;
    @NotNull
    private static List<Integer> highlightedItems;

    private HighlightRiftGuide() {
    }

    @HandleEvent
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event) {
        boolean inGuide;
        boolean bl;
        Intrinsics.checkNotNullParameter(event, "event");
        inInventory = false;
        if (!this.isEnabled()) {
            return;
        }
        Object object = event.getInventoryItems().get(40);
        if (object != null && (object = ItemUtils.INSTANCE.getLore((ItemStack)object)) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = it.size() == 1 ? StringsKt.startsWith$default((String)it.get(0), "\u00a77To Rift Guide", false, 2, null) : false;
        } else {
            bl = inGuide = false;
        }
        if (!inGuide) {
            return;
        }
        List highlightedItems = new ArrayList();
        for (Map.Entry<Integer, ItemStack> entry : event.getInventoryItems().entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack stack = entry.getValue();
            List<String> lore = ItemUtils.INSTANCE.getLore(stack);
            if (!(!((Collection)lore).isEmpty()) || !Intrinsics.areEqual(CollectionsKt.last(lore), "\u00a78\u2716 Not completed yet!")) continue;
            highlightedItems.add(slot);
        }
        inInventory = true;
        HighlightRiftGuide.highlightedItems = highlightedItems;
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        inInventory = false;
    }

    @HandleEvent(priority=1)
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!inInventory) {
            return;
        }
        for (Slot slot : InventoryUtils.INSTANCE.getItemsInOpenChest()) {
            if (!highlightedItems.contains(slot.getSlotIndex())) continue;
            RenderUtils.INSTANCE.highlight(slot, LorenzColor.YELLOW);
        }
    }

    public final boolean isEnabled() {
        return RiftApi.INSTANCE.inRift() && RiftApi.INSTANCE.getConfig().getHighlightGuide();
    }

    static {
        highlightedItems = CollectionsKt.emptyList();
    }
}

