/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;

class Subroutine {
    LabelNode start;
    boolean[] access;
    List<JumpInsnNode> callers;

    private Subroutine() {
    }

    Subroutine(LabelNode start2, int maxLocals, JumpInsnNode caller2) {
        this.start = start2;
        this.access = new boolean[maxLocals];
        this.callers = new ArrayList<JumpInsnNode>();
        this.callers.add(caller2);
    }

    public Subroutine copy() {
        Subroutine result2 = new Subroutine();
        result2.start = this.start;
        result2.access = new boolean[this.access.length];
        System.arraycopy(this.access, 0, result2.access, 0, this.access.length);
        result2.callers = new ArrayList<JumpInsnNode>(this.callers);
        return result2;
    }

    public boolean merge(Subroutine subroutine) throws AnalyzerException {
        int i2;
        boolean changes = false;
        for (i2 = 0; i2 < this.access.length; ++i2) {
            if (!subroutine.access[i2] || this.access[i2]) continue;
            this.access[i2] = true;
            changes = true;
        }
        if (subroutine.start == this.start) {
            for (i2 = 0; i2 < subroutine.callers.size(); ++i2) {
                JumpInsnNode caller2 = subroutine.callers.get(i2);
                if (this.callers.contains(caller2)) continue;
                this.callers.add(caller2);
                changes = true;
            }
        }
        return changes;
    }
}

