/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test.graph;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.features.dev.GraphConfig;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.model.Graph;
import at.hannibal2.skyhanni.data.model.GraphNode;
import at.hannibal2.skyhanni.data.model.GraphNodeTag;
import at.hannibal2.skyhanni.data.model.TextInput;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.test.graph.EdgeDirection;
import at.hannibal2.skyhanni.test.graph.GraphEditorBugFinder;
import at.hannibal2.skyhanni.test.graph.GraphingEdge;
import at.hannibal2.skyhanni.test.graph.GraphingNode;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.GraphUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.RaycastUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.primitives.StringRenderable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.minecraft.class_304;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0011\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u0017\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u000f\u0010\u001d\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u000f\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b!\u0010\u0003J\u001b\u0010$\u001a\u00020\t*\u00020\u00072\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%J\u001b\u0010'\u001a\u00020\t*\u00020\u00072\u0006\u0010&\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b'\u0010(J#\u0010+\u001a\u00020\t*\u00020\u00072\u0006\u0010&\u001a\u00020\u00112\u0006\u0010*\u001a\u00020)H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0013\u0010-\u001a\u00020)*\u00020\"H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\t2\u0006\u0010\b\u001a\u00020/H\u0007\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b2\u0010\u0003J\u000f\u00103\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b3\u0010\u0003J\u000f\u00104\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b4\u0010\u0003J\u000f\u00105\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b5\u0010\u0003J'\u00109\u001a\u0010\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\u0015\u0018\u0001072\b\u00106\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010;\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b;\u0010\u0003J\u000f\u0010<\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b<\u0010\u0006J\u000f\u0010=\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b=\u0010\u0003J\u001b\u0010@\u001a\u00020\t*\u00020>2\u0006\u0010?\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b@\u0010AJ#\u0010E\u001a\u00020\t2\u0006\u0010B\u001a\u00020>2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00040C\u00a2\u0006\u0004\bE\u0010FJ\u000f\u0010G\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bG\u0010\u0003J%\u0010K\u001a\u0004\u0018\u00010J2\b\u0010H\u001a\u0004\u0018\u00010\"2\b\u0010I\u001a\u0004\u0018\u00010\"H\u0002\u00a2\u0006\u0004\bK\u0010LJ-\u0010O\u001a\u00020\u00042\b\u0010H\u001a\u0004\u0018\u00010\"2\b\u0010I\u001a\u0004\u0018\u00010\"2\b\b\u0002\u0010N\u001a\u00020MH\u0002\u00a2\u0006\u0004\bO\u0010PJ\r\u0010S\u001a\u00020Q\u00a2\u0006\u0004\bR\u0010\u0010J\u0015\u0010W\u001a\u00020\t2\u0006\u0010T\u001a\u00020Q\u00a2\u0006\u0004\bU\u0010VJ\u000f\u0010X\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bX\u0010\u0003J\u000f\u0010Y\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bY\u0010\u0003J\r\u0010Z\u001a\u00020\t\u00a2\u0006\u0004\bZ\u0010\u0003R\u0011\u0010^\u001a\u00020[8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R\u0016\u0010_\u001a\u00020J8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b_\u0010`R\u001d\u0010b\u001a\b\u0012\u0004\u0012\u00020\"0a8\u0006\u00a2\u0006\f\n\u0004\bb\u0010c\u001a\u0004\bd\u0010\u0010R\u001a\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00110a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\be\u0010cR.\u0010g\u001a\u0004\u0018\u00010\"2\b\u0010f\u001a\u0004\u0018\u00010\"8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010h\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR(\u0010m\u001a\u0004\u0018\u00010\"2\b\u0010f\u001a\u0004\u0018\u00010\"8\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\bm\u0010h\"\u0004\bn\u0010lR\u0018\u0010o\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bo\u0010pR\u0016\u0010q\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bq\u0010rR\u0016\u0010s\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bs\u0010rR$\u0010t\u001a\u00020\u00042\u0006\u0010f\u001a\u00020\u00048\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\bt\u0010r\"\u0004\bu\u0010vR\u0016\u0010w\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bw\u0010rR\u0014\u0010y\u001a\u00020x8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\by\u0010zR\u0014\u0010{\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b{\u0010|R\u0014\u0010}\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b}\u0010|R\u0014\u0010~\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b~\u0010|R\u0014\u0010\u007f\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u007f\u0010|R\u0016\u0010\u0080\u0001\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0080\u0001\u0010|R\u0016\u0010\u0081\u0001\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0081\u0001\u0010|R\u0016\u0010\u0082\u0001\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0082\u0001\u0010|R\u001c\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\u001e0a8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0083\u0001\u0010cR\u001c\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020\u001e0\r8BX\u0082\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0084\u0001\u0010\u0010R\u001b\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0086\u0001\u0010\u0087\u0001R\u0018\u0010\u0088\u0001\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0088\u0001\u0010rR\u0018\u0010\u0089\u0001\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0089\u0001\u0010rR\u001a\u0010\u008b\u0001\u001a\u00030\u008a\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u008b\u0001\u0010\u008c\u0001R\u001a\u0010\u008d\u0001\u001a\u00030\u008a\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u008d\u0001\u0010\u008c\u0001R\u001e\u0010\u008f\u0001\u001a\t\u0012\u0004\u0012\u00020\"0\u008e\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008f\u0001\u0010\u0090\u0001R\u001e\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u00020\u00110\u008e\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0091\u0001\u0010\u0090\u0001\u00a8\u0006\u0092\u0001"}, d2={"Lat/hannibal2/skyhanni/test/graph/GraphEditor;", "", "<init>", "()V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "event", "", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "onRenderOverlay", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "buildDisplay", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/test/graph/GraphingEdge;", "findEdgeBetweenActiveAndClosest", "()Lat/hannibal2/skyhanni/test/graph/GraphingEdge;", "checkDissolve", "", "text", "feedBackInTutorial", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;)V", "updateRender", "handleAllNodeFind", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "calculateNewAllNodeFind", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "toggleFindAll", "Lat/hannibal2/skyhanni/test/graph/GraphingNode;", "node", "drawNode", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;Lat/hannibal2/skyhanni/test/graph/GraphingNode;)V", "edge", "drawEdge", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;Lat/hannibal2/skyhanni/test/graph/GraphingEdge;)V", "Ljava/awt/Color;", "color", "drawDirection", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;Lat/hannibal2/skyhanni/test/graph/GraphingEdge;Ljava/awt/Color;)V", "getNodeColor", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Ljava/awt/Color;", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "loadThisIsland", "toggleFeature", "chatAtDisable", "input", "name", "Lkotlin/Pair;", "Lat/hannibal2/skyhanni/data/model/GraphNodeTag;", "handleNameShortcut", "(Ljava/lang/String;)Lkotlin/Pair;", "save", "isAnyGuiActive", "editModeClicks", "Lnet/minecraft/class_304;", "vector", "handleEditClicks", "(Lnet/minecraft/class_304;Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "keyBinding", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;", "cir", "onMinecraftInput", "(Lnet/minecraft/class_304;Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;)V", "addNode", "node1", "node2", "", "getEdgeIndex", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Ljava/lang/Integer;", "Lat/hannibal2/skyhanni/test/graph/EdgeDirection;", "direction", "addEdge", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;Lat/hannibal2/skyhanni/test/graph/GraphingNode;Lat/hannibal2/skyhanni/test/graph/EdgeDirection;)Z", "Lat/hannibal2/skyhanni/data/model/Graph;", "compileGraph-rIAQGNA", "compileGraph", "graph", "import-0y7Y464", "(Ljava/util/List;)V", "import", "testDijkstra", "clear", "enable", "Lat/hannibal2/skyhanni/config/features/dev/GraphConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dev/GraphConfig;", "config", "id", "I", "", "nodes", "Ljava/util/List;", "getNodes", "edges", "value", "activeNode", "Lat/hannibal2/skyhanni/test/graph/GraphingNode;", "getActiveNode", "()Lat/hannibal2/skyhanni/test/graph/GraphingNode;", "setActiveNode", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;)V", "closestNode", "setClosestNode", "selectedEdge", "Lat/hannibal2/skyhanni/test/graph/GraphingEdge;", "seeThroughBlocks", "Z", "inEditMode", "inTextMode", "setInTextMode", "(Z)V", "inTutorialMode", "Lat/hannibal2/skyhanni/data/model/TextInput;", "textBox", "Lat/hannibal2/skyhanni/data/model/TextInput;", "nodeColor", "Ljava/awt/Color;", "activeColor", "closestColor", "dijkstraColor", "edgeColor", "edgeDijkstraColor", "edgeSelectedColor", "nodesAlreadyFound", "getNodesToFind", "nodesToFind", "currentNodeToFind", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "active", "dissolvePossible", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "bypassTempRemoveTimer", "J", "lastGuiTime", "", "highlightedNodes", "Ljava/util/Set;", "highlightedEdges", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nGraphEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphEditor.kt\nat/hannibal2/skyhanni/test/graph/GraphEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n*L\n1#1,907:1\n1563#2:908\n1634#2,3:909\n774#2:912\n865#2,2:913\n1869#2,2:915\n1869#2,2:917\n1563#2:919\n1634#2,3:920\n1788#2,4:924\n774#2:928\n865#2,2:929\n1788#2,4:931\n1761#2,3:935\n360#2,7:938\n1573#2:945\n1604#2,4:946\n1573#2:950\n1604#2,3:951\n1563#2:954\n1634#2,3:955\n1607#2:958\n1563#2:959\n1634#2,2:960\n774#2:962\n865#2,2:963\n1563#2:965\n1634#2,3:966\n1056#2:969\n1636#2:970\n1878#2,3:971\n1563#2:974\n1634#2,2:975\n1617#2,9:977\n1869#2:986\n1870#2:988\n1626#2:989\n1636#2:990\n1573#2:991\n1604#2,4:992\n1563#2:996\n1634#2,2:997\n1636#2:1003\n1550#2:1004\n295#2,2:1014\n295#2,2:1016\n1563#2:1018\n1634#2,3:1019\n3581#2,7:1022\n295#2,2:1029\n3588#2,3:1031\n1#3:923\n1#3:987\n126#4:999\n153#4,3:1000\n211#5:1005\n53#5:1006\n80#5,4:1007\n213#5:1011\n85#5:1012\n214#5:1013\n*S KotlinDebug\n*F\n+ 1 GraphEditor.kt\nat/hannibal2/skyhanni/test/graph/GraphEditor\n*L\n115#1:908\n115#1:909,3\n115#1:912\n115#1:913,2\n122#1:915,2\n123#1:917,2\n174#1:919\n174#1:920,3\n185#1:924,4\n560#1:928\n560#1:929,2\n612#1:931,4\n667#1:935,3\n682#1:938,7\n696#1:945\n696#1:946,4\n697#1:950\n697#1:951,3\n702#1:954\n702#1:955,3\n697#1:958\n707#1:959\n707#1:960,2\n708#1:962\n708#1:963,2\n708#1:965\n708#1:966,3\n714#1:969\n707#1:970\n716#1:971,3\n723#1:974\n723#1:975,2\n728#1:977,9\n728#1:986\n728#1:988\n728#1:989\n723#1:990\n732#1:991\n732#1:992,4\n734#1:996\n734#1:997,2\n734#1:1003\n746#1:1004\n775#1:1014,2\n776#1:1016,2\n784#1:1018\n784#1:1019,3\n788#1:1022,7\n788#1:1029,2\n788#1:1031,3\n728#1:987\n737#1:999\n737#1:1000,3\n746#1:1005\n746#1:1006\n746#1:1007,4\n746#1:1011\n746#1:1012\n746#1:1013\n*E\n"})
public final class GraphEditor {
    @NotNull
    public static final GraphEditor INSTANCE = new GraphEditor();
    private static int id;
    @NotNull
    private static final List<GraphingNode> nodes;
    @NotNull
    private static final List<GraphingEdge> edges;
    @Nullable
    private static GraphingNode activeNode;
    @Nullable
    private static GraphingNode closestNode;
    @Nullable
    private static GraphingEdge selectedEdge;
    private static boolean seeThroughBlocks;
    private static boolean inEditMode;
    private static boolean inTextMode;
    private static boolean inTutorialMode;
    @NotNull
    private static final TextInput textBox;
    @NotNull
    private static final Color nodeColor;
    @NotNull
    private static final Color activeColor;
    @NotNull
    private static final Color closestColor;
    @NotNull
    private static final Color dijkstraColor;
    @NotNull
    private static final Color edgeColor;
    @NotNull
    private static final Color edgeDijkstraColor;
    @NotNull
    private static final Color edgeSelectedColor;
    @NotNull
    private static final List<LorenzVec> nodesAlreadyFound;
    @Nullable
    private static LorenzVec currentNodeToFind;
    private static boolean active;
    private static boolean dissolvePossible;
    private static long bypassTempRemoveTimer;
    private static long lastGuiTime;
    @NotNull
    private static final Set<GraphingNode> highlightedNodes;
    @NotNull
    private static final Set<GraphingEdge> highlightedEdges;

    private GraphEditor() {
    }

    @NotNull
    public final GraphConfig getConfig() {
        return SkyHanniMod.feature.getDev().getDevTool().getGraph();
    }

    public final boolean isEnabled() {
        return this.getConfig().getEnabled();
    }

    @NotNull
    public final List<GraphingNode> getNodes() {
        return nodes;
    }

    @Nullable
    public final GraphingNode getActiveNode() {
        return activeNode;
    }

    public final void setActiveNode(@Nullable GraphingNode value) {
        activeNode = value;
        selectedEdge = this.findEdgeBetweenActiveAndClosest();
        this.checkDissolve();
    }

    private final void setClosestNode(GraphingNode value) {
        closestNode = value;
        selectedEdge = this.findEdgeBetweenActiveAndClosest();
    }

    private final void setInTextMode(boolean value) {
        inTextMode = value;
        if (value) {
            Object object = activeNode;
            if (object != null && (object = ((GraphingNode)object).getName()) != null) {
                Object it = object;
                boolean bl = false;
                textBox.setTextBox((String)it);
            }
            textBox.makeActive();
        } else {
            textBox.clear();
            textBox.disable();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<LorenzVec> getNodesToFind() {
        List list;
        List list2;
        List<? extends GraphNode> list3 = IslandGraphs.INSTANCE.getCurrentIslandGraph-ZhRhRFc();
        if (list3 != null) {
            void $this$filterTo$iv$iv;
            LorenzVec it;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = Graph.box-impl(list3);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GraphNode graphNode = (GraphNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((GraphNode)((Object)it)).getPosition());
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LorenzVec)element$iv$iv;
                boolean bl = false;
                if (!(!nodesAlreadyFound.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @HandleEvent(priority=-2)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GraphingNode)element$iv;
            boolean bl = false;
            INSTANCE.drawNode(event, (GraphingNode)it);
        }
        $this$forEach$iv = edges;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GraphingEdge)element$iv;
            boolean bl = false;
            INSTANCE.drawEdge(event, (GraphingEdge)it);
        }
    }

    @HandleEvent(eventType=GuiRenderEvent.GuiOverlayRenderEvent.class)
    public final void onRenderOverlay() {
        if (!this.isEnabled()) {
            return;
        }
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, this.getConfig().getInfoDisplay(), this.buildDisplay(), 0, "Graph Info", false, 10, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Renderable> buildDisplay() {
        void $this$mapTo$iv$iv;
        List list;
        List $this$buildDisplay_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-GraphEditor$buildDisplay$22 = false;
        $this$buildDisplay_u24lambda_u245.add("\u00a7eExit: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getExitKey()));
        if (!inEditMode && !inTextMode) {
            $this$buildDisplay_u24lambda_u245.add("\u00a7ePlace: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getPlaceKey()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7eSelect: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getSelectKey()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7eSelect (Look): \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getSelectRaycastKey()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7eConnect: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getConnectKey()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7eTest: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getDijkstraKey()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7eVision: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getThroughBlocksKey()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7eSave: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getSaveKey()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7eLoad: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getLoadKey()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7eClear: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getClearKey()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7eTutorial: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getTutorialKey()));
            $this$buildDisplay_u24lambda_u245.add(" ");
            if (activeNode != null) {
                $this$buildDisplay_u24lambda_u245.add("\u00a7eText: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getTextKey()));
                if (dissolvePossible) {
                    $this$buildDisplay_u24lambda_u245.add("\u00a7eDissolve: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getDissolveKey()));
                }
                if (selectedEdge != null) {
                    $this$buildDisplay_u24lambda_u245.add("\u00a7eSplit: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getSplitKey()));
                    $this$buildDisplay_u24lambda_u245.add("\u00a7eCycle Direction: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getEdgeCycle()));
                }
            }
        }
        if (!inTextMode) {
            if (activeNode != null) {
                $this$buildDisplay_u24lambda_u245.add("\u00a7eEdit active node: \u00a76" + KeyboardManager.INSTANCE.getKeyName(INSTANCE.getConfig().getEditKey()));
            }
        }
        if (inEditMode) {
            $this$buildDisplay_u24lambda_u245.add("\u00a7ex+ \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getW().field_1655.method_1444()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7ex- \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getS().field_1655.method_1444()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7ez+ \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getA().field_1655.method_1444()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7ez- \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getD().field_1655.method_1444()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7ey+ \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getUp().field_1655.method_1444()));
            $this$buildDisplay_u24lambda_u245.add("\u00a7ey- \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getDown().field_1655.method_1444()));
        }
        if (inTextMode) {
            $this$buildDisplay_u24lambda_u245.add("\u00a7eFormat: " + textBox.finalText());
            $this$buildDisplay_u24lambda_u245.add("\u00a7eRaw:     " + TextInput.editText$default(textBox, LorenzColor.YELLOW, null, 2, null));
        }
        Iterable $this$map$iv = CollectionsKt.build((List)list);
        boolean $i$f$map = false;
        Iterable $i$a$-buildList-GraphEditor$buildDisplay$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringRenderable.Companion.from((String)it));
        }
        return (List)destination$iv$iv;
    }

    private final GraphingEdge findEdgeBetweenActiveAndClosest() {
        GraphingEdge graphingEdge;
        Integer n = this.getEdgeIndex(activeNode, closestNode);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            graphingEdge = edges.get(it);
        } else {
            graphingEdge = null;
        }
        return graphingEdge;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDissolve() {
        int n;
        if (activeNode == null) {
            dissolvePossible = false;
            return;
        }
        Iterable $this$count$iv = edges;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                GraphingEdge it = (GraphingEdge)element$iv;
                boolean bl = false;
                if (!it.isInEdge(activeNode) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        dissolvePossible = n == 2;
    }

    private final void feedBackInTutorial(String text) {
        if (inTutorialMode) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, text, false, null, false, false, null, 62, null);
        }
    }

    @HandleEvent
    public final void onTick(@NotNull SkyHanniTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        this.input();
        if (SkyHanniTickEvent.isMod$default(event, 5, 0, 2, null)) {
            this.updateRender();
        }
        if (nodes.isEmpty()) {
            return;
        }
        this.setClosestNode((GraphingNode)GraphUtils.getNearestNode$default(GraphUtils.INSTANCE, nodes, null, null, 3, null));
        this.handleAllNodeFind();
    }

    private final void updateRender() {
        int maxNodeDistance = this.getConfig().getMaxNodeDistance() * this.getConfig().getMaxNodeDistance();
        for (GraphingNode node : nodes) {
            node.setRendering(GraphUtils.INSTANCE.distanceSqToPlayer(node) < (double)maxNodeDistance);
        }
    }

    private final void handleAllNodeFind() {
        if (!active) {
            return;
        }
        if (this.getNodesToFind().isEmpty()) {
            return;
        }
        LorenzVec closest = GraphUtils.getNearestToPlayer$default(GraphUtils.INSTANCE, this.getNodesToFind(), null, null, 3, null);
        if (GraphUtils.INSTANCE.distanceSqToPlayer(closest) >= 9.0) {
            return;
        }
        nodesAlreadyFound.add(closest);
        if (this.getNodesToFind().isEmpty()) {
            currentNodeToFind = null;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Found all nodes on this island", false, null, false, false, null, 62, null);
            TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7eAll Found!", null, 0L, null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16382, null);
            active = false;
            return;
        }
        this.calculateNewAllNodeFind();
    }

    private final LorenzVec calculateNewAllNodeFind() {
        LorenzVec next = GraphUtils.INSTANCE.findShortestDistancesOnCurrentIsland((Collection<LorenzVec>)this.getNodesToFind()).getLastVisitedNode().getPosition();
        List<? extends GraphNode> list = IslandGraphs.INSTANCE.getCurrentIslandGraph-ZhRhRFc();
        int max = list != null ? Graph.getSize-impl(list) : -1;
        int todo = this.getNodesToFind().size();
        int done = max - todo;
        double percentage = (double)done / (double)max * (double)100;
        GraphNode node = GraphUtils.INSTANCE.nearestNodeOnCurrentIsland(next);
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, node, "Progress: " + NumberUtil.INSTANCE.addSeparators(done) + "/" + NumberUtil.INSTANCE.addSeparators(max) + " (" + NumberUtil.INSTANCE.roundTo(percentage, 2) + "%)", null, null, false, null, GraphEditor::calculateNewAllNodeFind$lambda$9, 30, null);
        currentNodeToFind = next;
        return next;
    }

    private final void toggleFindAll() {
        boolean bl = active = !active;
        if (active) {
            nodesAlreadyFound.clear();
            this.calculateNewAllNodeFind();
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Graph navigation over all nodes started.", false, null, false, false, null, 62, null);
        } else {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Graph navigation over all nodes stopped.", false, null, false, false, null, 62, null);
        }
    }

    private final void drawNode(SkyHanniRenderWorldEvent $this$drawNode, GraphingNode node) {
        if (!node.getRendering()) {
            return;
        }
        WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, $this$drawNode, node.getPosition(), this.getNodeColor(node), seeThroughBlocks, false, 0.0, 0.0, 0.0, 0.2f, true, 120, null);
        String string = node.getName();
        if (string == null) {
            return;
        }
        String nodeName = string;
        boolean showTextAlways = seeThroughBlocks || GraphUtils.INSTANCE.distanceSqToPlayer(node) < 100.0;
        WorldRenderUtils worldRenderUtils = WorldRenderUtils.INSTANCE;
        LorenzVec lorenzVec = node.getPosition();
        WorldRenderUtils.drawDynamicText$default(worldRenderUtils, $this$drawNode, lorenzVec, nodeName, 0.8, -15.0f, 0.0, 12.0, showTextAlways, true, 80, 16, null);
        List<GraphNodeTag> tags = node.getTags();
        if (tags.isEmpty()) {
            return;
        }
        String tagText = CollectionsKt.joinToString$default((Iterable)tags, (CharSequence)" \u00a7f+ ", null, null, (int)0, null, GraphEditor::drawNode$lambda$10, (int)30, null);
        WorldRenderUtils worldRenderUtils2 = WorldRenderUtils.INSTANCE;
        LorenzVec lorenzVec2 = node.getPosition();
        WorldRenderUtils.drawDynamicText$default(worldRenderUtils2, $this$drawNode, lorenzVec2, tagText, 0.8, 0.0f, 0.0, 12.0, showTextAlways, true, 80, 16, null);
    }

    private final void drawEdge(SkyHanniRenderWorldEvent $this$drawEdge, GraphingEdge edge) {
        if (!edge.getNode1().getRendering() && !edge.getNode2().getRendering()) {
            return;
        }
        Color color = Intrinsics.areEqual((Object)selectedEdge, (Object)edge) ? edgeSelectedColor : (highlightedEdges.contains(edge) ? edgeDijkstraColor : edgeColor);
        WorldRenderUtils.INSTANCE.draw3DLine($this$drawEdge, edge.getNode1().getPosition().add(0.5, 0.5, 0.5), edge.getNode2().getPosition().add(0.5, 0.5, 0.5), color, 7, !seeThroughBlocks);
        if (edge.getDirection() != EdgeDirection.BOTH) {
            this.drawDirection($this$drawEdge, edge, color);
        }
    }

    private final void drawDirection(SkyHanniRenderWorldEvent $this$drawDirection, GraphingEdge edge, Color color) {
        LorenzVec lineVec = edge.getNode2().getPosition().minus(edge.getNode1().getPosition());
        LorenzVec center = edge.getNode1().getPosition().plus(lineVec.div(2.0));
        LorenzVec quad1 = edge.getNode1().getPosition().plus(lineVec.div(4.0));
        LorenzVec quad2 = edge.getNode1().getPosition().plus(lineVec.times(0.75));
        LorenzVec pyramidSize = lineVec.normalize().times(Math.min(lineVec.length() / 10.0, 1.0)).times(edge.getDirection() == EdgeDirection.ONE_TO_TWO ? 1.0 : -1.0);
        LorenzVec lineOffsetVec = new LorenzVec(0.5, 0.5, 0.5);
        GraphEditor.drawDirection$pyramidDraw($this$drawDirection, lineOffsetVec, pyramidSize, lineVec, color, center);
        GraphEditor.drawDirection$pyramidDraw($this$drawDirection, lineOffsetVec, pyramidSize, lineVec, color, quad1);
        GraphEditor.drawDirection$pyramidDraw($this$drawDirection, lineOffsetVec, pyramidSize, lineVec, color, quad2);
    }

    private final Color getNodeColor(GraphingNode $this$getNodeColor) {
        GraphingNode graphingNode = $this$getNodeColor;
        return Intrinsics.areEqual((Object)graphingNode, (Object)activeNode) ? (Intrinsics.areEqual((Object)$this$getNodeColor, (Object)closestNode) ? ColorUtils.INSTANCE.blendRGB(activeColor, closestColor, 0.5) : activeColor) : (Intrinsics.areEqual((Object)graphingNode, (Object)closestNode) ? closestColor : (highlightedNodes.contains(graphingNode) ? dijkstraColor : nodeColor));
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register("shgraph", (Function1<? super CommandBuilder, Unit>)((Function1)GraphEditor::onCommandRegistration$lambda$12));
        event.register("shgraphfindall", (Function1<? super CommandBuilder, Unit>)((Function1)GraphEditor::onCommandRegistration$lambda$14));
        event.register("shgraphloadthisisland", (Function1<? super CommandBuilder, Unit>)((Function1)GraphEditor::onCommandRegistration$lambda$16));
    }

    private final void loadThisIsland() {
        List<? extends GraphNode> graph = IslandGraphs.INSTANCE.getCurrentIslandGraph-ZhRhRFc();
        if (graph == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "This island does not have graph data!", false, 2, null);
            return;
        }
        String string = IslandGraphs.INSTANCE.getDisabledNodesReason();
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (SimpleTimeMark.isInPast-impl(bypassTempRemoveTimer)) {
                IslandGraphs.INSTANCE.enableAllNodes();
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Reset temp remove!", false, null, false, false, null, 62, null);
            } else {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7cParts of the island graph are currently temp removed: " + it, false, null, false, false, null, 62, null);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Run this command again in the next 5 seconds to remove the temp remove logic and copy the current island!", false, null, false, false, null, 62, null);
                bypassTempRemoveTimer = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS));
                return;
            }
        }
        this.enable();
        this.import-0y7Y464(graph);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Graph Editor loaded this island!", false, null, false, false, null, 62, null);
    }

    private final void toggleFeature() {
        this.getConfig().setEnabled(!this.getConfig().getEnabled());
        if (this.getConfig().getEnabled()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Graph Editor is now active.", false, null, false, false, null, 62, null);
        } else {
            this.chatAtDisable();
        }
    }

    private final void chatAtDisable() {
        ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "Graph Editor is now inactive. \u00a7lClick to activate.", (Function0)new Function0<Unit>((Object)INSTANCE){

            public final void invoke() {
                GraphEditor.access$toggleFeature((GraphEditor)this.receiver);
            }
        }, null, 0L, false, null, false, false, 252, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void input() {
        GraphingEdge selectedEdge;
        if (this.isAnyGuiActive()) {
            return;
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getExitKey())) {
            if (inTextMode) {
                this.setInTextMode(false);
                this.feedBackInTutorial("Exited Text Mode.");
                GraphingNode graphingNode = activeNode;
                if (graphingNode != null) {
                    GraphingNode it = graphingNode;
                    boolean bl = false;
                    Pair<GraphNodeTag, String> pair = INSTANCE.handleNameShortcut(it.getName());
                    if (pair != null) {
                        Pair<GraphNodeTag, String> pair2 = pair;
                        boolean bl2 = false;
                        GraphNodeTag tag = (GraphNodeTag)((Object)pair2.component1());
                        String name2 = (String)pair2.component2();
                        it.getTags().add(tag);
                        it.setName(name2);
                    }
                }
                return;
            }
            if (inEditMode) {
                inEditMode = false;
                this.feedBackInTutorial("Exited Edit Mode.");
                return;
            }
            this.getConfig().setEnabled(false);
            this.chatAtDisable();
        }
        if (inTextMode) {
            textBox.handle();
            String text = textBox.finalText();
            GraphingNode graphingNode = activeNode;
            if (graphingNode != null) {
                CharSequence charSequence;
                CharSequence it = text;
                if (it.length() == 0) {
                    GraphingNode graphingNode2 = graphingNode;
                    boolean bl = false;
                    charSequence = null;
                    graphingNode = graphingNode2;
                } else {
                    charSequence = it;
                }
                graphingNode.setName((String)charSequence);
            }
            return;
        }
        if (activeNode != null && KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getTextKey())) {
            this.setInTextMode(true);
            this.feedBackInTutorial("Entered Text Mode.");
            return;
        }
        if (inEditMode) {
            this.editModeClicks();
            inEditMode = false;
        }
        if (activeNode != null && KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().getEditKey())) {
            inEditMode = true;
            return;
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getSaveKey())) {
            this.save();
            return;
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getLoadKey())) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = OSUtils.INSTANCE.readFromClipboard((Continuation<? super String>)((Continuation)this));
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((var2_3 = (String)v0) == null) ** GOTO lbl-1000
                            it = var2_3;
                            $i$a$-let-GraphEditor$input$3$1 = false;
                            try {
                                var6_6 = Graph.Companion.fromJson-d5YCfOw((String)it);
                            }
                            catch (Exception e) {
                                var8_8 = new Pair[]{TuplesKt.to((Object)"json", (Object)it)};
                                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Import of graph failed.", var8_8, true, false, false, 48, null);
                                var6_6 = null;
                            }
                            v1 = var6_6;
                            v2 = v1 != null ? Graph.box-impl(v1) : null;
                            v3 = var3_9 = v2 != null ? v2.unbox-impl() : null;
                            if (var3_9 != null) {
                                it = var3_9;
                                $i$a$-let-GraphEditor$input$3$2 = false;
                                GraphEditor.INSTANCE.import-0y7Y464((List<? extends GraphNode>)it);
                                ChatUtils.chat$default(ChatUtils.INSTANCE, "Loaded Graph from clip board.", false, null, false, false, null, 62, null);
                                v4 = Unit.INSTANCE;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 = null;
                            }
                            return v4;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            return;
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getClearKey())) {
            String json2 = Graph.toJson-impl(this.compileGraph-rIAQGNA());
            OSUtils.INSTANCE.copyToClipboard(json2);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied Graph to Clipboard and cleared the graph.", false, null, false, false, null, 62, null);
            this.clear();
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getPlaceKey())) {
            this.addNode();
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getSelectKey())) {
            GraphingNode graphingNode;
            if (Intrinsics.areEqual((Object)activeNode, (Object)closestNode)) {
                this.feedBackInTutorial("De-selected active node.");
                graphingNode = null;
            } else {
                this.feedBackInTutorial("Selected new active node.");
                graphingNode = closestNode;
            }
            this.setActiveNode(graphingNode);
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getSelectRaycastKey())) {
            RaycastUtils.Ray playerRay = RaycastUtils.INSTANCE.createPlayerLookDirectionRay();
            double minimumDistance = Double.MAX_VALUE;
            GraphingNode minimumNode = null;
            for (GraphingNode node : nodes) {
                LorenzVec nodeCenterPosition = node.getPosition().add(0.5, 0.5, 0.5);
                double distance = RaycastUtils.INSTANCE.findDistanceToRay(playerRay, nodeCenterPosition);
                if (distance > minimumDistance) continue;
                if (minimumDistance > 1.0) {
                    minimumNode = node;
                    minimumDistance = distance;
                    continue;
                }
                if (minimumNode != null && !(GraphUtils.INSTANCE.distanceSqToPlayer(minimumNode) > GraphUtils.INSTANCE.distanceSqToPlayer(node))) continue;
                minimumNode = node;
                minimumDistance = distance;
            }
            this.setActiveNode(minimumNode);
        }
        if (!Intrinsics.areEqual((Object)activeNode, (Object)closestNode) && KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getConnectKey())) {
            Integer edge = this.getEdgeIndex(activeNode, closestNode);
            if (edge == null) {
                GraphEditor.addEdge$default(this, activeNode, closestNode, null, 4, null);
                this.feedBackInTutorial("Added new edge.");
            } else {
                edges.remove(edge);
                this.checkDissolve();
                GraphEditor.selectedEdge = this.findEdgeBetweenActiveAndClosest();
                this.feedBackInTutorial("Removed edge.");
            }
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getThroughBlocksKey())) {
            seeThroughBlocks = !seeThroughBlocks;
            this.feedBackInTutorial(seeThroughBlocks ? "Graph is visible though walls." : "Graph is invisible behind walls.");
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getDijkstraKey())) {
            this.feedBackInTutorial("Calculated shortest route and cleared active node.");
            this.testDijkstra();
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getTutorialKey())) {
            inTutorialMode = !inTutorialMode;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Tutorial mode is now " + (inTutorialMode ? "active" : "inactive") + ".", false, null, false, false, null, 62, null);
        }
        if ((selectedEdge = GraphEditor.selectedEdge) != null) {
            if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getSplitKey())) {
                this.feedBackInTutorial("Split Edge into a Node and two edges.");
                LorenzVec middle = selectedEdge.getNode1().getPosition().middle(selectedEdge.getNode2().getPosition()).roundToBlock();
                int minimumNode = id;
                id = minimumNode + 1;
                GraphingNode node = new GraphingNode(minimumNode, middle, null, null, 12, null);
                nodes.add(node);
                edges.remove(selectedEdge);
                this.addEdge(selectedEdge.getNode1(), node, selectedEdge.getDirection());
                this.addEdge(node, selectedEdge.getNode2(), selectedEdge.getDirection());
                this.setActiveNode(node);
            }
            if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getEdgeCycle())) {
                selectedEdge.cycleDirection(activeNode);
                this.feedBackInTutorial("Cycled Direction to: " + selectedEdge.cycleText(activeNode));
            }
        }
        if (dissolvePossible && KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().getDissolveKey())) {
            GraphingNode neighbors2;
            void $this$filterTo$iv$iv;
            this.feedBackInTutorial("Dissolved the node, now it is gone.");
            Iterable $this$filter$iv = edges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GraphingEdge it = (GraphingEdge)element$iv$iv;
                boolean bl = false;
                if (!it.isInEdge(activeNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List edgePair = (List)destination$iv$iv;
            GraphingEdge edge1 = (GraphingEdge)edgePair.get(0);
            GraphingEdge edge2 = (GraphingEdge)edgePair.get(1);
            GraphingNode neighbors1 = Intrinsics.areEqual((Object)edge1.getNode1(), (Object)activeNode) ? edge1.getNode2() : edge1.getNode1();
            GraphingNode graphingNode = neighbors2 = Intrinsics.areEqual((Object)edge2.getNode1(), (Object)activeNode) ? edge2.getNode2() : edge2.getNode1();
            EdgeDirection direction = edge1.getDirection() == EdgeDirection.BOTH || edge2.getDirection() == EdgeDirection.BOTH ? EdgeDirection.BOTH : (edge1.isValidConnectionFromTo(neighbors1, activeNode) && edge2.isValidConnectionFromTo(activeNode, neighbors2) ? EdgeDirection.ONE_TO_TWO : (edge1.isValidConnectionFromTo(activeNode, neighbors1) && edge2.isValidConnectionFromTo(neighbors2, activeNode) ? EdgeDirection.TOW_TO_ONE : EdgeDirection.BOTH));
            edges.removeAll(edgePair);
            Collection collection = nodes;
            GraphingNode graphingNode3 = activeNode;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(graphingNode3);
            this.setActiveNode(null);
            this.addEdge(neighbors1, neighbors2, direction);
        }
    }

    private final Pair<GraphNodeTag, String> handleNameShortcut(String name2) {
        String string = name2;
        return Intrinsics.areEqual((Object)string, (Object)"fsoul") ? TuplesKt.to((Object)((Object)GraphNodeTag.FAIRY_SOUL), (Object)"Fairy Soul") : (Intrinsics.areEqual((Object)string, (Object)"na") ? TuplesKt.to((Object)((Object)GraphNodeTag.AREA), (Object)"no_area") : null);
    }

    /*
     * WARNING - void declaration
     */
    private final void save() {
        if (nodes.isEmpty()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied nothing since the graph is empty.", false, null, false, false, null, 62, null);
            return;
        }
        List<? extends GraphNode> compileGraph = this.compileGraph-rIAQGNA();
        if (this.getConfig().getUseAsIslandArea()) {
            IslandGraphs.INSTANCE.setNewGraph-0y7Y464(compileGraph);
            GraphEditorBugFinder.INSTANCE.runTests();
            if (active) {
                this.calculateNewAllNodeFind();
            }
        }
        String json2 = Graph.toJson-impl(compileGraph);
        OSUtils.INSTANCE.copyToClipboard(json2);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied Graph to Clipboard.", false, null, false, false, null, 62, null);
        if (this.getConfig().getShowsStats()) {
            int n;
            void $this$count$iv;
            GraphingNode it;
            double d;
            Iterable iterable = edges;
            Object object = NumberUtil.INSTANCE;
            double d2 = 0.0;
            for (Object t : iterable) {
                GraphingEdge graphingEdge = (GraphingEdge)t;
                d = d2;
                boolean bl = false;
                double d3 = ((GraphingEdge)((Object)it)).getNode1().getPosition().distance(((GraphingEdge)((Object)it)).getNode2().getPosition());
                d2 = d + d3;
            }
            d = d2;
            String length = ((NumberUtil)object).addSeparators((int)d);
            iterable = nodes;
            NumberUtil numberUtil = NumberUtil.INSTANCE;
            object = ChatUtils.INSTANCE;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (GraphingNode)element$iv;
                    boolean bl = false;
                    if (!(it.getName() != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n2 = n;
            ChatUtils.chat$default((ChatUtils)object, "\u00a7lStats\n\u00a7eNamed Nodes: " + numberUtil.addSeparators(n2) + "\n\u00a7eNodes: " + NumberUtil.INSTANCE.addSeparators(nodes.size()) + "\n\u00a7eEdges: " + NumberUtil.INSTANCE.addSeparators(edges.size()) + "\n\u00a7eLength: " + length, false, null, false, false, null, 62, null);
        }
    }

    private final boolean isAnyGuiActive() {
        boolean gui;
        boolean bl = gui = class_310.method_1551().field_1755 != null;
        if (gui) {
            lastGuiTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(TimeUtils.INSTANCE.getTicks-5sfh64U(3));
        }
        return !SimpleTimeMark.isInPast-impl(lastGuiTime);
    }

    private final void editModeClicks() {
        LorenzVec vector = LocationUtils.INSTANCE.calculatePlayerFacingDirection();
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getW(), vector);
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getA(), vector.rotateXZ(Math.toRadians(90.0)));
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getS(), vector.rotateXZ(Math.toRadians(180.0)));
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getD(), vector.rotateXZ(Math.toRadians(270.0)));
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getUp(), new LorenzVec(0, 1, 0));
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getDown(), new LorenzVec(0, -1, 0));
    }

    private final void handleEditClicks(class_304 $this$handleEditClicks, LorenzVec vector) {
        block1: {
            if (!KeyboardManager.INSTANCE.isKeyClicked($this$handleEditClicks.field_1655.method_1444())) break block1;
            GraphingNode graphingNode = activeNode;
            if (graphingNode != null) {
                GraphingNode it = graphingNode;
                boolean bl = false;
                it.setPosition(it.getPosition().plus(vector));
            }
        }
    }

    public final void onMinecraftInput(@NotNull class_304 keyBinding, @NotNull CallbackInfoReturnable<Boolean> cir) {
        Intrinsics.checkNotNullParameter((Object)keyBinding, (String)"keyBinding");
        Intrinsics.checkNotNullParameter(cir, (String)"cir");
        if (!this.isEnabled()) {
            return;
        }
        if (!inEditMode) {
            return;
        }
        if (!KeyboardManager.WasdInputMatrix.INSTANCE.contains(keyBinding)) {
            return;
        }
        cir.setReturnValue((Object)false);
    }

    private final void addNode() {
        boolean bl;
        block7: {
            GraphingNode closestNode = GraphEditor.closestNode;
            if (closestNode != null && GraphUtils.INSTANCE.distanceSqToPlayer(closestNode) < 9.0 && Intrinsics.areEqual((Object)closestNode, (Object)activeNode)) {
                this.feedBackInTutorial("Removed node, since you where closer than 3 blocks from a the active node.");
                nodes.remove(closestNode);
                edges.removeIf(arg_0 -> GraphEditor.addNode$lambda$26(arg_0 -> GraphEditor.addNode$lambda$25(closestNode, arg_0), arg_0));
                if (Intrinsics.areEqual((Object)closestNode, (Object)activeNode)) {
                    this.setActiveNode(null);
                }
                INSTANCE.setClosestNode(null);
                return;
            }
            Iterable $this$any$iv = nodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GraphingNode it = (GraphingNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getPosition(), (Object)GraphUtils.INSTANCE.getPlayerPosition())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            this.feedBackInTutorial("Can't create node, here is already another one.");
            return;
        }
        int n = id;
        id = n + 1;
        GraphingNode node = new GraphingNode(n, GraphUtils.INSTANCE.getPlayerPosition(), null, null, 12, null);
        nodes.add(node);
        this.feedBackInTutorial("Added graph node.");
        if (activeNode == null) {
            return;
        }
        GraphEditor.addEdge$default(this, activeNode, node, null, 4, null);
    }

    private final Integer getEdgeIndex(GraphingNode node1, GraphingNode node2) {
        Integer n;
        if (node1 != null && node2 != null && !Intrinsics.areEqual((Object)node1, (Object)node2)) {
            int n2;
            block4: {
                GraphingEdge e = new GraphingEdge(node1, node2, null, 4, null);
                boolean bl = false;
                List<GraphingEdge> $this$indexOfFirst$iv = edges;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<GraphingEdge> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    GraphingEdge item$iv;
                    GraphingEdge it = item$iv = iterator2.next();
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)e)) {
                        n2 = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            Integer n3 = n2;
            int it = ((Number)n3).intValue();
            boolean bl = false;
            n = it != -1 ? n3 : null;
        } else {
            n = null;
        }
        return n;
    }

    private final boolean addEdge(GraphingNode node1, GraphingNode node2, EdgeDirection direction) {
        boolean bl;
        if (node1 != null && node2 != null && !Intrinsics.areEqual((Object)node1, (Object)node2)) {
            GraphingEdge edge = new GraphingEdge(node1, node2, direction);
            if (edge.isInEdge(activeNode)) {
                this.checkDissolve();
                selectedEdge = this.findEdgeBetweenActiveAndClosest();
            }
            bl = edges.add(edge);
        } else {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean addEdge$default(GraphEditor graphEditor, GraphingNode graphingNode, GraphingNode graphingNode2, EdgeDirection edgeDirection, int n, Object object) {
        if ((n & 4) != 0) {
            edgeDirection = EdgeDirection.BOTH;
        }
        return graphEditor.addEdge(graphingNode, graphingNode2, edgeDirection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<? extends GraphNode> compileGraph-rIAQGNA() {
        void $this$mapTo$iv$iv;
        Collection collection;
        Iterable $this$map$iv;
        void $this$mapIndexedTo$iv$iv;
        int n;
        Collection collection2;
        void $this$mapIndexedTo$iv$iv2;
        Iterable $this$mapIndexed$iv = nodes;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
            void index2;
            void node2;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphingNode graphingNode = (GraphingNode)item$iv$iv;
            int n3 = n2;
            collection2 = destination$iv$iv;
            n = 0;
            collection2.add(TuplesKt.to((Object)node2.getId(), (Object)((int)index2)));
        }
        Map indexedTable = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable $this$mapIndexed$iv2 = nodes;
        boolean $i$f$mapIndexed2 = false;
        destination$iv$iv = $this$mapIndexed$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
        boolean $i$f$mapIndexedTo2 = false;
        int index$iv$iv2 = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Collection<String> collection3;
            void $this$mapTo$iv$iv2;
            void index;
            void node;
            int node2;
            if ((node2 = index$iv$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphingNode index2 = (GraphingNode)item$iv$iv;
            n = node2;
            collection2 = destination$iv$iv2;
            boolean bl = false;
            Iterable iterable2 = node.getTags();
            String string = node.getName();
            LorenzVec lorenzVec = node.getPosition();
            void var18_40 = index;
            boolean $i$f$map = false;
            collection = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                GraphNodeTag graphNodeTag = (GraphNodeTag)((Object)item$iv$iv2);
                collection3 = destination$iv$iv3;
                boolean bl2 = false;
                collection3.add(it.getInternalName());
            }
            Collection<String> collection4 = collection3 = (List)destination$iv$iv3;
            String string2 = string;
            LorenzVec lorenzVec2 = lorenzVec;
            void var34_54 = var18_40;
            collection2.add(new GraphNode((int)var34_54, lorenzVec2, string2, (List<String>)collection4));
        }
        List nodes = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = GraphEditor.nodes;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$sortedBy$iv;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv3;
            GraphingEdge it;
            void $this$filterTo$iv$iv;
            GraphingNode node2 = (GraphingNode)item$iv$iv;
            collection2 = destination$iv$iv4;
            boolean bl = false;
            Iterable $this$filter$iv = edges;
            boolean $i$f$filter = false;
            $this$map$iv = $this$filter$iv;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GraphingEdge)element$iv$iv;
                boolean bl3 = false;
                if (!(it.isInEdge(node2) && it.isValidDirectionFrom(node2))) continue;
                destination$iv$iv5.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv5;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv3;
            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                void edge;
                it = (GraphingEdge)item$iv$iv3;
                collection = destination$iv$iv5;
                boolean bl4 = false;
                GraphingNode otherNode = Intrinsics.areEqual((Object)node2, (Object)edge.getNode1()) ? edge.getNode2() : edge.getNode1();
                Object v = indexedTable.get(otherNode.getId());
                Intrinsics.checkNotNull(v);
                collection.add(TuplesKt.to(nodes.get(((Number)v).intValue()), (Object)node2.getPosition().distance(otherNode.getPosition())));
            }
            $this$map$iv3 = (List)destination$iv$iv5;
            boolean $i$f$sortedBy = false;
            collection2.add(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getSecond();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
                }
            }));
        }
        List neighbours = (List)destination$iv$iv4;
        Iterable $this$forEachIndexed$iv = nodes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void node;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphNode item$iv$iv = (GraphNode)item$iv;
            int index = n4;
            boolean bl = false;
            node.setNeighbours(MapsKt.toMap((Iterable)((Iterable)neighbours.get(index))));
        }
        return Graph.constructor-impl(nodes);
    }

    /*
     * WARNING - void declaration
     */
    public final void import-0y7Y464(@NotNull List<? extends GraphNode> graph) {
        void destination$iv$iv$iv;
        void $this$aggregateTo$iv$iv$iv;
        void $this$reduce$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$mapIndexedTo$iv$iv;
        Object element$iv$iv$iv;
        Object object;
        Iterator $this$mapNotNullTo$iv$iv;
        Object object2;
        Iterator it;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        this.clear();
        Iterable iterable = Graph.box-impl(graph);
        Collection<GraphingNode> collection2 = nodes;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $this$mapNotNull$iv;
            GraphNode graphNode = (GraphNode)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = ((GraphNode)((Object)it)).getTagNames();
            object2 = ((GraphNode)((Object)it)).getName();
            LorenzVec lorenzVec = ((GraphNode)((Object)it)).getPosition();
            int n = ((GraphNode)((Object)it)).getId();
            boolean $i$f$mapNotNull = false;
            void var18_40 = $this$mapNotNull$iv;
            Collection collection4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                GraphNodeTag it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl2 = false;
                String tag = (String)element$iv$iv;
                boolean bl3 = false;
                if (GraphNodeTag.Companion.byId(tag) == null) continue;
                boolean bl4 = false;
                collection4.add(it$iv$iv);
            }
            List list = (List)collection4;
            List list2 = CollectionsKt.toMutableList((Collection)list);
            Object object3 = object2;
            LorenzVec lorenzVec2 = lorenzVec;
            int n2 = n;
            collection3.add(new GraphingNode(n2, lorenzVec2, (String)object3, list2));
        }
        collection2.addAll((List)destination$iv$iv);
        Iterable $this$mapIndexed$iv = Graph.box-impl(graph);
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void node;
            int $this$mapNotNull$iv;
            if (($this$mapNotNull$iv = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object2 = (GraphNode)item$iv$iv;
            int n = $this$mapNotNull$iv;
            collection2 = destination$iv$iv3;
            boolean bl = false;
            collection2.add((GraphingNode)TuplesKt.to((Object)node, (Object)nodes.get((int)index)));
        }
        Map translation = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
        Iterable $this$map$iv2 = Graph.box-impl(graph);
        boolean $i$f$map2 = false;
        destination$iv$iv3 = $this$map$iv2;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            void node;
            GraphNode $this$mapNotNull$iv = (GraphNode)item$iv$iv;
            collection2 = destination$iv$iv4;
            boolean bl = false;
            Map<GraphNode, Double> $this$map$iv3 = node.getNeighbours();
            boolean $i$f$map3 = false;
            Map<GraphNode, Double> map = $this$map$iv3;
            Collection destination$iv$iv5 = new ArrayList($this$map$iv3.size());
            boolean $i$f$mapTo3 = false;
            $this$mapNotNullTo$iv$iv = $this$mapTo$iv$iv3.entrySet().iterator();
            while ($this$mapNotNullTo$iv$iv.hasNext()) {
                void it2;
                Map.Entry entry;
                Map.Entry $i$f$mapNotNullTo = entry = $this$mapNotNullTo$iv$iv.next();
                collection = destination$iv$iv5;
                boolean bl5 = false;
                Object v = translation.get(node);
                Intrinsics.checkNotNull(v);
                GraphingNode graphingNode = (GraphingNode)v;
                Object v2 = translation.get(it2.getKey());
                Intrinsics.checkNotNull(v2);
                collection.add(new GraphingEdge(graphingNode, (GraphingNode)v2, EdgeDirection.ONE_TO_TWO));
            }
            collection2.add((GraphingNode)((Object)((List)destination$iv$iv5)));
        }
        List neighbors = CollectionsKt.flatten((Iterable)((List)destination$iv$iv4));
        Iterable $this$groupingBy$iv = neighbors;
        boolean $i$f$groupingBy = false;
        $this$groupingBy$iv = (Grouping)new Grouping<GraphingEdge, GraphingEdge>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<GraphingEdge> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                GraphingEdge it = (GraphingEdge)element;
                boolean bl = false;
                return var2_2;
            }
        };
        boolean $i$f$reduce = false;
        void $this$aggregate$iv$iv = $this$reduce$iv;
        boolean $i$f$aggregate = false;
        it = $this$aggregate$iv$iv;
        Map item$iv$iv = new LinkedHashMap();
        boolean $i$f$aggregateTo = false;
        Iterator iterator2 = $this$aggregateTo$iv$iv$iv.sourceIterator();
        while (iterator2.hasNext()) {
            void v3;
            void first$iv;
            Object e$iv$iv$iv = iterator2.next();
            Object key$iv$iv$iv = $this$aggregateTo$iv$iv$iv.keyOf(e$iv$iv$iv);
            Object accumulator$iv$iv$iv = destination$iv$iv$iv.get(key$iv$iv$iv);
            boolean destination$iv$iv5 = accumulator$iv$iv$iv == null && !destination$iv$iv$iv.containsKey(key$iv$iv$iv);
            Object $i$f$mapTo3 = e$iv$iv$iv;
            $this$mapNotNullTo$iv$iv = accumulator$iv$iv$iv;
            Object object4 = key$iv$iv$iv;
            Object object5 = key$iv$iv$iv;
            collection = destination$iv$iv$iv;
            boolean bl = false;
            if (first$iv != false) {
                v3 = e$iv;
            } else {
                void accumulator;
                void element;
                void acc$iv;
                object = (GraphingEdge)e$iv;
                element$iv$iv$iv = (GraphingEdge)acc$iv;
                GraphingEdge cfr_ignored_0 = (GraphingEdge)object4;
                boolean bl6 = false;
                if (Intrinsics.areEqual((Object)element.getNode1(), (Object)accumulator.getNode1()) && accumulator.getDirection() != element.getDirection() || Intrinsics.areEqual((Object)element.getNode1(), (Object)accumulator.getNode2()) && accumulator.getDirection() == element.getDirection()) {
                    accumulator.setDirection(EdgeDirection.BOTH);
                }
                v3 = accumulator;
            }
            void var25_53 = v3;
            collection.put(object5, var25_53);
        }
        void reduced = destination$iv$iv$iv;
        edges.addAll(reduced.values());
        GraphingNode graphingNode = (GraphingNode)CollectionsKt.lastOrNull(nodes);
        id = graphingNode != null ? graphingNode.getId() + 1 : 0;
        this.checkDissolve();
        selectedEdge = this.findEdgeBetweenActiveAndClosest();
    }

    /*
     * WARNING - void declaration
     */
    private final void testDijkstra() {
        List list;
        void $this$zipWithNext$iv;
        GraphingNode it;
        Set<GraphingEdge> set;
        void $this$mapTo$iv$iv;
        Object v4;
        Object element$iv3;
        GraphNode current;
        block13: {
            Object v2;
            List<? extends GraphNode> compiled;
            GraphingNode savedActive;
            block12: {
                GraphingNode graphingNode = closestNode;
                if (graphingNode == null) {
                    return;
                }
                GraphingNode savedCurrent = graphingNode;
                GraphingNode graphingNode2 = activeNode;
                if (graphingNode2 == null) {
                    return;
                }
                savedActive = graphingNode2;
                compiled = this.compileGraph-rIAQGNA();
                this.import-0y7Y464(compiled);
                highlightedEdges.clear();
                highlightedNodes.clear();
                Iterable $this$firstOrNull$iv = Graph.box-impl(compiled);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    GraphNode it2 = (GraphNode)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getPosition(), (Object)savedCurrent.getPosition())) continue;
                    v2 = element$iv2;
                    break block12;
                }
                v2 = null;
            }
            GraphNode graphNode = v2;
            if (graphNode == null) {
                return;
            }
            current = graphNode;
            Iterable $this$firstOrNull$iv = Graph.box-impl(compiled);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv3 : $this$firstOrNull$iv) {
                GraphNode it3 = (GraphNode)element$iv3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it3.getPosition(), (Object)savedActive.getPosition())) continue;
                v4 = element$iv3;
                break block13;
            }
            v4 = null;
        }
        GraphNode graphNode = v4;
        if (graphNode == null) {
            return;
        }
        GraphNode goal = graphNode;
        List<? extends GraphNode> path = GraphUtils.INSTANCE.findShortestPathAsGraph-ihlZYTU(current, goal);
        if (Graph.isEmpty-impl(path)) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "No Path found", false, null, false, false, null, 62, null);
        }
        Iterable $this$map$iv = Graph.box-impl(path);
        boolean $i$f$map = false;
        element$iv3 = $this$map$iv;
        Set<GraphingEdge> destination$iv$iv = (Set<GraphingEdge>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GraphNode graphNode2 = (GraphNode)item$iv$iv;
            set = destination$iv$iv;
            boolean bl = false;
            set.add((GraphingEdge)((Object)nodes.get(((GraphNode)((Object)it)).getId())));
        }
        List inGraph = (List)((Object)destination$iv$iv);
        highlightedNodes.addAll(inGraph);
        $this$map$iv = highlightedNodes;
        set = highlightedEdges;
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                Object v7;
                List list2;
                Object next$iv;
                block14: {
                    Object item$iv$iv;
                    next$iv = iterator$iv.next();
                    item$iv$iv = (GraphingNode)next$iv;
                    it = (GraphingNode)current$iv;
                    list2 = result$iv;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = edges;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv4 : $this$firstOrNull$iv) {
                        void b;
                        void a;
                        GraphingEdge it4 = (GraphingEdge)element$iv4;
                        boolean bl2 = false;
                        if (!it4.isValidConnectionFromTo((GraphingNode)a, (GraphingNode)b)) continue;
                        v7 = element$iv4;
                        break block14;
                    }
                    v7 = null;
                }
                list2.add(v7);
                current$iv = next$iv;
            }
            list = result$iv;
        }
        set.addAll(CollectionsKt.filterNotNull((Iterable)list));
    }

    private final void clear() {
        id = 0;
        nodes.clear();
        edges.clear();
        this.setActiveNode(null);
        this.setClosestNode(null);
        dissolvePossible = false;
    }

    public final void enable() {
        if (!this.getConfig().getEnabled()) {
            this.getConfig().setEnabled(true);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Graph Editor is now active.", false, null, false, false, null, 62, null);
        }
    }

    private static final boolean calculateNewAllNodeFind$lambda$9() {
        return active;
    }

    private static final CharSequence drawNode$lambda$10(GraphNodeTag it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getDisplayName();
    }

    private static final void drawDirection$pyramidDraw(SkyHanniRenderWorldEvent $this_drawDirection, LorenzVec lineOffsetVec, LorenzVec pyramidSize, LorenzVec lineVec, Color $color, LorenzVec pos) {
        WorldRenderUtils.drawPyramid$default(WorldRenderUtils.INSTANCE, $this_drawDirection, pos.plus(lineOffsetVec).plus(pyramidSize), pos.plus(lineOffsetVec), pos.crossProduct(lineVec).normalize().times(pyramidSize.length() / 2.5).plus(pos).plus(lineOffsetVec), $color, false, 16, null);
    }

    private static final Unit onCommandRegistration$lambda$12$lambda$11(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.toggleFeature();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$12(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Enables the graph editor");
        $this$register.setCategory(CommandCategory.DEVELOPER_TEST);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)GraphEditor::onCommandRegistration$lambda$12$lambda$11));
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$14$lambda$13(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.toggleFindAll();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$14(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Navigate over the whole graph network");
        $this$register.setCategory(CommandCategory.DEVELOPER_TEST);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)GraphEditor::onCommandRegistration$lambda$14$lambda$13));
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$16$lambda$15(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.loadThisIsland();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$16(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Loads the current island data into the graph editor.");
        $this$register.setCategory(CommandCategory.DEVELOPER_TEST);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)GraphEditor::onCommandRegistration$lambda$16$lambda$15));
        return Unit.INSTANCE;
    }

    private static final boolean addNode$lambda$25(GraphingNode $closestNode, GraphingEdge it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInEdge($closestNode);
    }

    private static final boolean addNode$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$toggleFeature(GraphEditor $this) {
        $this.toggleFeature();
    }

    static {
        nodes = new ArrayList();
        edges = new ArrayList();
        seeThroughBlocks = true;
        textBox = new TextInput();
        nodeColor = LorenzColor.BLUE.addOpacity(200);
        activeColor = LorenzColor.GREEN.addOpacity(200);
        closestColor = LorenzColor.YELLOW.addOpacity(200);
        dijkstraColor = LorenzColor.LIGHT_PURPLE.addOpacity(200);
        edgeColor = LorenzColor.GOLD.addOpacity(150);
        edgeDijkstraColor = LorenzColor.DARK_BLUE.addOpacity(150);
        edgeSelectedColor = LorenzColor.DARK_RED.addOpacity(150);
        nodesAlreadyFound = new ArrayList();
        bypassTempRemoveTimer = SimpleTimeMark.Companion.farPast();
        lastGuiTime = SimpleTimeMark.Companion.farPast();
        highlightedNodes = new LinkedHashSet();
        highlightedEdges = new LinkedHashSet();
    }
}

