/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net;

import at.hannibal2.skyhanni.deps.commons.net.DatagramSocketFactory;
import at.hannibal2.skyhanni.deps.commons.net.DefaultDatagramSocketFactory;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Objects;

public abstract class DatagramSocketClient
implements AutoCloseable {
    private static final DatagramSocketFactory DEFAULT_SOCKET_FACTORY = new DefaultDatagramSocketFactory();
    private Charset charset = Charset.defaultCharset();
    protected int _timeout_;
    protected DatagramSocket _socket_;
    protected boolean _isOpen_;
    protected DatagramSocketFactory _socketFactory_ = DEFAULT_SOCKET_FACTORY;

    protected DatagramSocket checkOpen() {
        return Objects.requireNonNull(this._socket_, "DatagramSocket");
    }

    @Override
    public void close() {
        if (this._socket_ != null) {
            this._socket_.close();
        }
        this._socket_ = null;
        this._isOpen_ = false;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Deprecated
    public String getCharsetName() {
        return this.charset.name();
    }

    public int getDefaultTimeout() {
        return this._timeout_;
    }

    public InetAddress getLocalAddress() {
        return this.checkOpen().getLocalAddress();
    }

    public int getLocalPort() {
        return this.checkOpen().getLocalPort();
    }

    @Deprecated
    public int getSoTimeout() throws SocketException {
        return this.checkOpen().getSoTimeout();
    }

    public Duration getSoTimeoutDuration() throws SocketException {
        return Duration.ofMillis(this.checkOpen().getSoTimeout());
    }

    public boolean isOpen() {
        return this._isOpen_;
    }

    public void open() throws SocketException {
        this._socket_ = this._socketFactory_.createDatagramSocket();
        this._socket_.setSoTimeout(this._timeout_);
        this._isOpen_ = true;
    }

    public void open(int port) throws SocketException {
        this._socket_ = this._socketFactory_.createDatagramSocket(port);
        this._socket_.setSoTimeout(this._timeout_);
        this._isOpen_ = true;
    }

    public void open(int port, InetAddress localAddress) throws SocketException {
        this._socket_ = this._socketFactory_.createDatagramSocket(port, localAddress);
        this._socket_.setSoTimeout(this._timeout_);
        this._isOpen_ = true;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setDatagramSocketFactory(DatagramSocketFactory factory) {
        this._socketFactory_ = factory == null ? DEFAULT_SOCKET_FACTORY : factory;
    }

    public void setDefaultTimeout(Duration timeout) {
        this._timeout_ = Math.toIntExact(timeout.toMillis());
    }

    @Deprecated
    public void setDefaultTimeout(int timeout) {
        this._timeout_ = timeout;
    }

    public void setSoTimeout(Duration timeout) throws SocketException {
        this.checkOpen().setSoTimeout(Math.toIntExact(timeout.toMillis()));
    }

    @Deprecated
    public void setSoTimeout(int timeout) throws SocketException {
        this.checkOpen().setSoTimeout(timeout);
    }
}

