/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat.mobs;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.combat.MobsConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_2398;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001f\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\"\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001c\u001a\u0004\b!\u0010\u001eR\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010,\u001a\u00020+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010(R\u0016\u0010/\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u0010(\u00a8\u00060"}, d2={"Lat/hannibal2/skyhanni/features/combat/mobs/ArachneSpawnTimer;", "", "<init>", "()V", "", "onWorldChange", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "event", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "arachneFragmentPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getArachneFragmentPattern", "()Ljava/util/regex/Pattern;", "arachneFragmentPattern", "arachneCrystalPattern$delegate", "getArachneCrystalPattern", "arachneCrystalPattern", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "arachneAltarLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "arachneSpawnTime", "J", "saveNextTickParticles", "Z", "", "particleCounter", "I", "lastTickTime", "searchTime", "1.21.8"})
public final class ArachneSpawnTimer {
    @NotNull
    public static final ArachneSpawnTimer INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern arachneFragmentPattern$delegate;
    @NotNull
    private static final RepoPattern arachneCrystalPattern$delegate;
    @NotNull
    private static final LorenzVec arachneAltarLocation;
    private static long arachneSpawnTime;
    private static boolean saveNextTickParticles;
    private static int particleCounter;
    private static long lastTickTime;
    private static long searchTime;

    private ArachneSpawnTimer() {
    }

    private final MobsConfig getConfig() {
        return SkyHanniMod.feature.getCombat().getMobs();
    }

    private final Pattern getArachneFragmentPattern() {
        return (Pattern)arachneFragmentPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getArachneCrystalPattern() {
        return (Pattern)arachneCrystalPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @HandleEvent
    public final void onWorldChange() {
        searchTime = SimpleTimeMark.Companion.farPast();
        lastTickTime = SimpleTimeMark.Companion.farPast();
        particleCounter = 0;
        saveNextTickParticles = false;
        arachneSpawnTime = SimpleTimeMark.Companion.farPast();
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (SimpleTimeMark.isInPast-impl(arachneSpawnTime)) {
            return;
        }
        long countDown = SimpleTimeMark.timeUntil-UwyO8pc(arachneSpawnTime);
        String format = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, countDown, null, true, false, 0, false, false, 61, null);
        WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, arachneAltarLocation, "\u00a7b" + format, 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        String string = StringUtils.removeColor$default(StringUtils.INSTANCE, event.getMessage(), false, 1, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String message = string;
        if (RegexUtils.INSTANCE.matches(this.getArachneFragmentPattern(), message) || RegexUtils.INSTANCE.matches(this.getArachneCrystalPattern(), message)) {
            if (RegexUtils.INSTANCE.matches(this.getArachneCrystalPattern(), message)) {
                saveNextTickParticles = true;
                searchTime = SimpleTimeMark.Companion.now-uFjCsEo();
                particleCounter = 0;
                lastTickTime = SimpleTimeMark.Companion.farPast();
            } else {
                arachneSpawnTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration((int)19, (DurationUnit)DurationUnit.SECONDS));
            }
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.SPIDER_DEN, priority=1, receiveCancelled=true)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!saveNextTickParticles) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(searchTime), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (particleCounter == 0 && SimpleTimeMark.isFarPast-impl(lastTickTime)) {
            lastTickTime = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastTickTime), (long)DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.MILLISECONDS)) > 0) {
            arachneSpawnTime = particleCounter <= 20 ? SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration((int)21, (DurationUnit)DurationUnit.SECONDS)) : SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration((int)37, (DurationUnit)DurationUnit.SECONDS));
            saveNextTickParticles = false;
            return;
        }
        LorenzVec location = event.getLocation().roundTo(2);
        if (arachneAltarLocation.distance(location) > 30.0) {
            return;
        }
        if (Intrinsics.areEqual(event.getType(), (Object)class_2398.field_11212) && event.getSpeed() == 1.0f) {
            ++particleCounter;
        }
    }

    public final boolean isEnabled() {
        return IslandType.SPIDER_DEN.isCurrent() && Intrinsics.areEqual((Object)SkyBlockUtils.INSTANCE.getGraphArea(), (Object)"Arachne's Sanctuary") && this.getConfig().getShowArachneSpawnTimer();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ArachneSpawnTimer.class, "arachneFragmentPattern", "getArachneFragmentPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ArachneSpawnTimer.class, "arachneCrystalPattern", "getArachneCrystalPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new ArachneSpawnTimer();
        patternGroup = RepoPattern.Companion.group("combat.mobs.spawntime.arachne");
        arachneFragmentPattern$delegate = patternGroup.pattern("fragment", "^\u2604 [a-z0-9_]{2,22} placed an arachne's calling! something is awakening! \\(4/4\\)$");
        arachneCrystalPattern$delegate = patternGroup.pattern("crystal", "^\u2604 [a-z0-9_]{2,22} placed an arachne crystal! something is awakening!$");
        arachneAltarLocation = new LorenzVec(-283.0f, 51.0f, -179.0f);
        arachneSpawnTime = SimpleTimeMark.Companion.farPast();
        lastTickTime = SimpleTimeMark.Companion.farPast();
        searchTime = SimpleTimeMark.Companion.farPast();
    }
}

