/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.hoppity;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.features.event.hoppity.HoppityEggsConfig;
import at.hannibal2.skyhanni.config.features.event.hoppity.HoppityWaypointsConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.hoppity.EggFoundEvent;
import at.hannibal2.skyhanni.events.hoppity.EggSpawnedEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityApi;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggLocations;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggType;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggsManager;
import at.hannibal2.skyhanni.features.event.hoppity.MythicRabbitPetWarning;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.ParticlePathBezierFitter;
import at.hannibal2.skyhanni.utils.RecalculatingValue;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u0006*\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J!\u0010\u0015\u001a\u00020\u0006*\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u001a\u001a\u00020\u0006*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J\u0011\u0010%\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b'\u0010\u0003J\u0015\u0010(\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0013\u00a2\u0006\u0004\b(\u0010)J\u0013\u0010*\u001a\u00020\u001c*\u00020\u001fH\u0002\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00020\u001c\u00a2\u0006\u0004\b,\u0010\u001eJ\u0017\u0010.\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020-H\u0007\u00a2\u0006\u0004\b.\u0010/J\u001d\u00102\u001a\u00020\u00062\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001800H\u0002\u00a2\u0006\u0004\b2\u00103J\u0017\u00105\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000204H\u0007\u00a2\u0006\u0004\b5\u00106R\u0014\u0010:\u001a\u0002078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0014\u0010>\u001a\u00020;8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0017\u0010@\u001a\u00020?8\u0006\u00a2\u0006\f\n\u0004\b@\u0010A\u001a\u0004\bB\u0010CR\u0016\u0010E\u001a\u00020D8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u0016\u0010G\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010HR$\u0010I\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010&\"\u0004\bL\u0010MR(\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00130N8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010P\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR$\u0010V\u001a\u0004\u0018\u00010U8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010W\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R$\u0010\\\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\\\u0010]\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR\u0014\u0010c\u001a\u00020b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bc\u0010dR\u0018\u0010f\u001a\u00020\u001c*\u00020e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bf\u0010gR\u001b\u0010k\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bh\u0010i\u001a\u0004\bj\u0010\u001e\u00a8\u0006l"}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocator;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/hoppity/EggFoundEvent;", "event", "", "onEggFound", "(Lat/hannibal2/skyhanni/events/hoppity/EggFoundEvent;)V", "onWorldChange", "resetData", "Lat/hannibal2/skyhanni/events/hoppity/EggSpawnedEvent;", "onEggSpawn", "(Lat/hannibal2/skyhanni/events/hoppity/EggSpawnedEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "drawGuessLocations", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "islandEggsLocations", "drawDuplicateEggs", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;Ljava/util/Set;)V", "location", "", "label", "drawEggWaypoint", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/lang/String;)V", "", "shouldShowAllEggs", "()Z", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "onItemClick", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "guessEggLocation", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "trySendingGraph", "isValidEggLocation", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "isVillagerParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)Z", "isEnabled", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "", "args", "testPathFind", "([Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityEggsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityEggsConfig;", "config", "Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityWaypointsConfig;", "getWaypointsConfig", "()Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityWaypointsConfig;", "waypointsConfig", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "locatorItem", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "getLocatorItem", "()Lat/hannibal2/skyhanni/utils/NeuInternalName;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastClick", "J", "drawLocations", "Z", "sharedEggLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getSharedEggLocation", "setSharedEggLocation", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "", "possibleEggLocations", "Ljava/util/List;", "getPossibleEggLocations", "()Ljava/util/List;", "setPossibleEggLocations", "(Ljava/util/List;)V", "Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggType;", "currentEggType", "Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggType;", "getCurrentEggType", "()Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggType;", "setCurrentEggType", "(Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggType;)V", "currentEggNote", "Ljava/lang/String;", "getCurrentEggNote", "()Ljava/lang/String;", "setCurrentEggNote", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/utils/ParticlePathBezierFitter;", "bezierFitter", "Lat/hannibal2/skyhanni/utils/ParticlePathBezierFitter;", "Lnet/minecraft/class_1799;", "isLocatorItem", "(Lnet/minecraft/class_1799;)Z", "locatorInHotbar$delegate", "Lat/hannibal2/skyhanni/utils/RecalculatingValue;", "getLocatorInHotbar", "locatorInHotbar", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nHoppityEggLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoppityEggLocator.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n*L\n1#1,267:1\n774#2:268\n865#2,2:269\n1761#2,3:288\n1761#2,3:291\n148#3,4:271\n46#3:275\n153#3:276\n192#3,11:277\n*S KotlinDebug\n*F\n+ 1 HoppityEggLocator.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocator\n*L\n99#1:268\n99#1:269,2\n212#1:288,3\n225#1:291,3\n168#1:271,4\n168#1:275\n168#1:276\n168#1:277,11\n*E\n"})
public final class HoppityEggLocator {
    @NotNull
    public static final HoppityEggLocator INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final NeuInternalName locatorItem;
    private static long lastClick;
    private static boolean drawLocations;
    @Nullable
    private static LorenzVec sharedEggLocation;
    @NotNull
    private static List<LorenzVec> possibleEggLocations;
    @Nullable
    private static HoppityEggType currentEggType;
    @Nullable
    private static String currentEggNote;
    @NotNull
    private static final ParticlePathBezierFitter bezierFitter;
    @NotNull
    private static final RecalculatingValue locatorInHotbar$delegate;

    private HoppityEggLocator() {
    }

    private final HoppityEggsConfig getConfig() {
        return HoppityEggsManager.INSTANCE.getConfig();
    }

    private final HoppityWaypointsConfig getWaypointsConfig() {
        return this.getConfig().getWaypoints();
    }

    @NotNull
    public final NeuInternalName getLocatorItem() {
        return locatorItem;
    }

    @Nullable
    public final LorenzVec getSharedEggLocation() {
        return sharedEggLocation;
    }

    public final void setSharedEggLocation(@Nullable LorenzVec lorenzVec) {
        sharedEggLocation = lorenzVec;
    }

    @NotNull
    public final List<LorenzVec> getPossibleEggLocations() {
        return possibleEggLocations;
    }

    public final void setPossibleEggLocations(@NotNull List<LorenzVec> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        possibleEggLocations = list;
    }

    @Nullable
    public final HoppityEggType getCurrentEggType() {
        return currentEggType;
    }

    public final void setCurrentEggType(@Nullable HoppityEggType hoppityEggType) {
        currentEggType = hoppityEggType;
    }

    @Nullable
    public final String getCurrentEggNote() {
        return currentEggNote;
    }

    public final void setCurrentEggNote(@Nullable String string) {
        currentEggNote = string;
    }

    @HandleEvent
    public final void onEggFound(@NotNull EggFoundEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getType().isResetting()) {
            this.resetData();
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        this.resetData();
    }

    private final void resetData() {
        possibleEggLocations = CollectionsKt.emptyList();
        drawLocations = false;
        sharedEggLocation = null;
        currentEggType = null;
        currentEggNote = null;
        bezierFitter.reset();
    }

    @HandleEvent
    public final void onEggSpawn(@NotNull EggSpawnedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEggType() == currentEggType) {
            this.resetData();
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (drawLocations) {
            this.drawGuessLocations(event);
            return;
        }
        LorenzVec lorenzVec = sharedEggLocation;
        if (lorenzVec != null) {
            LorenzVec it = lorenzVec;
            boolean bl = false;
            if (INSTANCE.getWaypointsConfig().getShared()) {
                INSTANCE.drawEggWaypoint(event, it, "\u00a7aShared Egg");
                return;
            }
        }
        Set islandEggsLocations = HoppityEggLocations.INSTANCE.getIslandLocations();
        if (this.shouldShowAllEggs()) {
            if (this.getWaypointsConfig().getHideDuplicates()) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = islandEggsLocations;
                boolean $i$f$filter = false;
                Iterable bl = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LorenzVec it = (LorenzVec)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!HoppityEggLocations.INSTANCE.hasCollectedEgg(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                islandEggsLocations = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            for (LorenzVec eggLocation : islandEggsLocations) {
                this.drawEggWaypoint(event, eggLocation, "\u00a7aEgg");
            }
            return;
        }
        this.drawDuplicateEggs(event, islandEggsLocations);
    }

    private final void drawGuessLocations(SkyHanniRenderWorldEvent $this$drawGuessLocations) {
        Iterator iterator2 = ((Iterable)possibleEggLocations).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            LorenzVec eggLocation = (LorenzVec)iterator2.next();
            String name2 = possibleEggLocations.size() == 1 ? "\u00a7aGuess" : "\u00a7aGuess #" + (index + 1);
            this.drawEggWaypoint($this$drawGuessLocations, eggLocation, name2);
            if (!this.getWaypointsConfig().getShowLine()) continue;
            WorldRenderUtils.INSTANCE.drawLineToEye($this$drawGuessLocations, eggLocation.blockCenter(), LorenzColor.toChromaColor$default(LorenzColor.GREEN, 0, 0, 3, null), 2, false);
        }
    }

    private final void drawDuplicateEggs(SkyHanniRenderWorldEvent $this$drawDuplicateEggs, Set<LorenzVec> islandEggsLocations) {
        if (!this.getWaypointsConfig().getHighlightDuplicates() || !this.getWaypointsConfig().getShowNearbyDuplicates()) {
            return;
        }
        for (LorenzVec eggLocation : islandEggsLocations) {
            double dist = LocationUtils.INSTANCE.distanceToPlayer(eggLocation);
            if (!(dist < 10.0) || !HoppityEggLocations.INSTANCE.hasCollectedEgg(eggLocation)) continue;
            float alpha = (float)RangesKt.coerceAtMost((double)(((double)10 - dist) / (double)10), (double)0.5);
            WorldRenderUtils.drawColor$default(WorldRenderUtils.INSTANCE, $this$drawDuplicateEggs, eggLocation, LorenzColor.toChromaColor$default(LorenzColor.RED, 0, 0, 3, null), false, alpha, false, 16, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, $this$drawDuplicateEggs, LorenzVec.up$default(eggLocation, null, 1, null), "\u00a7cDuplicate Location!", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    private final void drawEggWaypoint(SkyHanniRenderWorldEvent $this$drawEggWaypoint, LorenzVec location, String label) {
        Object possibleDuplicateLabel;
        boolean shouldMarkDuplicate = this.getWaypointsConfig().getHighlightDuplicates() && HoppityEggLocations.INSTANCE.hasCollectedEgg(location);
        Object object = possibleDuplicateLabel = shouldMarkDuplicate ? label + " \u00a7c(Duplicate Location)" : label;
        if (!shouldMarkDuplicate) {
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, $this$drawEggWaypoint, location, ColorUtils.INSTANCE.toColor(this.getWaypointsConfig().getColor()), true, false, 0.0, 0.0, 0.0, 0.0f, false, 504, null);
        } else {
            WorldRenderUtils.drawColor$default(WorldRenderUtils.INSTANCE, $this$drawEggWaypoint, location, LorenzColor.toChromaColor$default(LorenzColor.RED, 0, 0, 3, null), false, 0.5f, false, 16, null);
        }
        WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, $this$drawEggWaypoint, LorenzVec.up$default(location, null, 1, null), (String)possibleDuplicateLabel, 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
    }

    private final boolean shouldShowAllEggs() {
        return this.getWaypointsConfig().getShowAll() && !this.getLocatorInHotbar() && HoppityEggType.Companion.anyEggsUnclaimed();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnSkyblock=true)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        List list;
        void this_$iv$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isVillagerParticle(event)) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastClick), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)) > 0) {
            return;
        }
        LorenzVec pos = event.getLocation();
        if (bezierFitter.isEmpty()) {
            bezierFitter.addPoint(pos);
            return;
        }
        LorenzVec lorenzVec = bezierFitter.getLastPoint();
        if (lorenzVec == null) {
            return;
        }
        LorenzVec lastPoint = lorenzVec;
        double dist = lastPoint.distance(pos);
        if (dist == 0.0 || dist > 3.0) {
            return;
        }
        EntityUtils entityUtils = EntityUtils.INSTANCE;
        double radius$iv = 0.3;
        void this_$iv$iv2 = $this$iv;
        boolean $i$f$getALWAYS = false;
        Function1 predicate$iv = EntityUtils.ALWAYS.1.INSTANCE;
        boolean $i$f$getEntitiesNearby = false;
        void var13_11 = $this$iv;
        Function1 predicate$iv$iv = (Function1)new Function1<class_1536, Boolean>(pos, radius$iv, predicate$iv){
            final /* synthetic */ LorenzVec $location;
            final /* synthetic */ double $radius;
            final /* synthetic */ Function1 $predicate;
            {
                this.$location = $location;
                this.$radius = $radius;
                this.$predicate = $predicate;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Boolean invoke(class_1297 it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LocationUtils.INSTANCE.distanceTo(it, this.$location) < this.$radius && (Boolean)this.$predicate.invoke((Object)it) != false;
            }
        };
        boolean $i$f$getEntitiesInBox = false;
        void var14_12 = this_$iv$iv;
        class_238 aabb$iv$iv$iv = pos.boundingCenter(radius$iv);
        boolean $i$f$getEntitiesInBoundingBox = false;
        class_638 class_6382 = MinecraftCompat.INSTANCE.getLocalWorldOrNull();
        if (class_6382 == null) {
            list = CollectionsKt.emptyList();
        } else {
            class_638 world$iv$iv$iv = class_6382;
            Function1 function1 = predicate$iv$iv;
            List list2 = world$iv$iv$iv.method_8390(class_1536.class, aabb$iv$iv$iv, new Predicate(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    return (Boolean)this.function.invoke(p0);
                }
            });
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntitiesByClass(...)");
        }
        if (CollectionsKt.any((Iterable)list)) {
            return;
        }
        bezierFitter.addPoint(pos);
        LorenzVec lorenzVec2 = this.guessEggLocation();
        if (lorenzVec2 == null) {
            return;
        }
        LorenzVec guess = lorenzVec2;
        if (!SkyBlockUtils.INSTANCE.getCurrentIsland().isInBounds(guess)) {
            return;
        }
        possibleEggLocations = CollectionsKt.listOf((Object)guess);
        drawLocations = true;
        if (possibleEggLocations.size() == 1) {
            this.trySendingGraph();
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onItemClick(@NotNull ItemClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        class_1799 class_17992 = event.getItemInHand();
        if (class_17992 == null) {
            return;
        }
        class_1799 item2 = class_17992;
        if (event.getClickType() == ClickType.RIGHT_CLICK && this.isLocatorItem(item2)) {
            if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastClick), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)) >= 0) {
                lastClick = SimpleTimeMark.Companion.now-uFjCsEo();
                MythicRabbitPetWarning.INSTANCE.check();
                this.trySendingGraph();
                bezierFitter.reset();
            }
        }
    }

    private final LorenzVec guessEggLocation() {
        LorenzVec lorenzVec = bezierFitter.solve();
        if (lorenzVec == null) {
            return null;
        }
        LorenzVec guessLocation = lorenzVec;
        LorenzVec guessEgg = (LorenzVec)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)HoppityEggLocations.INSTANCE.getIslandLocations(), (arg_0, arg_1) -> HoppityEggLocator.guessEggLocation$lambda$3((arg_0, arg_1) -> HoppityEggLocator.guessEggLocation$lambda$2(guessLocation, arg_0, arg_1), arg_0, arg_1)));
        return guessEgg;
    }

    private final void trySendingGraph() {
        if (!this.getWaypointsConfig().getShowPathFinder()) {
            return;
        }
        LorenzVec lorenzVec = (LorenzVec)CollectionsKt.firstOrNull(possibleEggLocations);
        if (lorenzVec == null) {
            return;
        }
        LorenzVec location = lorenzVec;
        Color color = ColorUtils.INSTANCE.toColor(this.getWaypointsConfig().getColor());
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, location, "Hoppity Egg", color, null, null, HoppityEggLocator::trySendingGraph$lambda$4, 24, null);
    }

    public final boolean isValidEggLocation(@NotNull LorenzVec location) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Iterable $this$any$iv = HoppityEggLocations.INSTANCE.getIslandLocations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LorenzVec it = (LorenzVec)element$iv;
                    boolean bl2 = false;
                    if (!(it.distance(location) < 5.0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isVillagerParticle(ReceiveParticleEvent $this$isVillagerParticle) {
        return Intrinsics.areEqual($this$isVillagerParticle.getType(), (Object)class_2398.field_11211) && $this$isVillagerParticle.getSpeed() == 0.0f && $this$isVillagerParticle.getCount() == 1;
    }

    public final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getWaypoints().getEnabled() && !GardenApi.INSTANCE.inGarden() && !ReminderUtils.INSTANCE.isBusy(true) && HoppityApi.INSTANCE.isHoppityEvent();
    }

    private final boolean isLocatorItem(class_1799 $this$isLocatorItem) {
        return Intrinsics.areEqual((Object)ItemUtils.INSTANCE.getInternalName($this$isLocatorItem), (Object)locatorItem);
    }

    private final boolean getLocatorInHotbar() {
        return (Boolean)locatorInHotbar$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.title("Hoppity Eggs Locations");
        if (!this.isEnabled()) {
            event.addIrrelevant("not in skyblock or waypoints are disabled");
            return;
        }
        event.addIrrelevant((Function1<? super List<String>, Unit>)((Function1)HoppityEggLocator::onDebug$lambda$8));
    }

    private final void testPathFind(String[] args) {
        block1: {
            int target = NumberUtil.INSTANCE.formatInt(args[0]);
            Map<String, LorenzVec> map = HoppityEggLocations.INSTANCE.getApiEggLocations().get((Object)SkyBlockUtils.INSTANCE.getCurrentIsland());
            if (map == null) break block1;
            Map<String, LorenzVec> it = map;
            boolean bl = false;
            Iterator iterator2 = ((Iterable)it.values()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i2 = n++;
                LorenzVec location = (LorenzVec)iterator2.next();
                if (i2 != target) continue;
                IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, location, "Hoppity Test", null, null, null, HoppityEggLocator::testPathFind$lambda$10$lambda$9, 28, null);
                return;
            }
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register("shtestrabbitpaths", (Function1<? super CommandBuilder, Unit>)((Function1)HoppityEggLocator::onCommandRegistration$lambda$12));
    }

    private static final int guessEggLocation$lambda$2(LorenzVec $guessLocation, LorenzVec a, LorenzVec b) {
        Intrinsics.checkNotNullParameter((Object)$guessLocation, (String)"$guessLocation");
        return (int)Math.signum(a.distanceSq($guessLocation) - b.distanceSq($guessLocation));
    }

    private static final int guessEggLocation$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final boolean trySendingGraph$lambda$4() {
        return INSTANCE.getWaypointsConfig().getShowPathFinder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean locatorInHotbar_delegate$lambda$7() {
        class_1799 it;
        if (!SkyBlockUtils.INSTANCE.getInSkyBlock()) return false;
        Iterable $this$any$iv = InventoryUtils.INSTANCE.getItemsInHotbar();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (class_1799)element$iv;
            boolean bl = false;
        } while (!INSTANCE.isLocatorItem(it));
        return true;
    }

    private static final Unit onDebug$lambda$8(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter((Object)$this$addIrrelevant, (String)"$this$addIrrelevant");
        $this$addIrrelevant.add("Possible Egg Locations: " + possibleEggLocations.size());
        $this$addIrrelevant.add("Draw Locations: " + drawLocations);
        Object object = sharedEggLocation;
        if (object == null) {
            object = "None";
        }
        $this$addIrrelevant.add("Shared Egg Location: " + object);
        Object object2 = currentEggType;
        if (object2 == null) {
            object2 = "None";
        }
        $this$addIrrelevant.add("Current Egg Type: " + (Object)object2);
        String string = currentEggNote;
        if (string == null) {
            string = "None";
        }
        $this$addIrrelevant.add("Current Egg Note: " + string);
        return Unit.INSTANCE;
    }

    private static final boolean testPathFind$lambda$10$lambda$9() {
        return true;
    }

    private static final Unit onCommandRegistration$lambda$12$lambda$11(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.testPathFind(it);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$12(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Tests pathfinding to rabbit eggs. Use a number 0-14.");
        $this$register.setCategory(CommandCategory.DEVELOPER_TEST);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)HoppityEggLocator::onCommandRegistration$lambda$12$lambda$11));
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(HoppityEggLocator.class, "locatorInHotbar", "getLocatorInHotbar()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new HoppityEggLocator();
        locatorItem = NeuInternalName.Companion.toInternalName("EGGLOCATOR");
        lastClick = SimpleTimeMark.Companion.farPast();
        possibleEggLocations = CollectionsKt.emptyList();
        bezierFitter = new ParticlePathBezierFitter(3);
        locatorInHotbar$delegate = new RecalculatingValue(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), HoppityEggLocator::locatorInHotbar_delegate$lambda$7, null);
    }
}

