/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.fishing.FishingBaitWarningsConfig;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.entity.EntityEnterWorldEvent;
import at.hannibal2.skyhanni.events.fishing.FishingBobberInLiquidEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.collection.TimeLimitedSet;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u001f\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0003R\u0014\u0010\u0018\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings;", "", "<init>", "()V", "", "onWorldChange", "Lat/hannibal2/skyhanni/events/fishing/FishingBobberInLiquidEvent;", "event", "onBobber", "(Lat/hannibal2/skyhanni/events/fishing/FishingBobberInLiquidEvent;)V", "Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;", "Lnet/minecraft/class_1542;", "onEntityEnterWorld", "(Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;)V", "checkBait", "", "before", "after", "showBaitChangeWarning", "(Ljava/lang/String;Ljava/lang/String;)V", "showNoBaitWarning", "Lat/hannibal2/skyhanni/config/features/fishing/FishingBaitWarningsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/FishingBaitWarningsConfig;", "config", "lastBait", "Ljava/lang/String;", "", "wasUsingBait", "Z", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedSet;", "Lat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings$Bait;", "baitEntities", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedSet;", "Bait", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nFishingBaitWarnings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FishingBaitWarnings.kt\nat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n774#2:98\n865#2,2:99\n2423#2,14:101\n*S KotlinDebug\n*F\n+ 1 FishingBaitWarnings.kt\nat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings\n*L\n66#1:98\n66#1:99,2\n66#1:101,14\n*E\n"})
public final class FishingBaitWarnings {
    @NotNull
    public static final FishingBaitWarnings INSTANCE = new FishingBaitWarnings();
    @Nullable
    private static String lastBait;
    private static boolean wasUsingBait;
    @NotNull
    private static final TimeLimitedSet<Bait> baitEntities;

    private FishingBaitWarnings() {
    }

    private final FishingBaitWarningsConfig getConfig() {
        return SkyHanniMod.feature.getFishing().getFishingBaitWarnings();
    }

    @HandleEvent
    public final void onWorldChange() {
        lastBait = null;
        wasUsingBait = true;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onBobber(@NotNull FishingBobberInLiquidEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (KuudraApi.INSTANCE.getInKuudra()) {
            return;
        }
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS), (Function0<Unit>)((Function0)FishingBaitWarnings::onBobber$lambda$0));
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onEntityEnterWorld(@NotNull EntityEnterWorldEvent<class_1542> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (KuudraApi.INSTANCE.getInKuudra() || !FishingApi.isFishing$default(FishingApi.INSTANCE, false, 1, null)) {
            return;
        }
        Object object = FishingApi.INSTANCE.getBobber();
        if (object == null || (object = LorenzVecKt.getLorenzVec((class_1297)object)) == null) {
            return;
        }
        double bobberDistance = LocationUtils.INSTANCE.distanceTo((class_1297)event.getEntity(), (LorenzVec)object);
        if (bobberDistance > 2.0) {
            return;
        }
        DelayedRun.INSTANCE.runNextTick((Function0<Unit>)((Function0)() -> FishingBaitWarnings.onEntityEnterWorld$lambda$1(event, bobberDistance)));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBait() {
        Object v0;
        void $this$filterTo$iv$iv;
        if (FishingApi.INSTANCE.getBobber() == null) {
            return;
        }
        Iterable $this$filter$iv = baitEntities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Bait it = (Bait)element$iv$iv;
            boolean bl = false;
            if (!(it.getBobberDistance() < 2.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Bait it = (Bait)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getBobberDistance();
                do {
                    Object e$iv = iterator$iv.next();
                    Bait it2 = (Bait)e$iv;
                    $i$a$-minByOrNull-FishingBaitWarnings$checkBait$bait$2 = false;
                    double v$iv = it2.getBobberDistance();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Bait bait = v0;
        String bait2 = bait != null ? bait.getName() : null;
        baitEntities.clear();
        if (bait2 == null) {
            if (this.getConfig().getNoBaitWarning() && !wasUsingBait) {
                this.showNoBaitWarning();
            }
        } else if (this.getConfig().getBaitChangeWarning()) {
            String string = lastBait;
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)bait2)) {
                    INSTANCE.showBaitChangeWarning(it, bait2);
                }
            }
        }
        wasUsingBait = bait2 != null;
        lastBait = bait2;
    }

    private final void showBaitChangeWarning(String before, String after) {
        SoundUtils.INSTANCE.playClickSound();
        TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7eBait changed!", null, DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Fishing Bait changed: " + before + " \u00a7e-> " + after, false, null, false, false, null, 62, null);
    }

    private final void showNoBaitWarning() {
        SoundUtils.INSTANCE.playErrorSound();
        TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7cNo bait is used!", null, DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "You're not using any fishing baits!", false, null, false, false, null, 62, null);
    }

    private static final Unit onBobber$lambda$0() {
        INSTANCE.checkBait();
        return Unit.INSTANCE;
    }

    private static final Unit onEntityEnterWorld$lambda$1(EntityEnterWorldEvent $event, double $bobberDistance) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        class_1799 class_17992 = ((class_1542)$event.getEntity()).method_6983();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getStack(...)");
        if (FishingApi.INSTANCE.isBait(class_17992)) {
            ((Collection)baitEntities).add(new Bait((class_1542)$event.getEntity(), $bobberDistance, null, 4, null));
        }
        return Unit.INSTANCE;
    }

    static {
        wasUsingBait = true;
        baitEntities = new TimeLimitedSet(DurationKt.toDuration((int)4, (DurationUnit)DurationUnit.SECONDS), null, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c2\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001d\u001a\u0004\b\u001e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings$Bait;", "", "Lnet/minecraft/class_1542;", "entity", "", "bobberDistance", "", "name", "<init>", "(Lnet/minecraft/class_1542;DLjava/lang/String;)V", "component1", "()Lnet/minecraft/class_1542;", "component2", "()D", "component3", "()Ljava/lang/String;", "copy", "(Lnet/minecraft/class_1542;DLjava/lang/String;)Lat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings$Bait;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lnet/minecraft/class_1542;", "D", "getBobberDistance", "Ljava/lang/String;", "getName", "1.21.8"})
    private static final class Bait {
        @NotNull
        private final class_1542 entity;
        private final double bobberDistance;
        @NotNull
        private final String name;

        public Bait(@NotNull class_1542 entity, double bobberDistance, @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.entity = entity;
            this.bobberDistance = bobberDistance;
            this.name = name2;
        }

        public /* synthetic */ Bait(class_1542 class_15422, double d, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string = TextCompatKt.formattedTextCompatLeadingWhiteLessResets(class_15422.method_6983().method_7964());
            }
            this(class_15422, d, string);
        }

        public final double getBobberDistance() {
            return this.bobberDistance;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        private final class_1542 component1() {
            return this.entity;
        }

        public final double component2() {
            return this.bobberDistance;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final Bait copy(@NotNull class_1542 entity, double bobberDistance, @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new Bait(entity, bobberDistance, name2);
        }

        public static /* synthetic */ Bait copy$default(Bait bait, class_1542 class_15422, double d, String string, int n, Object object) {
            if ((n & 1) != 0) {
                class_15422 = bait.entity;
            }
            if ((n & 2) != 0) {
                d = bait.bobberDistance;
            }
            if ((n & 4) != 0) {
                string = bait.name;
            }
            return bait.copy(class_15422, d, string);
        }

        @NotNull
        public String toString() {
            return "Bait(entity=" + this.entity + ", bobberDistance=" + this.bobberDistance + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result2 = this.entity.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.bobberDistance);
            result2 = result2 * 31 + this.name.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bait)) {
                return false;
            }
            Bait bait = (Bait)other;
            if (!Intrinsics.areEqual((Object)this.entity, (Object)bait.entity)) {
                return false;
            }
            if (Double.compare(this.bobberDistance, bait.bobberDistance) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)bait.name);
        }
    }
}

