/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.bazaar;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.inventory.BazaarConfig;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.bazaar.BazaarOpenedProductEvent;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarApi;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarData;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0018\u0010!\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarBestSellMethod;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "event", "", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/bazaar/BazaarOpenedProductEvent;", "onBazaarOpenedProduct", "(Lat/hannibal2/skyhanni/events/bazaar/BazaarOpenedProductEvent;)V", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "internalName", "", "updateDisplay", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "config", "display", "Ljava/lang/String;", "Lnet/minecraft/class_1799;", "lastClickedItem", "Lnet/minecraft/class_1799;", "nextCloseWillResetItem", "Z", "1.21.8"})
public final class BazaarBestSellMethod {
    @NotNull
    public static final BazaarBestSellMethod INSTANCE = new BazaarBestSellMethod();
    @NotNull
    private static String display = "";
    @Nullable
    private static class_1799 lastClickedItem;
    private static boolean nextCloseWillResetItem;

    private BazaarBestSellMethod() {
    }

    private final BazaarConfig getConfig() {
        return SkyHanniMod.feature.getInventory().getBazaar();
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        display = "";
        if (lastClickedItem != null) {
            if (nextCloseWillResetItem) {
                lastClickedItem = null;
            }
            nextCloseWillResetItem = !nextCloseWillResetItem;
        }
    }

    @HandleEvent
    public final void onBazaarOpenedProduct(@NotNull BazaarOpenedProductEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        display = this.updateDisplay(event.getOpenedProduct());
        if (!PlatformUtils.INSTANCE.getIS_LEGACY()) {
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS), (Function0<Unit>)((Function0)() -> BazaarBestSellMethod.onBazaarOpenedProduct$lambda$0(event)));
        }
    }

    private final String updateDisplay(NeuInternalName internalName2) {
        if (internalName2 == null) {
            return "\u00a7cUnknown Bazaar item!";
        }
        int having = 0;
        having = InventoryUtils.INSTANCE.getAmountInInventory(internalName2);
        class_1799 class_17992 = lastClickedItem;
        if (class_17992 != null) {
            class_1799 it = class_17992;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)ItemUtils.INSTANCE.getInternalName(it), (Object)internalName2)) {
                having += it.method_7947();
            }
        }
        if (having <= 0) {
            return "";
        }
        BazaarData data = BazaarApi.INSTANCE.getBazaarDataOrError(internalName2);
        double totalDiff = (data.getInstantBuyPrice() - data.getInstantSellPrice()) * (double)having;
        String result2 = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, (int)totalDiff, false, 1, null);
        String name2 = ItemUtils.INSTANCE.getRepoItemName(internalName2);
        return name2 + "\u00a77 sell difference: \u00a76" + result2 + " coins";
    }

    @HandleEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (((CharSequence)display).length() == 0) {
            return;
        }
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getBestSellMethodPos(), display, 0, 0, "Bazaar Best Sell Method", 6, null);
    }

    @HandleEvent(priority=-1)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        class_1735 class_17352 = event.getSlot();
        lastClickedItem = class_17352 != null ? class_17352.method_7677() : null;
        nextCloseWillResetItem = false;
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getBestSellMethod();
    }

    private static final Unit onBazaarOpenedProduct$lambda$0(BazaarOpenedProductEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        if (((CharSequence)display).length() == 0) {
            display = INSTANCE.updateDisplay($event.getOpenedProduct());
        }
        return Unit.INSTANCE;
    }
}

