/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.render;

import at.hannibal2.skyhanni.utils.compat.DrawContextUtils;
import at.hannibal2.skyhanni.utils.compat.RenderCompat;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ1\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lat/hannibal2/skyhanni/utils/render/RenderPipelineDrawer;", "", "<init>", "()V", "Lcom/mojang/blaze3d/pipeline/RenderPipeline;", "pipeline", "Lnet/minecraft/class_287;", "getBuffer", "(Lcom/mojang/blaze3d/pipeline/RenderPipeline;)Lnet/minecraft/class_287;", "Lnet/minecraft/class_9801;", "mesh", "Lkotlin/Function1;", "Lcom/mojang/blaze3d/systems/RenderPass;", "", "pass", "draw", "(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/class_9801;Lkotlin/jvm/functions/Function1;)V", "Lorg/joml/Matrix3x2f;", "getMatrices", "()Lorg/joml/Matrix3x2f;", "matrices", "1.21.8"})
public final class RenderPipelineDrawer {
    @NotNull
    public static final RenderPipelineDrawer INSTANCE = new RenderPipelineDrawer();

    private RenderPipelineDrawer() {
    }

    @NotNull
    public final Matrix3x2f getMatrices() {
        return new Matrix3x2f((Matrix3x2fc)DrawContextUtils.INSTANCE.getDrawContext().method_51448());
    }

    @NotNull
    public final class_287 getBuffer(@NotNull RenderPipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        class_287 class_2872 = class_289.method_1348().method_60827(pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
        Intrinsics.checkNotNullExpressionValue((Object)class_2872, (String)"begin(...)");
        return class_2872;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(@NotNull RenderPipeline pipeline, @NotNull class_9801 mesh, @NotNull Function1<? super RenderPass, Unit> pass) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)mesh, (String)"mesh");
        Intrinsics.checkNotNullParameter(pass, (String)"pass");
        GpuBuffer vertexBuffer = pipeline.getVertexFormat().uploadImmediateVertexBuffer(mesh.method_60818());
        RenderSystem.class_5590 sequentialBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)mesh.method_60822().comp_752());
        GpuBuffer indexBuffer = sequentialBuffer.method_68274(mesh.method_60822().comp_751());
        VertexFormat.class_5595 indexType = sequentialBuffer.method_31924();
        class_276 framebuffer = class_310.method_1551().method_1522();
        GpuDevice gpuDevice = RenderSystem.getDevice();
        Intrinsics.checkNotNullExpressionValue((Object)gpuDevice, (String)"getDevice(...)");
        Intrinsics.checkNotNull((Object)framebuffer);
        AutoCloseable autoCloseable = (AutoCloseable)RenderCompat.INSTANCE.createRenderPass(gpuDevice, "SkyHanni Immediate Pipeline Draw", framebuffer);
        Throwable throwable = null;
        try {
            RenderPass renderPass = (RenderPass)autoCloseable;
            boolean bl = false;
            pass.invoke((Object)renderPass);
            renderPass.setPipeline(pipeline);
            renderPass.setVertexBuffer(0, vertexBuffer);
            renderPass.setIndexBuffer(indexBuffer, indexType);
            RenderCompat.INSTANCE.drawIndexed(renderPass, mesh.method_60822().comp_751());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        mesh.close();
    }
}

