/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.repo;

import at.hannibal2.skyhanni.data.repo.ChatProgressUpdates;
import at.hannibal2.skyhanni.data.repo.RepoFileSystem;
import at.hannibal2.skyhanni.data.repo.RepoLogger;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lat/hannibal2/skyhanni/data/repo/DiskRepoFileSystem;", "Lat/hannibal2/skyhanni/data/repo/RepoFileSystem;", "Ljava/io/File;", "root", "<init>", "(Ljava/io/File;)V", "", "path", "", "exists", "(Ljava/lang/String;)Z", "", "readAllBytes", "(Ljava/lang/String;)[B", "data", "", "write", "(Ljava/lang/String;[B)V", "deleteRecursively", "(Ljava/lang/String;)V", "", "list", "(Ljava/lang/String;)Ljava/util/List;", "Ljava/io/File;", "getRoot", "()Ljava/io/File;", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nRepoFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoFileSystem.kt\nat/hannibal2/skyhanni/data/repo/DiskRepoFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n11546#2,9:177\n13472#2:186\n13473#2:188\n11555#2:189\n1#3:187\n*S KotlinDebug\n*F\n+ 1 RepoFileSystem.kt\nat/hannibal2/skyhanni/data/repo/DiskRepoFileSystem\n*L\n105#1:177,9\n105#1:186\n105#1:188\n105#1:189\n105#1:187\n*E\n"})
public final class DiskRepoFileSystem
implements RepoFileSystem {
    @NotNull
    private final File root;

    public DiskRepoFileSystem(@NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new File(this.root, path).isFile();
    }

    @Override
    @NotNull
    public byte[] readAllBytes(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilesKt.readBytes((File)new File(this.root, path));
    }

    @Override
    public void write(@NotNull String path, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        File f = new File(this.root, path);
        f.getParentFile().mkdirs();
        FilesKt.writeBytes((File)f, (byte[])data);
    }

    @Override
    public void deleteRecursively(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FilesKt.deleteRecursively((File)new File(this.root, path));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> list(@NotNull String path) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File[] fileArray = FilesKt.resolve((File)this.root, (String)path).listFiles(DiskRepoFileSystem::list$lambda$0);
        if (fileArray != null) {
            void $this$mapNotNullTo$iv$iv;
            File[] $this$mapNotNull$iv = fileArray;
            boolean $i$f$mapNotNull = false;
            File[] fileArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                String it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Object transitionAfterReload(@NotNull ChatProgressUpdates progress, @NotNull Continuation<? super RepoFileSystem> $completion) {
        return RepoFileSystem.DefaultImpls.transitionAfterReload(this, progress, $completion);
    }

    @Override
    public void deleteAll() {
        RepoFileSystem.DefaultImpls.deleteAll(this);
    }

    @Override
    @NotNull
    public JsonElement readAllBytesAsJsonElement(@NotNull String path, @NotNull Gson gson) {
        return RepoFileSystem.DefaultImpls.readAllBytesAsJsonElement(this, path, gson);
    }

    @Override
    public boolean loadFromZip(@NotNull ChatProgressUpdates progress, @NotNull File zipFile, @NotNull RepoLogger logger) {
        return RepoFileSystem.DefaultImpls.loadFromZip(this, progress, zipFile, logger);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean list$lambda$0(File file) {
        if (!file.exists()) return false;
        Intrinsics.checkNotNull((Object)file);
        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"json")) return false;
        return true;
    }
}

