/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.dungeon.DungeonConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonStartEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.features.dungeon.DungeonMilestonesDisplay;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u0017\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonDeathCounter;", "", "<init>", "()V", "", "message", "", "isDeathMessage", "(Ljava/lang/String;)Z", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "update", "Lat/hannibal2/skyhanni/events/dungeon/DungeonStartEvent;", "onDungeonStart", "(Lat/hannibal2/skyhanni/events/dungeon/DungeonStartEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/dungeon/DungeonConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/DungeonConfig;", "config", "display", "Ljava/lang/String;", "", "deaths", "I", "", "Ljava/util/regex/Pattern;", "deathPatternsList", "Ljava/util/List;", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nDungeonDeathCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonDeathCounter.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonDeathCounter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1761#2,3:104\n*S KotlinDebug\n*F\n+ 1 DungeonDeathCounter.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonDeathCounter\n*L\n52#1:104,3\n*E\n"})
public final class DungeonDeathCounter {
    @NotNull
    public static final DungeonDeathCounter INSTANCE = new DungeonDeathCounter();
    @NotNull
    private static String display = "";
    private static int deaths;
    @NotNull
    private static final List<Pattern> deathPatternsList;

    private DungeonDeathCounter() {
    }

    private final DungeonConfig getConfig() {
        return SkyHanniMod.feature.getDungeon();
    }

    private final boolean isDeathMessage(String message) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = deathPatternsList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pattern it = (Pattern)element$iv;
                    boolean bl2 = false;
                    if (!RegexUtils.INSTANCE.matches(it, message)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (this.isDeathMessage(event.getMessage())) {
            int n = deaths;
            deaths = n + 1;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7c\u00a7l" + deaths + ". DEATH!", false, null, false, false, null, 60, null);
            this.update();
        }
    }

    private final void update() {
        if (deaths == 0) {
            display = "";
            return;
        }
        String color = switch (deaths) {
            case 1, 2 -> "\u00a7e";
            case 3 -> "\u00a7c";
            default -> "\u00a74";
        };
        display = color + "Deaths: " + deaths;
    }

    @HandleEvent
    public final void onDungeonStart(@NotNull DungeonStartEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        deaths = 0;
        this.update();
    }

    @HandleEvent
    public final void onWorldChange() {
        deaths = 0;
        this.update();
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getDeathCounterPos(), DungeonMilestonesDisplay.INSTANCE.getColor() + display, 0, 0, "Dungeon Death Counter", 6, null);
    }

    private final boolean isEnabled() {
        return DungeonApi.INSTANCE.inDungeon() && this.getConfig().getDeathCounterDisplay();
    }

    static {
        Object[] objectArray = new Pattern[18];
        String string = "\u00a7c \u2620 \u00a7r\u00a77You were killed by (.*)\u00a7r\u00a77 and became a ghost\u00a7r\u00a77.";
        int n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77(.*) was killed by (.*) and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77You were crushed and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77\u00a7r(.*)\u00a7r\u00a77 was crushed and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77You died to a trap and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r(.*)\u00a7r\u00a77 died to a trap and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77You burnt to death and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r(.*)\u00a7r\u00a77 burnt to death and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77You died and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r(.*)\u00a7r\u00a77 died and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77You suffocated and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77\u00a7r(.*)\u00a7r\u00a77 suffocated and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77You died to a mob and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r(.*)\u00a77 died to a mob and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77You fell into a deep hole and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r(.*)\u00a7r\u00a77 fell into a deep hole and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a7(.*)\u00a7r\u00a77 disconnected from the Dungeon and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        string = "\u00a7c \u2620 \u00a7r\u00a77(.*)\u00a7r\u00a77 fell to their death with help from \u00a7r(.*)\u00a7r\u00a77 and became a ghost\u00a7r\u00a77.";
        n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(string, n), (String)"compile(...)");
        deathPatternsList = CollectionsKt.listOf((Object[])objectArray);
    }
}

