/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.visitor;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.visitor.RewardWarningConfig;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.visitor.VisitorApi;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u000e\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u001d\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ1\u0010#\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010(\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/features/garden/visitor/VisitorRewardWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$ForegroundDrawnEvent;", "event", "", "onForegroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$ForegroundDrawnEvent;)V", "Lnet/minecraft/class_1735;", "backgroundSlot", "outlineSlot", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "outlineColor", "renderColor", "(Lnet/minecraft/class_1735;Lnet/minecraft/class_1735;Lat/hannibal2/skyhanni/utils/LorenzColor;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "onTooltip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;)V", "", "", "copiedTooltip", "Lat/hannibal2/skyhanni/features/garden/visitor/VisitorApi$Visitor;", "visitor", "Lat/hannibal2/skyhanni/features/garden/visitor/VisitorApi$VisitorBlockReason;", "blockReason", "updateBlockedLore", "(Ljava/util/List;Lat/hannibal2/skyhanni/features/garden/visitor/VisitorApi$Visitor;Lat/hannibal2/skyhanni/features/garden/visitor/VisitorApi$VisitorBlockReason;)V", "pricePerCopper", "", "loss", "formattedLoss", "blockDescription", "(Lat/hannibal2/skyhanni/features/garden/visitor/VisitorApi$VisitorBlockReason;Ljava/lang/String;DLjava/lang/String;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/features/garden/visitor/RewardWarningConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/visitor/RewardWarningConfig;", "config", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nVisitorRewardWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisitorRewardWarning.kt\nat/hannibal2/skyhanni/features/garden/visitor/VisitorRewardWarning\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class VisitorRewardWarning {
    @NotNull
    public static final VisitorRewardWarning INSTANCE = new VisitorRewardWarning();

    private VisitorRewardWarning() {
    }

    private final RewardWarningConfig getConfig() {
        return VisitorApi.INSTANCE.getConfig().getRewardWarning();
    }

    @HandleEvent
    public final void onForegroundDrawn(@NotNull GuiContainerEvent.ForegroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!VisitorApi.INSTANCE.getInInventory()) {
            return;
        }
        VisitorApi.Visitor visitor = VisitorApi.INSTANCE.getVisitor(VisitorApi.INSTANCE.getLastClickedNpc());
        if (visitor == null) {
            return;
        }
        VisitorApi.Visitor visitor2 = visitor;
        class_1735 refuseOfferSlot = event.getContainer().method_7611(33);
        class_1735 acceptOfferSlot = event.getContainer().method_7611(29);
        VisitorApi.VisitorBlockReason visitorBlockReason = visitor2.getBlockReason();
        if (visitorBlockReason == null) {
            return;
        }
        VisitorApi.VisitorBlockReason blockReason = visitorBlockReason;
        if (blockReason.getBlockRefusing()) {
            this.renderColor(refuseOfferSlot, acceptOfferSlot, LorenzColor.GREEN);
        } else {
            this.renderColor(acceptOfferSlot, refuseOfferSlot, LorenzColor.RED);
        }
    }

    private final void renderColor(class_1735 backgroundSlot, class_1735 outlineSlot, LorenzColor outlineColor) {
        if (!KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().getBypassKey()) && backgroundSlot != null) {
            RenderUtils.INSTANCE.highlight(backgroundSlot, LorenzColor.DARK_GRAY.addOpacity(this.getConfig().getOpacity()));
        }
        if (this.getConfig().getOptionOutline() && outlineSlot != null) {
            RenderUtils.INSTANCE.drawBorder(outlineSlot, outlineColor.addOpacity(200));
        }
    }

    @HandleEvent(priority=-1)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        boolean shouldBlock;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!VisitorApi.INSTANCE.getInInventory()) {
            return;
        }
        class_1735 class_17352 = event.getSlot();
        if (class_17352 == null || (class_17352 = class_17352.method_7677()) == null) {
            return;
        }
        class_1735 stack = class_17352;
        VisitorApi.Visitor visitor = VisitorApi.INSTANCE.getVisitor(VisitorApi.INSTANCE.getLastClickedNpc());
        if (visitor == null) {
            return;
        }
        VisitorApi.Visitor visitor2 = visitor;
        VisitorApi.VisitorBlockReason blockReason = visitor2.getBlockReason();
        boolean isRefuseSlot = Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLeadingWhiteLessResets(stack.method_7964()), (Object)"\u00a7cRefuse Offer");
        boolean isAcceptSlot = Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLeadingWhiteLessResets(stack.method_7964()), (Object)"\u00a7aAccept Offer");
        VisitorApi.VisitorBlockReason visitorBlockReason = blockReason;
        if (visitorBlockReason != null) {
            VisitorApi.VisitorBlockReason $this$onSlotClick_u24lambda_u240 = visitorBlockReason;
            boolean bl = false;
            v3 = $this$onSlotClick_u24lambda_u240.getBlockRefusing() && isRefuseSlot || !$this$onSlotClick_u24lambda_u240.getBlockRefusing() && isAcceptSlot;
        } else {
            v3 = shouldBlock = false;
        }
        if (!KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().getBypassKey()) && shouldBlock) {
            event.cancel();
            return;
        }
        if (event.getClickType() == GuiContainerEvent.ClickType.SHIFT) {
            return;
        }
        if (isRefuseSlot) {
            VisitorApi.INSTANCE.changeStatus(visitor2, VisitorApi.VisitorStatus.REFUSED, "refused");
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Function0<Unit>)((Function0)() -> VisitorRewardWarning.onSlotClick$lambda$1(visitor2)));
            return;
        }
        if (isAcceptSlot && ItemUtils.INSTANCE.getLore((class_1799)stack).contains("\u00a7eClick to give!")) {
            VisitorApi.INSTANCE.changeStatus(visitor2, VisitorApi.VisitorStatus.ACCEPTED, "accepted");
            return;
        }
    }

    @HandleEvent(priority=-1)
    public final void onTooltip(@NotNull ToolTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!GardenApi.INSTANCE.getOnBarnPlot()) {
            return;
        }
        if (!VisitorApi.INSTANCE.getInInventory()) {
            return;
        }
        VisitorApi.Visitor visitor = VisitorApi.INSTANCE.getVisitor(VisitorApi.INSTANCE.getLastClickedNpc());
        if (visitor == null) {
            return;
        }
        VisitorApi.Visitor visitor2 = visitor;
        if (KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().getBypassKey())) {
            return;
        }
        boolean isRefuseSlot = Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLeadingWhiteLessResets(event.getItemStack().method_7964()), (Object)"\u00a7cRefuse Offer");
        boolean isAcceptSlot = Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLeadingWhiteLessResets(event.getItemStack().method_7964()), (Object)"\u00a7aAccept Offer");
        VisitorApi.VisitorBlockReason visitorBlockReason = visitor2.getBlockReason();
        if (visitorBlockReason == null) {
            return;
        }
        VisitorApi.VisitorBlockReason blockReason = visitorBlockReason;
        if (blockReason.getBlockRefusing() && !isRefuseSlot) {
            return;
        }
        if (!blockReason.getBlockRefusing() && !isAcceptSlot) {
            return;
        }
        if (visitor2.getBlockedLore().isEmpty()) {
            this.updateBlockedLore(CollectionsKt.toList((Iterable)event.getToolTip()), visitor2, blockReason);
        }
        event.getToolTip().clear();
        event.getToolTip().addAll((Collection<String>)visitor2.getBlockedLore());
    }

    private final void updateBlockedLore(List<String> copiedTooltip, VisitorApi.Visitor visitor, VisitorApi.VisitorBlockReason blockReason) {
        String string;
        List blockedToolTip = new ArrayList();
        for (String line : copiedTooltip) {
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)"\u00a7aAccept Offer\u00a7r", (boolean)false, (int)2, null)) {
                blockedToolTip.add(StringsKt.replace$default((String)line, (String)"\u00a7aAccept Offer\u00a7r", (String)"\u00a77Accept Offer\u00a78", (boolean)false, (int)4, null));
                continue;
            }
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)"\u00a7cRefuse Offer\u00a7r", (boolean)false, (int)2, null)) {
                blockedToolTip.add(StringsKt.replace$default((String)line, (String)"\u00a7cRefuse Offer\u00a7r", (String)"\u00a77Refuse Offer\u00a78", (boolean)false, (int)4, null));
                continue;
            }
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)"minecraft:", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"NBT:", (boolean)false, (int)2, null)) continue;
            blockedToolTip.add("\u00a78" + StringUtils.removeColor$default(StringUtils.INSTANCE, line, false, 1, null));
        }
        blockedToolTip.add("");
        Integer n = visitor.getPricePerCopper();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            string = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, it, false, 1, null);
        } else {
            string = null;
        }
        String pricePerCopper = string;
        Double d = visitor.getTotalPrice();
        Intrinsics.checkNotNull((Object)d);
        double d2 = d;
        Double d3 = visitor.getTotalReward();
        Intrinsics.checkNotNull((Object)d3);
        double loss = d2 - d3;
        String formattedLoss = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, Math.abs(loss), false, 1, null);
        blockedToolTip.add(this.blockDescription(blockReason, pricePerCopper, loss, formattedLoss));
        blockedToolTip.add("  \u00a77(Bypass by holding " + KeyboardManager.INSTANCE.getKeyName(this.getConfig().getBypassKey()) + ")");
        visitor.setBlockedLore(blockedToolTip);
    }

    private final String blockDescription(VisitorApi.VisitorBlockReason blockReason, String pricePerCopper, double loss, String formattedLoss) {
        String string = blockReason.getDescription();
        return string + (String)(switch (WhenMappings.$EnumSwitchMapping$0[blockReason.ordinal()]) {
            case 1, 2 -> " \u00a77(paying \u00a76" + pricePerCopper + " \u00a77per)";
            case 3, 4 -> " \u00a77(\u00a76" + formattedLoss + " \u00a77" + (loss > 0.0 ? "loss" : "profit") + " selling \u00a79Green Thumb I\u00a77)";
            default -> "";
        });
    }

    private static final Unit onSlotClick$lambda$1(VisitorApi.Visitor $visitor) {
        Intrinsics.checkNotNullParameter((Object)$visitor, (String)"$visitor");
        VisitorApi.INSTANCE.removeVisitor($visitor.getVisitorName());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VisitorApi.VisitorBlockReason.values().length];
            try {
                nArray[VisitorApi.VisitorBlockReason.CHEAP_COPPER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorApi.VisitorBlockReason.EXPENSIVE_COPPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorApi.VisitorBlockReason.LOW_LOSS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorApi.VisitorBlockReason.HIGH_LOSS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

