/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining.crystalhollows;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.mining.nucleus.MetalDetectorConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.MiningApi;
import at.hannibal2.skyhanni.data.jsonobjects.repo.MetalDetectorChestsJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.ActionBarUpdateEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.events.minecraft.WorldChangeEvent;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_2246;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u0017\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001b\u0010%\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u001b\u0010(\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\"\u001a\u0004\b'\u0010$R\u0014\u0010,\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u0019008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u0010/R\u0018\u00102\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0018\u00104\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00103R\u0016\u00106\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0018\u00108\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00103R\u0016\u00109\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010;\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u00107\u00a8\u0006<"}, d2={"Lat/hannibal2/skyhanni/features/mining/crystalhollows/MetalDetectorSolver;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/ActionBarUpdateEvent;", "onActionBarUpdate", "(Lat/hannibal2/skyhanni/events/ActionBarUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/WorldChangeEvent;", "onWorldSwap", "(Lat/hannibal2/skyhanni/events/minecraft/WorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;)V", "findBaseCoordinates", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "blockPosition", "getBaseCoordinates", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "isEnabled", "()Z", "Ljava/util/regex/Pattern;", "metalDetectorDistancePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getMetalDetectorDistancePattern", "()Ljava/util/regex/Pattern;", "metalDetectorDistancePattern", "treasureFoundPattern$delegate", "getTreasureFoundPattern", "treasureFoundPattern", "Lat/hannibal2/skyhanni/config/features/mining/nucleus/MetalDetectorConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/nucleus/MetalDetectorConfig;", "config", "", "chestLocations", "Ljava/util/List;", "", "predictedChestLocations", "baseCoordinates", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "ignoreLocation", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastSearchedForBase", "J", "lastLoc", "playedPling", "Z", "lastTreasureFound", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nMetalDetectorSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetalDetectorSolver.kt\nat/hannibal2/skyhanni/features/mining/crystalhollows/MetalDetectorSolver\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 5 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n13#2,7:234\n21#2,6:251\n167#3,5:241\n172#3,4:247\n24#4:246\n8#5:257\n1#6:258\n1#6:263\n1869#7,2:259\n1869#7,2:261\n*S KotlinDebug\n*F\n+ 1 MetalDetectorSolver.kt\nat/hannibal2/skyhanni/features/mining/crystalhollows/MetalDetectorSolver\n*L\n72#1:234,7\n72#1:251,6\n72#1:241,5\n72#1:247,4\n72#1:246\n86#1:257\n86#1:258\n93#1:259,2\n158#1:261,2\n*E\n"})
public final class MetalDetectorSolver {
    @NotNull
    public static final MetalDetectorSolver INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern metalDetectorDistancePattern$delegate;
    @NotNull
    private static final RepoPattern treasureFoundPattern$delegate;
    @NotNull
    private static List<LorenzVec> chestLocations;
    @NotNull
    private static final List<LorenzVec> predictedChestLocations;
    @Nullable
    private static LorenzVec baseCoordinates;
    @Nullable
    private static LorenzVec ignoreLocation;
    private static long lastSearchedForBase;
    @Nullable
    private static LorenzVec lastLoc;
    private static boolean playedPling;
    private static long lastTreasureFound;

    private MetalDetectorSolver() {
    }

    private final Pattern getMetalDetectorDistancePattern() {
        return (Pattern)metalDetectorDistancePattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getTreasureFoundPattern() {
        return (Pattern)treasureFoundPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final MetalDetectorConfig getConfig() {
        return SkyHanniMod.feature.getMining().getMetalDetector();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String constant$iv = "MetalDetectorChests";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(MetalDetectorChestsJson.class)));
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        chestLocations = ((MetalDetectorChestsJson)object).getLocations();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.CRYSTAL_HOLLOWS)
    public final void onActionBarUpdate(@NotNull ActionBarUpdateEvent event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (predictedChestLocations.size() == 1) {
            return;
        }
        LorenzVec player = LocationUtils.INSTANCE.playerLocation();
        if (!Intrinsics.areEqual((Object)lastLoc, (Object)player)) {
            lastLoc = player;
            playedPling = false;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getMetalDetectorDistancePattern();
        String text$iv = event.getActionBar();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onActionBarUpdate_u24lambda_u241 = it$iv;
            boolean bl2 = false;
            String string = $this$onActionBarUpdate_u24lambda_u241.group("distance");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            Double d = StringsKt.toDoubleOrNull((String)string);
            if (d == null) {
                return;
            }
            double distance = d;
            if (baseCoordinates == null) {
                INSTANCE.findBaseCoordinates();
            }
            LorenzVec lorenzVec = baseCoordinates;
            if (lorenzVec == null) {
                return;
            }
            LorenzVec baseCoordinatesNonNull = lorenzVec;
            predictedChestLocations.clear();
            Iterable $this$forEach$iv = chestLocations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LorenzVec it = (LorenzVec)element$iv;
                boolean bl3 = false;
                LorenzVec loc = baseCoordinatesNonNull.plus(it.negated());
                if (Intrinsics.areEqual((Object)loc, (Object)ignoreLocation)) {
                    ignoreLocation = null;
                    return;
                }
                if (!(NumberUtil.INSTANCE.roundTo(LocationUtils.INSTANCE.distanceToPlayer(loc.add(0, 1, 0)), 1) == distance)) continue;
                if (predictedChestLocations.size() == 0 && !playedPling) {
                    SoundUtils.INSTANCE.playSound(SoundUtils.INSTANCE.getPlingSound());
                    playedPling = true;
                }
                predictedChestLocations.add(loc);
            }
            if (predictedChestLocations.size() == 1) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Found a treasure chest location", false, null, true, false, null, 54, null);
                return;
            }
            if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastTreasureFound), (long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS)) < 0) {
                return;
            }
            if (predictedChestLocations.size() == 0) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "No chests found. Try standing still with the metal detector in a different spot.", false, null, true, false, null, 54, null);
            } else if (predictedChestLocations.size() > 1) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, predictedChestLocations.size() + " possible locations found. Please try standing still with the metal detector in a different spot.", false, null, true, false, null, 54, null);
            }
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.CRYSTAL_HOLLOWS)
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(this.getTreasureFoundPattern(), event.getMessage())) {
            return;
        }
        playedPling = false;
        predictedChestLocations.clear();
        long timeTaken = SimpleTimeMark.passedSince-UwyO8pc(lastTreasureFound);
        if (this.getConfig().getShowTimeTaken() && !SimpleTimeMark.isFarPast-impl(lastTreasureFound)) {
            DelayedRun.INSTANCE.runNextTick((Function0<Unit>)((Function0)() -> MetalDetectorSolver.onChat$lambda$2(timeTaken)));
        }
        lastTreasureFound = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent(onlyOnIsland=IslandType.CRYSTAL_HOLLOWS)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = predictedChestLocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LorenzVec it = (LorenzVec)element$iv;
            boolean bl = false;
            WorldRenderUtils.drawColor$default(WorldRenderUtils.INSTANCE, event, it, LorenzColor.toChromaColor$default(LorenzColor.GOLD, 0, 0, 3, null), false, 0.0f, false, 28, null);
            WorldRenderUtils.INSTANCE.drawLineToEye(event, it.add(0.5, 0.5, 0.5), LorenzColor.toChromaColor$default(LorenzColor.WHITE, 0, 0, 3, null), 3, false);
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, it, LorenzColor.RED.toColor(), true, true, 0.0, 0.0, 0.0, 0.0f, false, 496, null);
            WorldRenderUtils.drawString$default(WorldRenderUtils.INSTANCE, event, it, "Treasure: \u00a7e" + NumberUtil.INSTANCE.roundTo(LocationUtils.INSTANCE.distanceToPlayer(it), 1) + "m", true, null, 0.0, false, 0.0f, 0, 248, null);
        }
    }

    @HandleEvent
    public final void onWorldSwap(@NotNull WorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        baseCoordinates = null;
        lastSearchedForBase = SimpleTimeMark.Companion.farPast();
        predictedChestLocations.clear();
        ignoreLocation = null;
        lastLoc = null;
        playedPling = false;
        lastTreasureFound = SimpleTimeMark.Companion.farPast();
    }

    @HandleEvent(onlyOnIsland=IslandType.CRYSTAL_HOLLOWS)
    public final void onTick(@NotNull SkyHanniTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (predictedChestLocations.size() == 1) {
            double distanceSq = LocationUtils.INSTANCE.distanceSqToPlayer(predictedChestLocations.get(0));
            if (distanceSq <= 25.0) {
                ignoreLocation = predictedChestLocations.get(0);
                predictedChestLocations.clear();
            }
        } else if (predictedChestLocations.isEmpty()) {
            boolean bl;
            LorenzVec lorenzVec = ignoreLocation;
            if (lorenzVec != null) {
                LorenzVec it = lorenzVec;
                boolean bl2 = false;
                bl = LocationUtils.INSTANCE.distanceSqToPlayer(it) > 100.0;
            } else {
                bl = false;
            }
            if (bl) {
                ignoreLocation = null;
            }
        }
    }

    private final void findBaseCoordinates() {
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastSearchedForBase), (long)DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            return;
        }
        lastSearchedForBase = SimpleTimeMark.Companion.now-uFjCsEo();
        LorenzVec player = LocationUtils.INSTANCE.playerLocation().roundToBlock();
        for (int i2 = -50; i2 < 50; ++i2) {
            for (int j = 30; -31 < j; --j) {
                for (int k = -50; k < 50; ++k) {
                    LorenzVec blockPosition = player.add(i2, j, k).roundToBlock();
                    LorenzVec nextBlockPosition = blockPosition.add(0, 13, 0);
                    if (!Intrinsics.areEqual((Object)BlockUtils.INSTANCE.getBlockAt(blockPosition), (Object)class_2246.field_10451) || !Intrinsics.areEqual((Object)BlockUtils.INSTANCE.getBlockAt(nextBlockPosition), (Object)class_2246.field_10499)) continue;
                    baseCoordinates = this.getBaseCoordinates(nextBlockPosition);
                    return;
                }
            }
        }
    }

    private final LorenzVec getBaseCoordinates(LorenzVec blockPosition) {
        boolean changed = true;
        LorenzVec currentPosition = blockPosition;
        while (changed) {
            changed = false;
            if (Intrinsics.areEqual((Object)BlockUtils.INSTANCE.getBlockAt(currentPosition.add(1, 0, 0)), (Object)class_2246.field_10499)) {
                changed = true;
                currentPosition = currentPosition.add(1, 0, 0);
            }
            if (Intrinsics.areEqual((Object)BlockUtils.INSTANCE.getBlockAt(currentPosition.add(0, 1, 0)), (Object)class_2246.field_10499)) {
                changed = true;
                currentPosition = currentPosition.add(0, 1, 0);
            }
            if (!Intrinsics.areEqual((Object)BlockUtils.INSTANCE.getBlockAt(currentPosition.add(0, 0, 1)), (Object)class_2246.field_10499)) continue;
            changed = true;
            currentPosition = currentPosition.add(0, 0, 1);
        }
        return currentPosition;
    }

    public final boolean isEnabled() {
        return MiningApi.INSTANCE.inMinesOfDivan() && this.getConfig().getMetalDetectorSolver();
    }

    private static final Unit onChat$lambda$2(long $timeTaken) {
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aYou found the treasure in \u00a7e" + Duration.getInWholeSeconds-impl((long)$timeTaken) + "\u00a7a seconds.", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MetalDetectorSolver.class, "metalDetectorDistancePattern", "getMetalDetectorDistancePattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MetalDetectorSolver.class, "treasureFoundPattern", "getTreasureFoundPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new MetalDetectorSolver();
        metalDetectorDistancePattern$delegate = RepoPattern.Companion.pattern("mining.crystalnucleus.metaldetector.treasure", ".*\u00a73\u00a7lTREASURE: \u00a7b(?<distance>.*)m");
        treasureFoundPattern$delegate = RepoPattern.Companion.pattern("mining.crystalnucleus.metaldetector.treasurefound", "\u00a7aYou found .*with your \u00a7r\u00a7cMetal Detector\u00a7r\u00a7a!");
        chestLocations = CollectionsKt.emptyList();
        predictedChestLocations = new ArrayList();
        lastSearchedForBase = SimpleTimeMark.Companion.farPast();
        lastTreasureFound = SimpleTimeMark.Companion.farPast();
    }
}

