/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.pathfind;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.model.Graph;
import at.hannibal2.skyhanni.data.model.GraphNode;
import at.hannibal2.skyhanni.data.model.GraphNodeTag;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.GraphUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.chat.TextHelper;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ%\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ5\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00150\u00142\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u00148\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/features/misc/pathfind/NavigationHelper;", "", "<init>", "()V", "", "", "args", "", "onCommand", "([Ljava/lang/String;)V", "doCommandAsync", "name", "Lkotlin/Function0;", "goBack", "sendNavigateMessage", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "", "Lat/hannibal2/skyhanni/data/model/GraphNode;", "", "distances", "", "Lkotlin/Pair;", "calculateNames", "(Ljava/util/Map;)Ljava/util/List;", "searchTerm", "calculateDistances", "(Ljava/lang/String;)Ljava/util/Map;", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "messageId", "I", "Lat/hannibal2/skyhanni/data/model/GraphNodeTag;", "allowedTags", "Ljava/util/List;", "getAllowedTags", "()Ljava/util/List;", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nNavigationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationHelper.kt\nat/hannibal2/skyhanni/features/misc/pathfind/NavigationHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,139:1\n11228#2:140\n11563#2,3:141\n230#3,2:144\n774#3:146\n865#3,2:147\n1563#3:149\n1634#3,3:150\n230#3,2:157\n37#4:153\n36#4,3:154\n*S KotlinDebug\n*F\n+ 1 NavigationHelper.kt\nat/hannibal2/skyhanni/features/misc/pathfind/NavigationHelper\n*L\n43#1:140\n43#1:141,3\n102#1:144,2\n119#1:146\n119#1:147,2\n125#1:149\n125#1:150,3\n81#1:157,2\n64#1:153\n64#1:154,3\n*E\n"})
public final class NavigationHelper {
    @NotNull
    public static final NavigationHelper INSTANCE = new NavigationHelper();
    private static final int messageId = ChatUtils.INSTANCE.getUniqueMessageId();
    @NotNull
    private static final List<GraphNodeTag> allowedTags;

    private NavigationHelper() {
    }

    @NotNull
    public final List<GraphNodeTag> getAllowedTags() {
        return allowedTags;
    }

    /*
     * WARNING - void declaration
     */
    private final void onCommand(String[] args) {
        if (args.length == 3) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String[] stringArray = args;
            CollectionUtils collectionUtils = CollectionUtils.INSTANCE;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var11_14 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.toDoubleOrNull((String)it));
            }
            List<Double> list = collectionUtils.takeIfAllNotNull((List)destination$iv$iv);
            if (list != null) {
                List<Double> it = list;
                boolean bl = false;
                LorenzVec location = LorenzVec.Companion.toLorenzVec(it);
                IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, location.add(-1, -1, -1), "Custom Goal", null, null, null, NavigationHelper::onCommand$lambda$3$lambda$1, 28, null);
                LorenzVec $this$onCommand_u24lambda_u243_u24lambda_u242 = location;
                boolean bl2 = false;
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Started Navigating to custom goal at \u00a7f" + $this$onCommand_u24lambda_u243_u24lambda_u242.getX() + " " + $this$onCommand_u24lambda_u243_u24lambda_u242.getY() + " " + $this$onCommand_u24lambda_u243_u24lambda_u242.getZ(), false, null, false, false, messageId, 30, null);
                return;
            }
        }
        SkyHanniMod.launchCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "shnavigate command", 0L, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(args, null){
            int label;
            final /* synthetic */ String[] $args;
            {
                this.$args = $args;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        NavigationHelper.access$doCommandAsync(NavigationHelper.INSTANCE, this.$args);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void doCommandAsync(String[] args) {
        String string = ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String searchTerm = string;
        Map<GraphNode, Double> distances = this.calculateDistances(searchTerm);
        List<Pair<String, GraphNode>> locations = this.calculateNames(distances);
        Function0 goBack = () -> NavigationHelper.doCommandAsync$lambda$4(searchTerm);
        Object title = StringsKt.isBlank((CharSequence)searchTerm) ? "SkyHanni Navigation Locations" : "SkyHanni Navigation Locations Matching: \"" + searchTerm + "\"";
        TextHelper.displayPaginatedList$default(TextHelper.INSTANCE, (String)title, locations, messageId, "No locations found.", 0, 0, null, arg_0 -> NavigationHelper.doCommandAsync$lambda$8(distances, goBack, arg_0), 112, null);
    }

    private final void sendNavigateMessage(String name2, Function0<Unit> goBack) {
        class_5250 componentText = TextHelper.asComponent$default(TextHelper.INSTANCE, "\u00a77Navigating to \u00a7r" + name2, null, 1, null);
        TextHelper.onClick-O__7yG8$default(TextHelper.INSTANCE, (class_2561)componentText, 0L, false, goBack, 3, null);
        TextCompatKt.setHover((class_2561)componentText, (class_2561)TextHelper.asComponent$default(TextHelper.INSTANCE, "\u00a7eClick to stop navigating and return to previous search", null, 1, null));
        TextHelper.INSTANCE.send((class_2561)componentText, messageId);
    }

    private final List<Pair<String, GraphNode>> calculateNames(Map<GraphNode, Double> distances) {
        Map names = new LinkedHashMap();
        for (GraphNode node : CollectionUtils.INSTANCE.sorted(distances).keySet()) {
            Object element$iv2;
            block2: {
                if (Intrinsics.areEqual((Object)node.getName(), (Object)"no_area") || Intrinsics.areEqual((Object)node.getName(), (Object)SkyBlockUtils.INSTANCE.getGraphArea())) continue;
                Iterable $this$first$iv = node.getTags();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    GraphNodeTag it = (GraphNodeTag)((Object)element$iv2);
                    boolean bl = false;
                    if (!allowedTags.contains((Object)it)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            GraphNodeTag tag = (GraphNodeTag)((Object)element$iv2);
            String name2 = node.getName() + " \u00a77(" + tag.getDisplayName() + "\u00a77)";
            if (names.containsKey(name2)) continue;
            names.put(name2, node);
        }
        return MapsKt.toList((Map)names);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GraphNode, Double> calculateDistances(String searchTerm) {
        List<? extends GraphNode> list = IslandGraphs.INSTANCE.getCurrentIslandGraph-ZhRhRFc();
        if (list == null) {
            return MapsKt.emptyMap();
        }
        List<? extends GraphNode> graph = list;
        GraphNode graphNode = IslandGraphs.INSTANCE.getClosestNode();
        if (graphNode == null) {
            return MapsKt.emptyMap();
        }
        GraphNode closestNode = graphNode;
        Map distances = new LinkedHashMap();
        Iterator<GraphNode> iterator2 = Graph.iterator-impl(graph);
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String name2;
            GraphNodeTag it;
            void $this$filterTo$iv$iv;
            GraphNode node = iterator2.next();
            if (node.getName() == null) continue;
            Iterable $this$filter$iv = node.getTags();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GraphNodeTag)((Object)element$iv$iv);
                boolean bl = false;
                if (!allowedTags.contains((Object)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List remainingTags = (List)destination$iv$iv;
            if (remainingTags.isEmpty()) continue;
            String string = name2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)searchTerm, (boolean)false, (int)2, null)) {
                distances.put(node, GraphUtils.INSTANCE.findShortestDistance(closestNode, node));
            }
            if (remainingTags.size() == 1) continue;
            $this$filter$iv = remainingTags;
            String string2 = node.getName();
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (GraphNodeTag)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getCleanName());
            }
            String string3 = "found node with invalid amount of tags: " + string2 + " (" + (List)destination$iv$iv;
            System.out.println((Object)string3);
        }
        return distances;
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.registerBrigadier("shnavigate", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)NavigationHelper::onCommandRegistration$lambda$13));
    }

    private static final boolean onCommand$lambda$3$lambda$1() {
        return true;
    }

    private static final Unit doCommandAsync$lambda$4(String $searchTerm) {
        Intrinsics.checkNotNullParameter((Object)$searchTerm, (String)"$searchTerm");
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)$searchTerm, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        INSTANCE.onCommand(thisCollection$iv.toArray(new String[0]));
        IslandGraphs.INSTANCE.stop();
        return Unit.INSTANCE;
    }

    private static final boolean doCommandAsync$lambda$8$lambda$6$lambda$5() {
        return true;
    }

    private static final Unit doCommandAsync$lambda$8$lambda$6(GraphNode $node, String $name, Function0 $goBack) {
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$goBack, (String)"$goBack");
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, $node, $name, null, null, true, null, NavigationHelper::doCommandAsync$lambda$8$lambda$6$lambda$5, 22, null);
        INSTANCE.sendNavigateMessage($name, (Function0<Unit>)$goBack);
        return Unit.INSTANCE;
    }

    private static final class_2561 doCommandAsync$lambda$8(Map $distances, Function0 $goBack, Pair pair) {
        Object element$iv2;
        class_5250 component;
        double distance;
        String name2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$distances, (String)"$distances");
            Intrinsics.checkNotNullParameter((Object)$goBack, (String)"$goBack");
            Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
            name2 = (String)pair.component1();
            GraphNode node = (GraphNode)pair.component2();
            Object v = $distances.get(node);
            Intrinsics.checkNotNull(v);
            distance = NumberUtil.INSTANCE.roundTo(((Number)v).doubleValue(), 1);
            component = TextHelper.asComponent$default(TextHelper.INSTANCE, name2 + " \u00a7e" + distance, null, 1, null);
            TextHelper.onClick-O__7yG8$default(TextHelper.INSTANCE, (class_2561)component, 0L, false, () -> NavigationHelper.doCommandAsync$lambda$8$lambda$6(node, name2, $goBack), 3, null);
            Iterable $this$first$iv = node.getTags();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                GraphNodeTag it = (GraphNodeTag)((Object)element$iv2);
                boolean bl = false;
                if (!allowedTags.contains((Object)it)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        GraphNodeTag tag = (GraphNodeTag)((Object)element$iv2);
        String hoverText = "Name: " + name2 + "\n\u00a77Type: \u00a7r" + tag.getDisplayName() + "\n\u00a77Distance: \u00a7e" + distance + " blocks\n\u00a7eClick to start navigating!";
        TextCompatKt.setHover((class_2561)component, (class_2561)TextHelper.asComponent$default(TextHelper.INSTANCE, hoverText, null, 1, null));
        return (class_2561)component;
    }

    private static final Unit onCommandRegistration$lambda$13$lambda$12(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.onCommand(it);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$13(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Using path finder to go to locations");
        $this$registerBrigadier.legacyCallbackArgs((Function1<String[], Unit>)((Function1)NavigationHelper::onCommandRegistration$lambda$13$lambda$12));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$doCommandAsync(NavigationHelper $this, String[] args) {
        $this.doCommandAsync(args);
    }

    static {
        GraphNodeTag[] graphNodeTagArray = new GraphNodeTag[]{GraphNodeTag.NPC, GraphNodeTag.AREA, GraphNodeTag.SMALL_AREA, GraphNodeTag.POI, GraphNodeTag.SLAYER, GraphNodeTag.GRIND_MOBS, GraphNodeTag.GRIND_ORES, GraphNodeTag.GRIND_CROPS, GraphNodeTag.MINES_EMISSARY, GraphNodeTag.CRIMSON_MINIBOSS};
        allowedTags = CollectionsKt.listOf((Object[])graphNodeTagArray);
    }
}

