/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.hoppity;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.event.hoppity.HoppityEggsConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.EntityMovementData;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityApi;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggsManager;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.CFApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockTime;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KProperty0;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0003R\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R$\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityNpc;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "onInventoryUpdated", "(Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "", "isHighlightEnabled", "()Z", "isReminderEnabled", "clear", "Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityEggsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityEggsConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastReminderSent", "J", "", "value", "getHoppityYearOpened", "()I", "setHoppityYearOpened", "(I)V", "hoppityYearOpened", "", "slotsToHighlight", "Ljava/util/Set;", "inShop", "Z", "1.21.10"})
public final class HoppityNpc {
    @NotNull
    public static final HoppityNpc INSTANCE = new HoppityNpc();
    private static long lastReminderSent = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final Set<Integer> slotsToHighlight = new LinkedHashSet();
    private static boolean inShop;

    private HoppityNpc() {
    }

    private final HoppityEggsConfig getConfig() {
        return HoppityEggsManager.INSTANCE.getConfig();
    }

    private final int getHoppityYearOpened() {
        Object object = CFApi.INSTANCE.getProfileStorage();
        return object != null && (object = ((ProfileSpecificStorage.CFStorage)object).getHoppityShopYearOpened()) != null ? (Integer)object : -1;
    }

    private final void setHoppityYearOpened(int value) {
        block0: {
            ProfileSpecificStorage.CFStorage cFStorage = CFApi.INSTANCE.getProfileStorage();
            if (cFStorage == null) break block0;
            cFStorage.setHoppityShopYearOpened(value);
        }
    }

    @HandleEvent
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getInventoryName(), (Object)"Hoppity")) {
            return;
        }
        this.setHoppityYearOpened(SkyBlockTime.Companion.now().getYear());
        inShop = true;
    }

    @HandleEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isReminderEnabled()) {
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        if (SkyBlockUtils.INSTANCE.isStrandedProfile()) {
            return;
        }
        if (this.getHoppityYearOpened() == SkyBlockTime.Companion.now().getYear()) {
            return;
        }
        if (!HoppityApi.INSTANCE.isHoppityEvent()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastReminderSent), (long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES)) <= 0) {
            return;
        }
        ChatUtils.clickToActionOrDisable$default(ChatUtils.INSTANCE, "New rabbits are available at \u00a7aHoppity's Shop\u00a7e!", (KProperty0)new MutablePropertyReference0Impl(this.getConfig()){

            public Object get() {
                return ((HoppityEggsConfig)this.receiver).getHoppityShopReminder();
            }

            public void set(Object value) {
                ((HoppityEggsConfig)this.receiver).setHoppityShopReminder((Boolean)value);
            }
        }, "warp to hub", HoppityNpc::onSecondPassed$lambda$2, false, 16, null);
        lastReminderSent = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.clear();
    }

    @HandleEvent
    public final void onWorldChange() {
        this.clear();
    }

    @HandleEvent
    public final void onInventoryUpdated(@NotNull InventoryUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!inShop) {
            return;
        }
        slotsToHighlight.clear();
        for (Map.Entry<Integer, class_1799> entry : event.getInventoryItems().entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            class_1799 item2 = entry.getValue();
            if (!ItemUtils.INSTANCE.getLore(item2).contains("\u00a7eClick to trade!")) continue;
            slotsToHighlight.add(slot);
        }
    }

    @HandleEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isHighlightEnabled()) {
            return;
        }
        if (!inShop) {
            return;
        }
        for (class_1735 slot : InventoryUtils.INSTANCE.getItemsInOpenChest()) {
            if (!slotsToHighlight.contains(slot.method_34266())) continue;
            RenderUtils.INSTANCE.highlight(slot, LorenzColor.GREEN.addOpacity(200));
        }
    }

    private final boolean isHighlightEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getHighlightHoppityShop();
    }

    private final boolean isReminderEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getHoppityShopReminder();
    }

    private final void clear() {
        inShop = false;
        slotsToHighlight.clear();
    }

    private static final boolean onSecondPassed$lambda$2$lambda$1$lambda$0() {
        return INSTANCE.getConfig().getHoppityShopReminder();
    }

    private static final Unit onSecondPassed$lambda$2$lambda$1() {
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, new LorenzVec(6.4, 70.0, 7.4), "\u00a7aHoppity's Shop", null, null, null, HoppityNpc::onSecondPassed$lambda$2$lambda$1$lambda$0, 28, null);
        return Unit.INSTANCE;
    }

    private static final Unit onSecondPassed$lambda$2() {
        HypixelCommands.INSTANCE.warp("hub");
        EntityMovementData.INSTANCE.onNextTeleport(IslandType.HUB, (Function0<Unit>)((Function0)HoppityNpc::onSecondPassed$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }
}

