/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.api.enoughupdates.EnoughUpdatesManager;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.PrimitiveIngredient;
import at.hannibal2.skyhanni.utils.RecipeType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\rJD\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b \u0010\u000fR\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b!\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010\u0012R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010$\u001a\u0004\b%\u0010\rR\u001d\u0010*\u001a\u0004\u0018\u00010\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lat/hannibal2/skyhanni/utils/PrimitiveRecipe;", "", "", "Lat/hannibal2/skyhanni/utils/PrimitiveIngredient;", "ingredients", "outputs", "Lat/hannibal2/skyhanni/utils/RecipeType;", "recipeType", "", "shouldUseForCraftCost", "<init>", "(Ljava/util/Set;Ljava/util/Set;Lat/hannibal2/skyhanni/utils/RecipeType;Z)V", "isCraftingRecipe", "()Z", "component1", "()Ljava/util/Set;", "component2", "component3", "()Lat/hannibal2/skyhanni/utils/RecipeType;", "component4", "copy", "(Ljava/util/Set;Ljava/util/Set;Lat/hannibal2/skyhanni/utils/RecipeType;Z)Lat/hannibal2/skyhanni/utils/PrimitiveRecipe;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/Set;", "getIngredients", "getOutputs", "Lat/hannibal2/skyhanni/utils/RecipeType;", "getRecipeType", "Z", "getShouldUseForCraftCost", "output$delegate", "Lkotlin/Lazy;", "getOutput", "()Lat/hannibal2/skyhanni/utils/PrimitiveIngredient;", "output", "Companion", "1.21.10"})
public final class PrimitiveRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<PrimitiveIngredient> ingredients;
    @NotNull
    private final Set<PrimitiveIngredient> outputs;
    @NotNull
    private final RecipeType recipeType;
    private final boolean shouldUseForCraftCost;
    @NotNull
    private final Lazy output$delegate;

    public PrimitiveRecipe(@NotNull Set<PrimitiveIngredient> ingredients, @NotNull Set<PrimitiveIngredient> outputs, @NotNull RecipeType recipeType, boolean shouldUseForCraftCost) {
        Intrinsics.checkNotNullParameter(ingredients, (String)"ingredients");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        Intrinsics.checkNotNullParameter((Object)((Object)recipeType), (String)"recipeType");
        this.ingredients = ingredients;
        this.outputs = outputs;
        this.recipeType = recipeType;
        this.shouldUseForCraftCost = shouldUseForCraftCost;
        this.output$delegate = LazyKt.lazy(() -> PrimitiveRecipe.output_delegate$lambda$0(this));
    }

    public /* synthetic */ PrimitiveRecipe(Set set, Set set2, RecipeType recipeType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(set, set2, recipeType, bl);
    }

    @NotNull
    public final Set<PrimitiveIngredient> getIngredients() {
        return this.ingredients;
    }

    @NotNull
    public final Set<PrimitiveIngredient> getOutputs() {
        return this.outputs;
    }

    @NotNull
    public final RecipeType getRecipeType() {
        return this.recipeType;
    }

    public final boolean getShouldUseForCraftCost() {
        return this.shouldUseForCraftCost;
    }

    @Nullable
    public final PrimitiveIngredient getOutput() {
        Lazy lazy = this.output$delegate;
        return (PrimitiveIngredient)lazy.getValue();
    }

    public final boolean isCraftingRecipe() {
        return this.recipeType == RecipeType.CRAFTING;
    }

    @NotNull
    public final Set<PrimitiveIngredient> component1() {
        return this.ingredients;
    }

    @NotNull
    public final Set<PrimitiveIngredient> component2() {
        return this.outputs;
    }

    @NotNull
    public final RecipeType component3() {
        return this.recipeType;
    }

    public final boolean component4() {
        return this.shouldUseForCraftCost;
    }

    @NotNull
    public final PrimitiveRecipe copy(@NotNull Set<PrimitiveIngredient> ingredients, @NotNull Set<PrimitiveIngredient> outputs, @NotNull RecipeType recipeType, boolean shouldUseForCraftCost) {
        Intrinsics.checkNotNullParameter(ingredients, (String)"ingredients");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        Intrinsics.checkNotNullParameter((Object)((Object)recipeType), (String)"recipeType");
        return new PrimitiveRecipe(ingredients, outputs, recipeType, shouldUseForCraftCost);
    }

    public static /* synthetic */ PrimitiveRecipe copy$default(PrimitiveRecipe primitiveRecipe, Set set, Set set2, RecipeType recipeType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = primitiveRecipe.ingredients;
        }
        if ((n & 2) != 0) {
            set2 = primitiveRecipe.outputs;
        }
        if ((n & 4) != 0) {
            recipeType = primitiveRecipe.recipeType;
        }
        if ((n & 8) != 0) {
            bl = primitiveRecipe.shouldUseForCraftCost;
        }
        return primitiveRecipe.copy(set, set2, recipeType, bl);
    }

    @NotNull
    public String toString() {
        return "PrimitiveRecipe(ingredients=" + this.ingredients + ", outputs=" + this.outputs + ", recipeType=" + this.recipeType + ", shouldUseForCraftCost=" + this.shouldUseForCraftCost + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.ingredients).hashCode();
        result2 = result2 * 31 + ((Object)this.outputs).hashCode();
        result2 = result2 * 31 + this.recipeType.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.shouldUseForCraftCost);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrimitiveRecipe)) {
            return false;
        }
        PrimitiveRecipe primitiveRecipe = (PrimitiveRecipe)other;
        if (!Intrinsics.areEqual(this.ingredients, primitiveRecipe.ingredients)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.outputs, primitiveRecipe.outputs)) {
            return false;
        }
        if (this.recipeType != primitiveRecipe.recipeType) {
            return false;
        }
        return this.shouldUseForCraftCost == primitiveRecipe.shouldUseForCraftCost;
    }

    private static final PrimitiveIngredient output_delegate$lambda$0(PrimitiveRecipe this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (PrimitiveIngredient)CollectionsKt.firstOrNull((Iterable)this$0.outputs);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ5\u0010\u000f\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lat/hannibal2/skyhanni/utils/PrimitiveRecipe$Companion;", "", "<init>", "()V", "Lcom/google/gson/JsonObject;", "recipeJson", "itemJson", "", "loadRecipeFromJson", "(Lcom/google/gson/JsonObject;Lcom/google/gson/JsonObject;)V", "", "Lat/hannibal2/skyhanni/utils/PrimitiveIngredient;", "ingredients", "Lat/hannibal2/skyhanni/utils/RecipeType;", "recipeType", "submitRecipe", "(Ljava/util/Set;Lcom/google/gson/JsonObject;Lcom/google/gson/JsonObject;Lat/hannibal2/skyhanni/utils/RecipeType;)V", "1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void loadRecipeFromJson(@NotNull JsonObject recipeJson, @NotNull JsonObject itemJson) {
            String type2;
            Intrinsics.checkNotNullParameter((Object)recipeJson, (String)"recipeJson");
            Intrinsics.checkNotNullParameter((Object)itemJson, (String)"itemJson");
            JsonElement jsonElement = recipeJson.get("type");
            String string = type2 = jsonElement != null ? jsonElement.getAsString() : null;
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case 95858532: {
                        if (!string.equals("drops")) break;
                        n = 1;
                        break;
                    }
                    case 110621028: {
                        if (!string.equals("trade")) break;
                        n = 2;
                        break;
                    }
                    case 1110252729: {
                        if (!string.equals("katgrade")) break;
                        n = 3;
                        break;
                    }
                    case 97618791: {
                        if (!string.equals("forge")) break;
                        n = 4;
                        break;
                    }
                    case 1977322900: {
                        if (!string.equals("npc_shop")) break;
                        n = 5;
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        Set ingredients = new LinkedHashSet();
                        Iterator iterator2 = recipeJson.get("inputs").getAsJsonArray().iterator();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
                        Iterator iterator3 = iterator2;
                        while (true) {
                            if (!iterator3.hasNext()) {
                                this.submitRecipe(ingredients, recipeJson, itemJson, RecipeType.FORGE);
                                return;
                            }
                            JsonElement ingredient = (JsonElement)iterator3.next();
                            String string2 = ingredient.getAsString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
                            ingredients.add(new PrimitiveIngredient(string2));
                        }
                    }
                    case 2: {
                        String string3 = recipeJson.get("result").getAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAsString(...)");
                        Set output = SetsKt.setOf((Object)new PrimitiveIngredient(string3));
                        if (recipeJson.has("max")) {
                            int minAmount = recipeJson.get("min").getAsInt();
                            int maxAmount = recipeJson.get("max").getAsInt();
                            int average = (minAmount + maxAmount) / 2;
                            String string4 = recipeJson.get("cost").getAsString();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAsString(...)");
                            PrimitiveRecipe recipe = new PrimitiveRecipe(SetsKt.setOf((Object)new PrimitiveIngredient(NeuInternalName.Companion.toInternalName(string4), average)), output, RecipeType.TRADE, false);
                            EnoughUpdatesManager.INSTANCE.registerRecipe(recipe);
                            return;
                        }
                        String string5 = recipeJson.get("cost").getAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAsString(...)");
                        PrimitiveRecipe recipe = new PrimitiveRecipe(SetsKt.setOf((Object)new PrimitiveIngredient(string5)), output, RecipeType.TRADE, false);
                        EnoughUpdatesManager.INSTANCE.registerRecipe(recipe);
                        return;
                    }
                    case 1: {
                        String string6 = itemJson.get("internalname").getAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getAsString(...)");
                        Set ingredient = SetsKt.setOf((Object)new PrimitiveIngredient(string6));
                        Set outputs = new LinkedHashSet();
                        Iterator iterator4 = recipeJson.get("drops").getAsJsonArray().iterator();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator4, (String)"iterator(...)");
                        Iterator maxAmount = iterator4;
                        while (true) {
                            if (!maxAmount.hasNext()) {
                                PrimitiveRecipe recipe = new PrimitiveRecipe(ingredient, outputs, RecipeType.MOB_DROP, false);
                                EnoughUpdatesManager.INSTANCE.registerRecipe(recipe);
                                return;
                            }
                            JsonElement output = (JsonElement)maxAmount.next();
                            String string7 = output.getAsJsonObject().get("id").getAsString();
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAsString(...)");
                            outputs.add(new PrimitiveIngredient(string7));
                        }
                    }
                    case 5: {
                        Set ingredients = new LinkedHashSet();
                        Iterator iterator5 = recipeJson.get("cost").getAsJsonArray().iterator();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator5, (String)"iterator(...)");
                        Iterator outputs = iterator5;
                        while (true) {
                            if (!outputs.hasNext()) {
                                String string8 = recipeJson.get("result").getAsString();
                                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getAsString(...)");
                                Set output = SetsKt.setOf((Object)new PrimitiveIngredient(string8));
                                PrimitiveRecipe recipe = new PrimitiveRecipe(ingredients, output, RecipeType.NPC_SHOP, false, 8, null);
                                EnoughUpdatesManager.INSTANCE.registerRecipe(recipe);
                                return;
                            }
                            JsonElement ingredient = (JsonElement)outputs.next();
                            String string9 = ingredient.getAsString();
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getAsString(...)");
                            ingredients.add(new PrimitiveIngredient(string9));
                        }
                    }
                    case 3: {
                        Set ingredients = new LinkedHashSet();
                        Iterator iterator6 = recipeJson.get("items").getAsJsonArray().iterator();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator6, (String)"iterator(...)");
                        Object output = iterator6;
                        while (true) {
                            if (!output.hasNext()) {
                                String string10 = recipeJson.get("input").getAsString();
                                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getAsString(...)");
                                ingredients.add(new PrimitiveIngredient(string10));
                                ingredients.add(PrimitiveIngredient.Companion.coinIngredient(recipeJson.get("coins").getAsDouble()));
                                String string11 = recipeJson.get("output").getAsString();
                                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getAsString(...)");
                                output = SetsKt.setOf((Object)new PrimitiveIngredient(string11));
                                PrimitiveRecipe recipe = new PrimitiveRecipe(ingredients, (Set<PrimitiveIngredient>)output, RecipeType.KAT_UPGRADE, false);
                                EnoughUpdatesManager.INSTANCE.registerRecipe(recipe);
                                return;
                            }
                            JsonElement ingredient = (JsonElement)output.next();
                            String string12 = ingredient.getAsString();
                            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getAsString(...)");
                            ingredients.add(new PrimitiveIngredient(string12));
                        }
                    }
                }
            }
            Set ingredients = new LinkedHashSet();
            String[] recipe = new String[]{"1", "2", "3"};
            String[] x = recipe;
            String[] output = new String[]{"A", "B", "C"};
            String[] y = output;
            for (int i2 = 0; i2 < 9; ++i2) {
                String name2 = y[i2 / 3] + x[i2 % 3];
                Object object = recipeJson.get(name2);
                if (object == null || (object = object.getAsString()) == null) continue;
                Object object2 = object;
                boolean bl = false;
                if (!(((CharSequence)object2).length() > 0)) continue;
                ingredients.add(new PrimitiveIngredient((String)object2));
            }
            this.submitRecipe(ingredients, recipeJson, itemJson, RecipeType.CRAFTING);
        }

        private final void submitRecipe(Set<PrimitiveIngredient> ingredients, JsonObject recipeJson, JsonObject itemJson, RecipeType recipeType) {
            int craftAmount = recipeJson.has("count") ? recipeJson.get("count").getAsInt() : 1;
            String outputInternalName = recipeJson.has("overrideOutputId") ? recipeJson.get("overrideOutputId").getAsString() : itemJson.get("internalname").getAsString();
            Intrinsics.checkNotNull((Object)outputInternalName);
            PrimitiveIngredient outputItem = new PrimitiveIngredient(NeuInternalName.Companion.toInternalName(outputInternalName), craftAmount);
            PrimitiveRecipe recipe = new PrimitiveRecipe(ingredients, SetsKt.setOf((Object)outputItem), recipeType, false, 8, null);
            EnoughUpdatesManager.INSTANCE.registerRecipe(recipe);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

