/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.foraging;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.foraging.ForagingTutorialQuestConfig;
import at.hannibal2.skyhanni.data.EntityMovementData;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.hypixel.chat.event.SystemMessageEvent;
import at.hannibal2.skyhanni.events.MessageSendToServerEvent;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002&'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u000f\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010$\u00a8\u0006("}, d2={"Lat/hannibal2/skyhanni/features/foraging/ForagingTutorialQuest;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;", "event", "", "onMessageSendToServer", "(Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;)V", "Lat/hannibal2/skyhanni/data/hypixel/chat/event/SystemMessageEvent;", "onChat", "(Lat/hannibal2/skyhanni/data/hypixel/chat/event/SystemMessageEvent;)V", "", "quest", "stepByName", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$DisplayNpc;", "onPlayerSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$DisplayNpc;)V", "Lat/hannibal2/skyhanni/features/foraging/ForagingTutorialQuest$NextQuest;", "goToNext", "(Lat/hannibal2/skyhanni/features/foraging/ForagingTutorialQuest$NextQuest;)V", "Lat/hannibal2/skyhanni/features/foraging/ForagingTutorialQuest$Quest;", "step", "start", "(Lat/hannibal2/skyhanni/features/foraging/ForagingTutorialQuest$Quest;)V", "suggest", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/foraging/ForagingTutorialQuestConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/foraging/ForagingTutorialQuestConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastParkWarpAttempt", "J", "lastSuggestion", "Quest", "NextQuest", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nForagingTutorialQuest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForagingTutorialQuest.kt\nat/hannibal2/skyhanni/features/foraging/ForagingTutorialQuest\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n8#2:148\n8#2:150\n1#3:149\n1#3:151\n*S KotlinDebug\n*F\n+ 1 ForagingTutorialQuest.kt\nat/hannibal2/skyhanni/features/foraging/ForagingTutorialQuest\n*L\n71#1:148\n92#1:150\n71#1:149\n92#1:151\n*E\n"})
public final class ForagingTutorialQuest {
    @NotNull
    public static final ForagingTutorialQuest INSTANCE = new ForagingTutorialQuest();
    private static long lastParkWarpAttempt = SimpleTimeMark.Companion.farPast();
    private static long lastSuggestion = SimpleTimeMark.Companion.farPast();

    private ForagingTutorialQuest() {
    }

    private final ForagingTutorialQuestConfig getConfig() {
        return SkyHanniMod.feature.getForaging().getTutorialQuest();
    }

    @HandleEvent
    public final void onMessageSendToServer(@NotNull MessageSendToServerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = event.getMessage();
        String string = message.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string, (Object)"/warp park")) {
            lastParkWarpAttempt = SimpleTimeMark.Companion.now-uFjCsEo();
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onChat(@NotNull SystemMessageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getMessage(), (Object)"\u00a7cYou don't have the requirements to use this warp!") || Intrinsics.areEqual((Object)event.getMessage(), (Object)"\u00a7cYou haven't unlocked this fast travel destination!")) {
            if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastParkWarpAttempt), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)) < 0) {
                EntityMovementData.INSTANCE.onNextTeleport(IslandType.HUB, (Function0<Unit>)((Function0)ForagingTutorialQuest::onChat$lambda$0));
            }
        }
        if (IslandType.HUB.isCurrent() || IslandType.THE_PARK.isCurrent()) {
            void $this$matchMatcher$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Object object = "\u00a7cYou must complete the \u00a7r\u00a76(?<quest>.*) Quest \u00a7r\u00a7cto use this!";
            int n = 0;
            Pattern pattern = Pattern.compile((String)object, n);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            object = pattern;
            String text$iv = event.getMessage();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull((Object)it$iv);
                Matcher $this$onChat_u24lambda_u241 = it$iv;
                boolean bl2 = false;
                String string = $this$onChat_u24lambda_u241.group("quest");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                INSTANCE.stepByName(string);
            }
        }
        for (NextQuest step : NextQuest.getEntries()) {
            if (!StringsKt.endsWith$default((String)event.getMessage(), (String)step.getEndingMessage(), (boolean)false, (int)2, null)) continue;
            this.goToNext(step);
        }
    }

    private final void stepByName(String quest) {
        for (Quest step : Quest.getEntries()) {
            if (!Intrinsics.areEqual((Object)step.getQuestName(), (Object)quest)) continue;
            this.start(step);
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onPlayerSpawn(@NotNull MobEvent.Spawn.DisplayNpc event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Object object = "\u00a7cRequires \u00a76(?<quest>.*) Quest";
        int n = 0;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        object = pattern;
        String text$iv = event.getMob().getName();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onPlayerSpawn_u24lambda_u242 = it$iv;
            boolean bl2 = false;
            String string = $this$onPlayerSpawn_u24lambda_u242.group("quest");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            INSTANCE.stepByName(string);
        }
    }

    private final void goToNext(NextQuest quest) {
        if (!this.isEnabled()) {
            return;
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Go to next phase!", false, null, false, false, null, 62, null);
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, quest.getNextPortal(), "Next Quest", null, null, null, ForagingTutorialQuest::goToNext$lambda$3, 28, null);
    }

    private final void start(Quest step) {
        if (!this.isEnabled()) {
            this.suggest(step);
            return;
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Go to " + step.getNpcName() + " and start the " + step.getQuestName() + " quest!", false, null, false, false, null, 62, null);
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, step.getNpcLocation(), step.getNpcName(), null, null, null, ForagingTutorialQuest::start$lambda$4, 28, null);
    }

    private final void suggest(Quest step) {
        if (!this.getConfig().getSuggestToEnable()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastSuggestion), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES)) < 0) {
            return;
        }
        lastSuggestion = SimpleTimeMark.Companion.now-uFjCsEo();
        ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "Do you want to have help solving the Foraging Tutorial Quest? Click here!", () -> ForagingTutorialQuest.suggest$lambda$5(step), null, 0L, false, null, false, false, 252, null);
        ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "Never see this suggestion again? Click here!", ForagingTutorialQuest::suggest$lambda$6, null, 0L, false, null, false, false, 252, null);
    }

    private final boolean isEnabled() {
        return this.getConfig().getEnabled() && !PlatformUtils.INSTANCE.getIS_LEGACY();
    }

    private static final Unit onChat$lambda$0() {
        INSTANCE.start(Quest.FIRST);
        return Unit.INSTANCE;
    }

    private static final boolean goToNext$lambda$3() {
        return INSTANCE.isEnabled();
    }

    private static final boolean start$lambda$4() {
        return INSTANCE.isEnabled();
    }

    private static final Unit suggest$lambda$5(Quest $step) {
        Intrinsics.checkNotNullParameter((Object)((Object)$step), (String)"$step");
        if (PlatformUtils.INSTANCE.getIS_LEGACY()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7cYou need to be on a modern version of Minecraft to use this feature!", false, null, false, false, null, 62, null);
            return Unit.INSTANCE;
        }
        INSTANCE.getConfig().setEnabled(true);
        INSTANCE.start($step);
        return Unit.INSTANCE;
    }

    private static final Unit suggest$lambda$6() {
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Disabled Foraging Tutorial Quest Suggestions.", false, null, false, false, null, 62, null);
        INSTANCE.getConfig().setSuggestToEnable(false);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lat/hannibal2/skyhanni/features/foraging/ForagingTutorialQuest$NextQuest;", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "nextPortal", "", "endingMessage", "<init>", "(Ljava/lang/String;ILat/hannibal2/skyhanni/utils/LorenzVec;Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getNextPortal", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "Ljava/lang/String;", "getEndingMessage", "()Ljava/lang/String;", "SECOND", "THIRD", "FOURTH_LAST", "FIFTH", "SIXTH_FIRST", "SIXTH_SECOND", "SIXTH_THIRD", "SIXTH_FOURTH", "SIXTH_FIFTH", "SIXTH_SIXTH", "SIXTH_SEVENTH", "SIXTH_8", "SEVEN", "1.21.5"})
    private static final class NextQuest
    extends Enum<NextQuest> {
        @NotNull
        private final LorenzVec nextPortal;
        @NotNull
        private final String endingMessage;
        public static final /* enum */ NextQuest SECOND = new NextQuest(new LorenzVec(-312.1, 81.0, -9.0), "Can you maybe look for her in the \u00a7aSpruce Woods\u00a7f?");
        public static final /* enum */ NextQuest THIRD = new NextQuest(new LorenzVec(-361.2, 90.0, -14.8), "\u00a7cCult Meeting \u00a7fthere \u00a7c\u00a7lRIGHT NOW\u00a7f!");
        public static final /* enum */ NextQuest FOURTH_LAST = new NextQuest(new LorenzVec(-397.3, 98.0, -37.5), "\u00a7rYou completed each \u00a76Trial of Fire\u00a7f! \u00a7aCongratulations!");
        public static final /* enum */ NextQuest FIFTH = new NextQuest(new LorenzVec(-436.4, 110.5, -14.4), " \u00a7rTalk to me again if you ever want to give my \u00a7dHarp \u00a7fa try!");
        public static final /* enum */ NextQuest SIXTH_FIRST = new NextQuest(new LorenzVec(-435.5, 110.0, -13.5), "\u00a7r\u00a7fIt will take me some time to assemble them, so you should \u00a7acome back later\u00a7f.");
        public static final /* enum */ NextQuest SIXTH_SECOND = new NextQuest(new LorenzVec(-466.8, 120.0, -41.6), "  \u00a7r\u00a7fTalk to Molbert");
        public static final /* enum */ NextQuest SIXTH_THIRD = new NextQuest(new LorenzVec(-465.9, 119.0, -53.8), "Once you find the ideal spots, go ahead and deploy them.");
        public static final /* enum */ NextQuest SIXTH_FOURTH = new NextQuest(new LorenzVec(-448.8, 120.0, -64.3), "\u00a7aPlaced trap \u00a7r\u00a77(\u00a7r\u00a7e1\u00a7r\u00a77/\u00a7r\u00a7a3\u00a7r\u00a77)");
        public static final /* enum */ NextQuest SIXTH_FIFTH = new NextQuest(new LorenzVec(-439.8, 122.0, -91.3), "LorenzVec(-448.8, 120.0, -64.3)");
        public static final /* enum */ NextQuest SIXTH_SIXTH = new NextQuest(new LorenzVec(-466.8, 120.0, -43.4), "\u00a7aPlaced trap \u00a7r\u00a77(\u00a7r\u00a7a3\u00a7r\u00a77/\u00a7r\u00a7a3\u00a7r\u00a77)");
        public static final /* enum */ NextQuest SIXTH_SEVENTH = new NextQuest(new LorenzVec(-435.5, 110.0, -13.5), "/\u00a7r\u00a7a3\u00a7r\u00a77)");
        public static final /* enum */ NextQuest SIXTH_8 = new NextQuest(new LorenzVec(-450.5, 120.0, -64.9), "  \u00a7r\u00a7fTalk to Molbert");
        public static final /* enum */ NextQuest SEVEN = new NextQuest(new LorenzVec(-485.3, 116.5, -40.7), " \u00a7rI hope you forgive me after this and we can still be \u00a76friends\u00a7f.");
        private static final /* synthetic */ NextQuest[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private NextQuest(LorenzVec nextPortal, String endingMessage) {
            this.nextPortal = nextPortal;
            this.endingMessage = endingMessage;
        }

        @NotNull
        public final LorenzVec getNextPortal() {
            return this.nextPortal;
        }

        @NotNull
        public final String getEndingMessage() {
            return this.endingMessage;
        }

        public static NextQuest[] values() {
            return (NextQuest[])$VALUES.clone();
        }

        public static NextQuest valueOf(String value) {
            return Enum.valueOf(NextQuest.class, value);
        }

        @NotNull
        public static EnumEntries<NextQuest> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = nextQuestArray = new NextQuest[]{NextQuest.SECOND, NextQuest.THIRD, NextQuest.FOURTH_LAST, NextQuest.FIFTH, NextQuest.SIXTH_FIRST, NextQuest.SIXTH_SECOND, NextQuest.SIXTH_THIRD, NextQuest.SIXTH_FOURTH, NextQuest.SIXTH_FIFTH, NextQuest.SIXTH_SIXTH, NextQuest.SIXTH_SEVENTH, NextQuest.SIXTH_8, NextQuest.SEVEN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\r\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lat/hannibal2/skyhanni/features/foraging/ForagingTutorialQuest$Quest;", "", "", "questName", "npcName", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "npcLocation", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "Ljava/lang/String;", "getQuestName", "()Ljava/lang/String;", "getNpcName", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getNpcLocation", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "FIRST", "SECOND", "THIRD", "FOURTH", "FIFTH", "1.21.5"})
    private static final class Quest
    extends Enum<Quest> {
        @NotNull
        private final String questName;
        @NotNull
        private final String npcName;
        @NotNull
        private final LorenzVec npcLocation;
        public static final /* enum */ Quest FIRST = new Quest("Foraging Tutorial", "Lumber Jack", new LorenzVec(-112.2, 73.0, -36.9));
        public static final /* enum */ Quest SECOND = new Quest("Into the Woods", "Charlie", new LorenzVec(-275.9, 80.0, -17.1));
        public static final /* enum */ Quest THIRD = new Quest("A Helping Hand", "Kelly", new LorenzVec(-350.8, 94.0, 31.7));
        public static final /* enum */ Quest FOURTH = new Quest("The Campfire Cult", "Ryan", new LorenzVec(-362.7, 102.0, -90.5));
        public static final /* enum */ Quest FIFTH = new Quest("The Rebuild", "Melody", new LorenzVec(-412.3, 109.0, 70.2));
        private static final /* synthetic */ Quest[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Quest(String questName, String npcName, LorenzVec npcLocation) {
            this.questName = questName;
            this.npcName = npcName;
            this.npcLocation = npcLocation;
        }

        @NotNull
        public final String getQuestName() {
            return this.questName;
        }

        @NotNull
        public final String getNpcName() {
            return this.npcName;
        }

        @NotNull
        public final LorenzVec getNpcLocation() {
            return this.npcLocation;
        }

        public static Quest[] values() {
            return (Quest[])$VALUES.clone();
        }

        public static Quest valueOf(String value) {
            return Enum.valueOf(Quest.class, value);
        }

        @NotNull
        public static EnumEntries<Quest> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = questArray = new Quest[]{Quest.FIRST, Quest.SECOND, Quest.THIRD, Quest.FOURTH, Quest.FIFTH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

