/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.inventory.AuctionHousePriceComparisonConfig;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryOpenEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipTextEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipTextEventKt;
import at.hannibal2.skyhanni.features.inventory.AuctionsHighlighter;
import at.hannibal2.skyhanni.features.misc.items.EstimatedItemValueCalculator;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.class_1277;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ7\u0010\u0013\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$J'\u0010(\u001a\u00020!2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\b+\u0010,R\u0014\u00100\u001a\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\"\u00102\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00104\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00106\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00105R\u0016\u00107\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108\u00a8\u00069"}, d2={"Lat/hannibal2/skyhanni/features/misc/AuctionHousePriceComparison;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryOpenEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryOpenEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "", "", "", "Lnet/minecraft/class_1799;", "stack", "binPrice", "slot", "add", "(Ljava/util/Map;Lnet/minecraft/class_1799;JI)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipTextEvent;", "onToolTip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipTextEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Ljava/awt/Color;", "color1", "color2", "", "percentage", "getColorInBetween", "(Ljava/awt/Color;Ljava/awt/Color;D)Ljava/awt/Color;", "delta", "start", "end", "lerp", "(DII)D", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/AuctionHousePriceComparisonConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/AuctionHousePriceComparisonConfig;", "config", "", "slotPriceMap", "Ljava/util/Map;", "bestPrice", "J", "worstPrice", "inInventory", "Z", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nAuctionHousePriceComparison.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuctionHousePriceComparison.kt\nat/hannibal2/skyhanni/features/misc/AuctionHousePriceComparison\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n8#2:156\n8#2:158\n1#3:157\n1#3:159\n*S KotlinDebug\n*F\n+ 1 AuctionHousePriceComparison.kt\nat/hannibal2/skyhanni/features/misc/AuctionHousePriceComparison\n*L\n48#1:156\n51#1:158\n48#1:157\n51#1:159\n*E\n"})
public final class AuctionHousePriceComparison {
    @NotNull
    public static final AuctionHousePriceComparison INSTANCE = new AuctionHousePriceComparison();
    @NotNull
    private static Map<Integer, Long> slotPriceMap = MapsKt.emptyMap();
    private static long bestPrice;
    private static long worstPrice;
    private static boolean inInventory;

    private AuctionHousePriceComparison() {
    }

    private final AuctionHousePriceComparisonConfig getConfig() {
        return SkyHanniMod.feature.getInventory().getAuctions().getAuctionsPriceComparison();
    }

    @HandleEvent
    public final void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean bl = inInventory = StringsKt.startsWith$default((String)event.getInventoryName(), (String)"Auctions", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)event.getInventoryName(), (String)"Cosmetics Browser", (boolean)false, (int)2, null);
        if (!inInventory) {
            return;
        }
        bestPrice = 0L;
        worstPrice = 0L;
        Map map = new LinkedHashMap();
        for (Map.Entry<Integer, class_1799> entry : event.getInventoryItems().entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            class_1799 stack = entry.getValue();
            for (String line : ItemUtils.INSTANCE.getLore(stack)) {
                RegexUtils regexUtils = RegexUtils.INSTANCE;
                Pattern $this$matchMatcher$iv = AuctionsHighlighter.INSTANCE.getBuyItNowPattern();
                boolean $i$f$matchMatcher = false;
                Matcher it$iv = $this$matchMatcher$iv.matcher(line);
                boolean bl2 = false;
                if (it$iv.matches()) {
                    Intrinsics.checkNotNull((Object)it$iv);
                    Matcher $this$onInventoryOpen_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    String string = $this$onInventoryOpen_u24lambda_u240.group("coins");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    INSTANCE.add(map, stack, NumberUtil.INSTANCE.formatLong(string), slot);
                }
                RegexUtils this_$iv = RegexUtils.INSTANCE;
                $this$matchMatcher$iv = AuctionsHighlighter.INSTANCE.getAuctionPattern();
                $i$f$matchMatcher = false;
                it$iv = $this$matchMatcher$iv.matcher(line);
                bl2 = false;
                if (!it$iv.matches()) continue;
                Intrinsics.checkNotNull((Object)it$iv);
                Matcher $this$onInventoryOpen_u24lambda_u241 = it$iv;
                boolean bl4 = false;
                String string = $this$onInventoryOpen_u24lambda_u241.group("coins");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                INSTANCE.add(map, stack, NumberUtil.INSTANCE.formatLong(string), slot);
            }
        }
        slotPriceMap = map;
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        inInventory = false;
    }

    private final void add(Map<Integer, Long> $this$add, class_1799 stack, long binPrice, int slot) {
        Double d = EstimatedItemValueCalculator.INSTANCE.getTotalPrice(stack, true);
        if (d == null) {
            return;
        }
        double price = d;
        long estimatedPrice = (long)price;
        long diff = estimatedPrice - binPrice;
        Integer n = slot;
        Long l = diff;
        $this$add.put(n, l);
        if (diff >= 0L) {
            if (diff > bestPrice) {
                bestPrice = diff;
            }
        } else if (diff < worstPrice) {
            worstPrice = diff;
        }
    }

    @HandleEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        Color good = ColorUtils.INSTANCE.toColor(this.getConfig().getGood());
        Color veryGood = ColorUtils.INSTANCE.toColor(this.getConfig().getVeryGood());
        Color bad = ColorUtils.INSTANCE.toColor(this.getConfig().getBad());
        Color veryBad = ColorUtils.INSTANCE.toColor(this.getConfig().getVeryBad());
        for (class_1735 slot : InventoryUtils.INSTANCE.getItemsInOpenChest()) {
            Long l = slotPriceMap.get(slot.method_34266());
            if (l == null) {
                continue;
            }
            long diff = l;
            if (diff == 0L) {
                RenderUtils.INSTANCE.highlight(slot, good);
                continue;
            }
            boolean isGood = diff >= 0L;
            double percentage = isGood ? (double)diff / (double)bestPrice : -((double)diff) / (double)(-worstPrice);
            Color color = isGood ? this.getColorInBetween(good, veryGood, percentage) : this.getColorInBetween(bad, veryBad, percentage);
            RenderUtils.INSTANCE.highlight(slot, color);
        }
    }

    @HandleEvent
    public final void onToolTip(@NotNull ToolTipTextEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getSlot() == null) {
            return;
        }
        Long l = slotPriceMap.get(event.getSlot().method_34266());
        if (l == null) {
            return;
        }
        long diff = l;
        if (!(event.getSlot().field_7871 instanceof class_1277)) {
            return;
        }
        ToolTipTextEventKt.add(event.getToolTip(), "");
        if (diff >= 0L) {
            ToolTipTextEventKt.add(event.getToolTip(), "\u00a7aThis item is \u00a76" + NumberUtil.INSTANCE.addSeparators(diff) + " coins \u00a7acheaper");
            ToolTipTextEventKt.add(event.getToolTip(), "\u00a7athan the estimated item value!");
        } else {
            ToolTipTextEventKt.add(event.getToolTip(), "\u00a7cThis item is \u00a76" + NumberUtil.INSTANCE.addSeparators(-diff) + " coins \u00a7cmore");
            ToolTipTextEventKt.add(event.getToolTip(), "\u00a7cexpensive than the estimated item value!");
        }
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 31, "inventory.auctionsPriceComparison", "inventory.auctions.auctionsPriceComparison", null, 8, null);
    }

    private final Color getColorInBetween(Color color1, Color color2, double percentage) {
        int r1 = color1.getRed();
        int g1 = color1.getGreen();
        int b1 = color1.getBlue();
        int r2 = color2.getRed();
        int g2 = color2.getGreen();
        int b2 = color2.getBlue();
        int newRed = RangesKt.coerceIn((int)((int)this.lerp(percentage, r1, r2)), (int)0, (int)255);
        int newGreen = RangesKt.coerceIn((int)((int)this.lerp(percentage, g1, g2)), (int)0, (int)255);
        int newBlue = RangesKt.coerceIn((int)((int)this.lerp(percentage, b1, b2)), (int)0, (int)255);
        return new Color(newRed, newGreen, newBlue);
    }

    private final double lerp(double delta, int start2, int end) {
        return (double)start2 + delta * (double)(end - start2);
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getEnabled() && inInventory;
    }
}

