/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.render;

import at.hannibal2.skyhanni.test.command.ErrorManager;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4618;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/utils/render/SkyHanniOutlineVertexConsumerProvider;", "Lnet/minecraft/class_4618;", "Lnet/minecraft/class_4597$class_4598;", "parent", "<init>", "(Lnet/minecraft/class_4597$class_4598;)V", "", "draw", "()V", "Lnet/minecraft/class_1921;", "renderLayer", "Lnet/minecraft/class_4588;", "getBuffer", "(Lnet/minecraft/class_1921;)Lnet/minecraft/class_4588;", "Companion", "1.21.5"})
public final class SkyHanniOutlineVertexConsumerProvider
extends class_4618 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<SkyHanniOutlineVertexConsumerProvider> vertexConsumers$delegate = LazyKt.lazy(SkyHanniOutlineVertexConsumerProvider::vertexConsumers_delegate$lambda$0);
    @Nullable
    private static GpuTexture customDepthAttachment;
    private static boolean currentlyActive;
    private static int lastWidth;
    private static int lastHeight;

    public SkyHanniOutlineVertexConsumerProvider(@NotNull class_4597.class_4598 parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent);
    }

    public void method_23285() {
        SkyHanniOutlineVertexConsumerProvider.Companion.beginRendering();
        super.method_23285();
        SkyHanniOutlineVertexConsumerProvider.Companion.finishRendering();
    }

    @NotNull
    public class_4588 getBuffer(@NotNull class_1921 renderLayer) {
        Intrinsics.checkNotNullParameter((Object)renderLayer, (String)"renderLayer");
        SkyHanniOutlineVertexConsumerProvider.Companion.beginRendering();
        class_4588 returnVal = super.getBuffer(renderLayer);
        SkyHanniOutlineVertexConsumerProvider.Companion.finishRendering();
        Intrinsics.checkNotNull((Object)returnVal);
        return returnVal;
    }

    private static final SkyHanniOutlineVertexConsumerProvider vertexConsumers_delegate$lambda$0() {
        class_4597.class_4598 class_45982 = class_310.method_1551().method_22940().method_23000();
        Intrinsics.checkNotNullExpressionValue((Object)class_45982, (String)"getEntityVertexConsumers(...)");
        return new SkyHanniOutlineVertexConsumerProvider(class_45982);
    }

    @NotNull
    public static final SkyHanniOutlineVertexConsumerProvider getVertexConsumers() {
        return Companion.getVertexConsumers();
    }

    @JvmStatic
    @Nullable
    public static final GpuTexture getOverrideDepthAttachment() {
        return Companion.getOverrideDepthAttachment();
    }

    public static final boolean getCurrentlyActive() {
        return Companion.getCurrentlyActive();
    }

    public static final void setCurrentlyActive(boolean bl) {
        Companion.setCurrentlyActive(bl);
    }

    @JvmStatic
    public static final void checkIfDepthAttachmentNeedsUpdating() {
        Companion.checkIfDepthAttachmentNeedsUpdating();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003R!\u0010\u0012\u001a\u00020\f8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R(\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\u0016\u0010\u0017\u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u001f\u00a8\u0006!"}, d2={"Lat/hannibal2/skyhanni/utils/render/SkyHanniOutlineVertexConsumerProvider$Companion;", "", "<init>", "()V", "Lcom/mojang/blaze3d/textures/GpuTexture;", "getOverrideDepthAttachment", "()Lcom/mojang/blaze3d/textures/GpuTexture;", "", "beginRendering", "finishRendering", "checkIfDepthAttachmentNeedsUpdating", "updateDepthAttachment", "Lat/hannibal2/skyhanni/utils/render/SkyHanniOutlineVertexConsumerProvider;", "vertexConsumers$delegate", "Lkotlin/Lazy;", "getVertexConsumers", "()Lat/hannibal2/skyhanni/utils/render/SkyHanniOutlineVertexConsumerProvider;", "getVertexConsumers$annotations", "vertexConsumers", "customDepthAttachment", "Lcom/mojang/blaze3d/textures/GpuTexture;", "", "currentlyActive", "Z", "getCurrentlyActive", "()Z", "setCurrentlyActive", "(Z)V", "getCurrentlyActive$annotations", "", "lastWidth", "I", "lastHeight", "1.21.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SkyHanniOutlineVertexConsumerProvider getVertexConsumers() {
            Lazy lazy = vertexConsumers$delegate;
            return (SkyHanniOutlineVertexConsumerProvider)((Object)lazy.getValue());
        }

        @JvmStatic
        public static /* synthetic */ void getVertexConsumers$annotations() {
        }

        @JvmStatic
        @Nullable
        public final GpuTexture getOverrideDepthAttachment() {
            if (!this.getCurrentlyActive()) {
                return null;
            }
            return customDepthAttachment;
        }

        public final boolean getCurrentlyActive() {
            return currentlyActive;
        }

        public final void setCurrentlyActive(boolean bl) {
            currentlyActive = bl;
        }

        @JvmStatic
        public static /* synthetic */ void getCurrentlyActive$annotations() {
        }

        private final void beginRendering() {
            this.setCurrentlyActive(true);
        }

        private final void finishRendering() {
            this.setCurrentlyActive(false);
        }

        @JvmStatic
        public final void checkIfDepthAttachmentNeedsUpdating() {
            class_1041 window = class_310.method_1551().method_22683();
            if (customDepthAttachment == null || window.method_4489() != lastWidth || window.method_4506() != lastHeight) {
                lastWidth = window.method_4489();
                lastHeight = window.method_4506();
                this.updateDepthAttachment();
            }
            try {
                CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
                GpuTexture gpuTexture = class_310.method_1551().method_1522().method_30278();
                GpuTexture gpuTexture2 = customDepthAttachment;
                Intrinsics.checkNotNull((Object)gpuTexture2);
                commandEncoder.copyTextureToTexture(gpuTexture, gpuTexture2, 0, 0, 0, 0, 0, lastWidth, lastHeight);
            }
            catch (Exception e) {
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Failed to copy depth attachment", new Pair[0], false, false, false, 56, null);
            }
        }

        private final void updateDepthAttachment() {
            try {
                if (customDepthAttachment != null) {
                    GpuTexture gpuTexture = customDepthAttachment;
                    Intrinsics.checkNotNull((Object)gpuTexture);
                    gpuTexture.close();
                }
                GpuDevice device = RenderSystem.getDevice();
                GpuTexture depthAttachment = device.createTexture("SkyHanni Custom Depth", TextureFormat.DEPTH32, lastWidth, lastHeight, 1);
                depthAttachment.setTextureFilter(FilterMode.NEAREST, false);
                depthAttachment.setAddressMode(AddressMode.CLAMP_TO_EDGE);
                customDepthAttachment = depthAttachment;
            }
            catch (Exception e) {
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Failed to update outline depth attachment", new Pair[0], false, false, false, 56, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

