/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.hypixelapi;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.hypixel.modapi.HypixelApiJoinEvent;
import at.hannibal2.skyhanni.events.hypixel.modapi.HypixelApiServerChangeEvent;
import at.hannibal2.skyhanni.events.minecraft.ClientDisconnectEvent;
import at.hannibal2.skyhanni.events.minecraft.ScoreboardTitleUpdateEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LorenzLogger;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.hypixel.data.type.GameType;
import net.hypixel.data.type.ServerType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\r\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u001d\u0010\u001d\u001a\u00020\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0003J%\u0010\"\u001a\u00020 2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fH\u0002\u00a2\u0006\u0004\b\"\u0010#R$\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020$8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R$\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020$8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010'\u001a\u0004\b+\u0010)R$\u0010-\u001a\u00020,2\u0006\u0010%\u001a\u00020,8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R(\u00101\u001a\u0004\u0018\u00010 2\b\u0010%\u001a\u0004\u0018\u00010 8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R$\u00105\u001a\u00020$2\u0006\u0010%\u001a\u00020$8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b5\u0010'\u001a\u0004\b6\u0010)R(\u00108\u001a\u0004\u0018\u0001072\b\u0010%\u001a\u0004\u0018\u0001078\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R(\u0010<\u001a\u0004\u0018\u00010 2\b\u0010%\u001a\u0004\u0018\u00010 8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b<\u00102\u001a\u0004\b=\u00104R(\u0010>\u001a\u0004\u0018\u00010 2\b\u0010%\u001a\u0004\u0018\u00010 8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b>\u00102\u001a\u0004\b?\u00104R$\u0010@\u001a\u00020$2\u0006\u0010%\u001a\u00020$8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b@\u0010'\u001a\u0004\b@\u0010)R\u0011\u0010B\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010)R\u0014\u0010D\u001a\u00020C8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0016\u0010F\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010'R\u0016\u0010G\u001a\u00020,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010.R(\u0010K\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f0H8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006L"}, d2={"Lat/hannibal2/skyhanni/api/hypixelapi/HypixelLocationApi;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/hypixel/modapi/HypixelApiJoinEvent;", "event", "", "onHypixelJoin", "(Lat/hannibal2/skyhanni/events/hypixel/modapi/HypixelApiJoinEvent;)V", "Lat/hannibal2/skyhanni/events/hypixel/modapi/HypixelApiServerChangeEvent;", "onServerChange", "(Lat/hannibal2/skyhanni/events/hypixel/modapi/HypixelApiServerChangeEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/ScoreboardTitleUpdateEvent;", "onScoreboardTitle", "(Lat/hannibal2/skyhanni/events/minecraft/ScoreboardTitleUpdateEvent;)V", "changeIsland", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/ClientDisconnectEvent;", "onDisconnect", "(Lat/hannibal2/skyhanni/events/minecraft/ClientDisconnectEvent;)V", "reset", "checkEquals", "Lkotlin/Function0;", "run", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "runNextSecond-1cd6UlU", "(Lkotlin/jvm/functions/Function0;)J", "runNextSecond", "sendError", "Lkotlin/Pair;", "", "pair", "dataToString", "(Lkotlin/Pair;)Ljava/lang/String;", "", "value", "inHypixel", "Z", "getInHypixel", "()Z", "inSkyblock", "getInSkyblock", "Lat/hannibal2/skyhanni/data/IslandType;", "island", "Lat/hannibal2/skyhanni/data/IslandType;", "getIsland", "()Lat/hannibal2/skyhanni/data/IslandType;", "serverId", "Ljava/lang/String;", "getServerId", "()Ljava/lang/String;", "inAlpha", "getInAlpha", "Lnet/hypixel/data/type/ServerType;", "serverType", "Lnet/hypixel/data/type/ServerType;", "getServerType", "()Lnet/hypixel/data/type/ServerType;", "mode", "getMode", "map", "getMap", "isGuest", "getConfig", "config", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "logger", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "sentIslandEvent", "internalIsland", "", "getDebugData", "()[Lkotlin/Pair;", "debugData", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHypixelLocationApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HypixelLocationApi.kt\nat/hannibal2/skyhanni/api/hypixelapi/HypixelLocationApi\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,198:1\n11102#2:199\n11437#2,3:200\n*S KotlinDebug\n*F\n+ 1 HypixelLocationApi.kt\nat/hannibal2/skyhanni/api/hypixelapi/HypixelLocationApi\n*L\n131#1:199\n131#1:200,3\n*E\n"})
public final class HypixelLocationApi {
    @NotNull
    public static final HypixelLocationApi INSTANCE = new HypixelLocationApi();
    private static boolean inHypixel;
    private static boolean inSkyblock;
    @NotNull
    private static IslandType island;
    @Nullable
    private static String serverId;
    private static boolean inAlpha;
    @Nullable
    private static ServerType serverType;
    @Nullable
    private static String mode;
    @Nullable
    private static String map;
    private static boolean isGuest;
    @NotNull
    private static final LorenzLogger logger;
    private static boolean sentIslandEvent;
    @NotNull
    private static IslandType internalIsland;

    private HypixelLocationApi() {
    }

    public final boolean getInHypixel() {
        return inHypixel;
    }

    public final boolean getInSkyblock() {
        return inSkyblock;
    }

    @NotNull
    public final IslandType getIsland() {
        return island;
    }

    @Nullable
    public final String getServerId() {
        return serverId;
    }

    public final boolean getInAlpha() {
        return inAlpha;
    }

    @Nullable
    public final ServerType getServerType() {
        return serverType;
    }

    @Nullable
    public final String getMode() {
        return mode;
    }

    @Nullable
    public final String getMap() {
        return map;
    }

    public final boolean isGuest() {
        return isGuest;
    }

    public final boolean getConfig() {
        return false;
    }

    @HandleEvent(priority=-2)
    public final void onHypixelJoin(@NotNull HypixelApiJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        logger.log(event.toString());
        logger.log("Connected to Hypixel");
        inAlpha = event.getAlpha();
        inHypixel = true;
    }

    @HandleEvent(priority=-2)
    public final void onServerChange(@NotNull HypixelApiServerChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        logger.log(event.toString());
        inHypixel = true;
        inSkyblock = event.getServerType() == GameType.SKYBLOCK;
        serverType = event.getServerType();
        mode = event.getMode();
        map = event.getMap();
        serverId = event.getServerName();
        if (!inSkyblock) {
            internalIsland = IslandType.NONE;
            this.changeIsland();
            return;
        }
        String string = event.getMode();
        if (string == null) {
            return;
        }
        String mode = string;
        IslandType newIsland = IslandType.Companion.getByIdOrUnknown(mode);
        if (newIsland == IslandType.UNKNOWN) {
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Unknown island detected: '" + (Object)((Object)newIsland) + '\'', false, 2, null);
            logger.log("Unknown Island detected: '" + (Object)((Object)newIsland) + '\'');
        } else {
            logger.log("Island detected: '" + (Object)((Object)newIsland) + '\'');
        }
        internalIsland = newIsland;
        if (internalIsland.hasGuestVariant()) {
            sentIslandEvent = false;
        } else {
            sentIslandEvent = true;
            this.changeIsland();
        }
    }

    @HandleEvent
    public final void onScoreboardTitle(@NotNull ScoreboardTitleUpdateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!inHypixel || !inSkyblock || sentIslandEvent || !event.isSkyblock()) {
            return;
        }
        isGuest = StringsKt.endsWith$default(StringUtils.removeColor$default(StringUtils.INSTANCE, ((Object)StringsKt.trim((CharSequence)event.getTitle())).toString(), false, 1, null), "GUEST", false, 2, null);
        sentIslandEvent = true;
        if (internalIsland.hasGuestVariant() && isGuest) {
            internalIsland = internalIsland.guestVariant();
        }
        this.changeIsland();
    }

    private final void changeIsland() {
        if (internalIsland == island) {
            return;
        }
        IslandType oldIsland = island;
        island = internalIsland;
        logger.log("Island change: '" + (Object)((Object)oldIsland) + "' -> '" + (Object)((Object)island) + '\'');
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.title("Hypixel Mod API");
        event.addIrrelevant(HypixelLocationApi::onDebug$lambda$0);
    }

    @HandleEvent
    public final void onDisconnect(@NotNull ClientDisconnectEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.reset();
    }

    private final void reset() {
        logger.log("Disconnected");
        inHypixel = false;
        inSkyblock = false;
        island = IslandType.NONE;
        serverId = null;
        inAlpha = false;
        serverType = null;
        mode = null;
        map = null;
        isGuest = false;
        sentIslandEvent = false;
        internalIsland = IslandType.NONE;
    }

    public final void checkEquals() {
        this.runNextSecond-1cd6UlU(HypixelLocationApi::checkEquals$lambda$1);
    }

    private final long runNextSecond-1cd6UlU(Function0<Unit> run) {
        return DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(1, DurationUnit.SECONDS), run);
    }

    private final void sendError() {
        if (!this.getConfig()) {
            return;
        }
        Object[] data2 = this.getDebugData();
        logger.log("ERROR: " + ArraysKt.joinToString$default(data2, null, null, null, 0, null, (Function1)new Function1<Pair<? extends String, ? extends Object>, String>((Object)this){

            public final String invoke(Pair<String, ? extends Object> p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return HypixelLocationApi.access$dataToString((HypixelLocationApi)this.receiver, p0);
            }
        }, 31, null));
        ErrorManager errorManager = ErrorManager.INSTANCE;
        Pair[] pairArray = (Pair[])Arrays.copyOf(data2, data2.length);
        ErrorManager.logErrorStateWithData$default(errorManager, "HypixelData check comparison with HypixelModAPI failed. Please report in discord.", "HypixelData comparison failed", pairArray, false, true, true, null, 72, null);
    }

    private final Pair<String, Object>[] getDebugData() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("HypixelData.skyBlock", HypixelData.INSTANCE.getSkyBlock()), TuplesKt.to("inSkyblock", inSkyblock), TuplesKt.to("HypixelData.hypixelLive", HypixelData.INSTANCE.getHypixelLive()), TuplesKt.to("inHypixel", inHypixel), TuplesKt.to("HypixelData.skyBlockIsland", HypixelData.INSTANCE.getSkyBlockIsland()), TuplesKt.to("island", island), TuplesKt.to("HypixelData.serverId", HypixelData.INSTANCE.getServerId()), TuplesKt.to("serverId", serverId), TuplesKt.to("serverType", serverType), TuplesKt.to("map", map)};
        return pairArray;
    }

    private final String dataToString(Pair<String, ? extends Object> pair) {
        return pair.getFirst() + ": " + pair.getSecond();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onDebug$lambda$0(List $this$addIrrelevant) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$addIrrelevant, "$this$addIrrelevant");
        Pair<String, Object>[] pairArray = INSTANCE.getDebugData();
        HypixelLocationApi hypixelLocationApi = INSTANCE;
        List list = $this$addIrrelevant;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void p0;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(hypixelLocationApi.dataToString((Pair<String, ? extends Object>)p0));
        }
        list.addAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit checkEquals$lambda$1() {
        isHypixelEqual = (HypixelData.INSTANCE.getHypixelLive() != false || HypixelData.INSTANCE.getHypixelAlpha() != false) == HypixelLocationApi.inHypixel;
        isSkyblockEqual = HypixelData.INSTANCE.getSkyBlock() == HypixelLocationApi.inSkyblock;
        otherIsland = HypixelData.INSTANCE.getSkyBlockIsland();
        if (otherIsland == HypixelLocationApi.island || otherIsland == IslandType.NONE) ** GOTO lbl-1000
        if (HypixelLocationApi.island == IslandType.NONE) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        isIslandEqual = v0;
        if (!HypixelLocationApi.inSkyblock) ** GOTO lbl-1000
        if (Intrinsics.areEqual(HypixelData.INSTANCE.getServerId(), HypixelLocationApi.serverId)) ** GOTO lbl-1000
        if (Intrinsics.areEqual(HypixelLocationApi.serverId, "limbo")) lbl-1000:
        // 3 sources

        {
            v1 = true;
        } else {
            v1 = isServerIdEqual = false;
        }
        if (isHypixelEqual && isSkyblockEqual && isIslandEqual && isServerIdEqual) {
            return Unit.INSTANCE;
        }
        HypixelLocationApi.INSTANCE.sendError();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$dataToString(HypixelLocationApi $this, Pair pair) {
        return $this.dataToString(pair);
    }

    static {
        island = IslandType.NONE;
        logger = new LorenzLogger("debug/hypixel_api");
        internalIsland = IslandType.NONE;
    }
}

