/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.internal;

import at.hannibal2.skyhanni.deps.moulconfig.common.text.DefaultFormattingColour;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredStyle;
import at.hannibal2.skyhanni.deps.moulconfig.internal.InitUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;

public final class StructuredStyleImpl
implements StructuredStyle {
    private final ChatStyle chatStyle;
    private static final Map<DefaultFormattingColour, EnumChatFormatting> FORMATTINGS = InitUtil.make(new HashMap(), colourMap -> {
        for (DefaultFormattingColour formattingColour : DefaultFormattingColour.values()) {
            for (EnumChatFormatting enumChatFormatting : EnumChatFormatting.values()) {
                if (enumChatFormatting.func_175746_b() != formattingColour.getColorHexDigit()) continue;
                colourMap.put(formattingColour, enumChatFormatting);
            }
        }
    });

    @NotNull
    public static StructuredStyle wrap(@NotNull ChatStyle chatStyle) {
        return new StructuredStyleImpl(chatStyle);
    }

    public static ChatStyle unwrap(StructuredStyle style) {
        return ((StructuredStyleImpl)style).chatStyle;
    }

    @Override
    @NotNull
    public StructuredStyle withColour(int rgb) {
        return this.withColour(DefaultFormattingColour.estimate(rgb));
    }

    @Override
    @NotNull
    public StructuredStyle withColour(@NotNull DefaultFormattingColour colour) {
        this.chatStyle.func_150238_a(Objects.requireNonNull(FORMATTINGS.get((Object)colour)));
        return this;
    }

    @Override
    @NotNull
    public StructuredStyle withBold(boolean bold) {
        this.chatStyle.func_150227_a(Boolean.valueOf(bold));
        return this;
    }

    @Override
    @NotNull
    public StructuredStyle withItalic(boolean italic) {
        this.chatStyle.func_150217_b(Boolean.valueOf(italic));
        return this;
    }

    @Override
    @NotNull
    public StructuredStyle withUnderline(boolean underline) {
        this.chatStyle.func_150228_d(Boolean.valueOf(underline));
        return this;
    }

    @Override
    @NotNull
    public StructuredStyle withStrikethrough(boolean strikethrough) {
        this.chatStyle.func_150225_c(Boolean.valueOf(strikethrough));
        return this;
    }

    @Override
    @NotNull
    public StructuredStyle withObfuscated(boolean obfuscated) {
        this.chatStyle.func_150237_e(Boolean.valueOf(obfuscated));
        return this;
    }

    public StructuredStyleImpl(ChatStyle chatStyle) {
        this.chatStyle = chatStyle;
    }

    public ChatStyle getChatStyle() {
        return this.chatStyle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructuredStyleImpl)) {
            return false;
        }
        StructuredStyleImpl other = (StructuredStyleImpl)o;
        ChatStyle this$chatStyle = this.getChatStyle();
        ChatStyle other$chatStyle = other.getChatStyle();
        return !(this$chatStyle == null ? other$chatStyle != null : !this$chatStyle.equals(other$chatStyle));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        ChatStyle $chatStyle = this.getChatStyle();
        result2 = result2 * 59 + ($chatStyle == null ? 43 : $chatStyle.hashCode());
        return result2;
    }

    public String toString() {
        return "StructuredStyleImpl(chatStyle=" + this.getChatStyle() + ")";
    }
}

