/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining.fossilexcavator;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.mining.FossilExcavationEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.inventory.Slot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u001b\u0010\u001c\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001f\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0019\u001a\u0004\b\u001e\u0010\u001bR\u001b\u0010\"\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0019\u001a\u0004\b!\u0010\u001bR\u001b\u0010%\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0019\u001a\u0004\b$\u0010\u001bR\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R&\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\"\u0010/\u001a\u00020&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010(\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\"\u00104\u001a\u00020&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u0010(\u001a\u0004\b5\u00101\"\u0004\b6\u00103R\u0017\u00108\u001a\u0002078\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lat/hannibal2/skyhanni/features/mining/fossilexcavator/FossilExcavatorApi;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "onInventoryUpdated", "(Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "chatPatternGroup", "Ljava/util/regex/Pattern;", "startPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getStartPattern", "()Ljava/util/regex/Pattern;", "startPattern", "endPattern$delegate", "getEndPattern", "endPattern", "itemPattern$delegate", "getItemPattern", "itemPattern", "emptyPattern$delegate", "getEmptyPattern", "emptyPattern", "", "inLoot", "Z", "", "Lkotlin/Pair;", "", "", "loot", "Ljava/util/List;", "inInventory", "getInInventory", "()Z", "setInInventory", "(Z)V", "inExcavatorMenu", "getInExcavatorMenu", "setInExcavatorMenu", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "scrapItem", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "getScrapItem", "()Lat/hannibal2/skyhanni/utils/NeuInternalName;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFossilExcavatorApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FossilExcavatorApi.kt\nat/hannibal2/skyhanni/features/mining/fossilexcavator/FossilExcavatorApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1557#2:120\n1628#2,3:121\n1755#2,3:124\n8#3:127\n1#4:128\n*S KotlinDebug\n*F\n+ 1 FossilExcavatorApi.kt\nat/hannibal2/skyhanni/features/mining/fossilexcavator/FossilExcavatorApi\n*L\n63#1:120\n63#1:121,3\n64#1:124,3\n102#1:127\n102#1:128\n*E\n"})
public final class FossilExcavatorApi {
    @NotNull
    public static final FossilExcavatorApi INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPatternGroup chatPatternGroup;
    @NotNull
    private static final RepoPattern startPattern$delegate;
    @NotNull
    private static final RepoPattern endPattern$delegate;
    @NotNull
    private static final RepoPattern itemPattern$delegate;
    @NotNull
    private static final RepoPattern emptyPattern$delegate;
    private static boolean inLoot;
    @NotNull
    private static final List<Pair<String, Integer>> loot;
    private static boolean inInventory;
    private static boolean inExcavatorMenu;
    @NotNull
    private static final NeuInternalName scrapItem;

    private FossilExcavatorApi() {
    }

    private final Pattern getStartPattern() {
        return (Pattern)startPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getEndPattern() {
        return (Pattern)endPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getItemPattern() {
        return (Pattern)itemPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getEmptyPattern() {
        return (Pattern)emptyPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    public final boolean getInInventory() {
        return inInventory;
    }

    public final void setInInventory(boolean bl) {
        inInventory = bl;
    }

    public final boolean getInExcavatorMenu() {
        return inExcavatorMenu;
    }

    public final void setInExcavatorMenu(boolean bl) {
        inExcavatorMenu = bl;
    }

    @NotNull
    public final NeuInternalName getScrapItem() {
        return scrapItem;
    }

    @HandleEvent(onlyOnIsland=IslandType.DWARVEN_MINES)
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!Intrinsics.areEqual(event.getInventoryName(), "Fossil Excavator")) {
            return;
        }
        inInventory = true;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onInventoryUpdated(@NotNull InventoryUpdatedEvent event) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(event, "event");
            if (!inInventory) {
                return;
            }
            List<Slot> slots = InventoryUtils.INSTANCE.getItemsInOpenChest();
            Iterable $this$map$iv = slots;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Slot slot = (Slot)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.func_75211_c().func_82833_r();
                Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
                collection.add(StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null));
            }
            List itemNames = (List)destination$iv$iv;
            Iterable $this$any$iv = itemNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it, "Start Excavator")) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        inExcavatorMenu = bl;
    }

    @HandleEvent
    public final void onWorldChange() {
        inInventory = false;
        inExcavatorMenu = false;
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        inInventory = false;
        inExcavatorMenu = false;
    }

    @HandleEvent(onlyOnIsland=IslandType.DWARVEN_MINES)
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Pair<String, Integer> pair;
        Intrinsics.checkNotNullParameter(event, "event");
        String message = event.getMessage();
        if (RegexUtils.INSTANCE.matches(this.getEmptyPattern(), message)) {
            new FossilExcavationEvent(CollectionsKt.emptyList()).post();
        }
        if (RegexUtils.INSTANCE.matches(this.getStartPattern(), message)) {
            inLoot = true;
            return;
        }
        if (!inLoot) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(this.getEndPattern(), message)) {
            new FossilExcavationEvent(CollectionsKt.toList((Iterable)loot)).post();
            loot.clear();
            inLoot = false;
            return;
        }
        Pair<String, Integer> pair2 = null;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getItemPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(message);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u242 = it$iv;
            boolean bl2 = false;
            String string = $this$onChat_u24lambda_u242.group("item");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            pair = ItemUtils.INSTANCE.readItemAmount(string);
        } else {
            pair = null;
        }
        if (pair == null) {
            return;
        }
        pair2 = pair;
        String string = ItemUtils.INSTANCE.readBookType((String)pair2.getFirst());
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            pair2 = TuplesKt.to(it, pair2.getSecond());
        }
        loot.add(pair2);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(FossilExcavatorApi.class, "startPattern", "getStartPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(FossilExcavatorApi.class, "endPattern", "getEndPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(FossilExcavatorApi.class, "itemPattern", "getItemPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(FossilExcavatorApi.class, "emptyPattern", "getEmptyPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new FossilExcavatorApi();
        patternGroup = RepoPattern.Companion.group("mining.fossil.excavator");
        chatPatternGroup = patternGroup.group("chat");
        startPattern$delegate = chatPatternGroup.pattern("start", " {2}\u00a7r\u00a76\u00a7lEXCAVATION COMPLETE ?");
        endPattern$delegate = chatPatternGroup.pattern("end", "\u00a7a\u00a7l\u25ac{64}");
        itemPattern$delegate = chatPatternGroup.pattern("item", " {4}\u00a7r(?<item>.+)");
        emptyPattern$delegate = chatPatternGroup.pattern("empty", "\u00a7cYou didn't find anything. Maybe next time!");
        loot = new ArrayList();
        scrapItem = NeuInternalName.Companion.toInternalName("SUSPICIOUS_SCRAP");
    }
}

