/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.update;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArgument;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArguments;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierBuilder;
import at.hannibal2.skyhanni.config.features.About;
import at.hannibal2.skyhanni.data.NotificationManager;
import at.hannibal2.skyhanni.data.SkyHanniNotification;
import at.hannibal2.skyhanni.data.jsonobjects.repo.DiscontinuedMinecraftVersion;
import at.hannibal2.skyhanni.data.jsonobjects.repo.DiscontinuedMinecraftVersionsJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.deps.libautoupdate.CurrentVersion;
import at.hannibal2.skyhanni.deps.libautoupdate.PotentialUpdate;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateContext;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateData;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateTarget;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateUtils;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.deps.moulconfig.processor.MoulConfigProcessor;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.hypixel.HypixelJoinEvent;
import at.hannibal2.skyhanni.features.misc.update.ChangelogViewer;
import at.hannibal2.skyhanni.features.misc.update.ConfigVersionDisplay;
import at.hannibal2.skyhanni.features.misc.update.CustomGithubReleaseUpdateSource;
import at.hannibal2.skyhanni.features.misc.update.GuiOptionEditorUpdateCheck;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LorenzLogger;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.api.ApiInternalUtils;
import at.hannibal2.skyhanni.utils.system.ModVersion;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HttpsURLConnection;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001EB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u0019\u0010\u000f\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u0003J!\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\t\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u0017\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\"\u0010\u0003R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u001c\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R0\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010&2\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010&8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u00100\u001a\u00020/2\u0006\u0010)\u001a\u00020/8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0016\u00104\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00109\u001a\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u0010;\u001a\u00020:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0018\u0010>\u001a\u0004\u0018\u00010=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\"\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020A0@8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010D\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u00105\u00a8\u0006F"}, d2={"Lat/hannibal2/skyhanni/features/misc/update/UpdateManager;", "", "<init>", "()V", "", "getNextVersion", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "event", "", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "onTick", "Lat/hannibal2/skyhanni/deps/moulconfig/processor/MoulConfigProcessor;", "processor", "injectConfigProcessor", "(Lat/hannibal2/skyhanni/deps/moulconfig/processor/MoulConfigProcessor;)V", "reset", "", "forceDownload", "Lat/hannibal2/skyhanni/config/features/About$UpdateStream;", "forcedUpdateStream", "checkUpdate", "(ZLat/hannibal2/skyhanni/config/features/About$UpdateStream;)V", "queueUpdate", "arg", "updateCommand", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "onHypixelJoin", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "logger", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "Ljava/util/concurrent/CompletableFuture;", "_activePromise", "Ljava/util/concurrent/CompletableFuture;", "value", "getActivePromise", "()Ljava/util/concurrent/CompletableFuture;", "setActivePromise", "(Ljava/util/concurrent/CompletableFuture;)V", "activePromise", "Lat/hannibal2/skyhanni/features/misc/update/UpdateManager$UpdateState;", "updateState", "Lat/hannibal2/skyhanni/features/misc/update/UpdateManager$UpdateState;", "getUpdateState", "()Lat/hannibal2/skyhanni/features/misc/update/UpdateManager$UpdateState;", "hasCheckedForUpdate", "Z", "Lat/hannibal2/skyhanni/config/features/About;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/About;", "config", "Lat/hannibal2/skyhanni/deps/libautoupdate/UpdateContext;", "context", "Lat/hannibal2/skyhanni/deps/libautoupdate/UpdateContext;", "Lat/hannibal2/skyhanni/deps/libautoupdate/PotentialUpdate;", "potentialUpdate", "Lat/hannibal2/skyhanni/deps/libautoupdate/PotentialUpdate;", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/DiscontinuedMinecraftVersion;", "discontinuedVersions", "Ljava/util/Map;", "hasWarned", "UpdateState", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nUpdateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateManager.kt\nat/hannibal2/skyhanni/features/misc/update/UpdateManager\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 5 BrigadierBuilder.kt\nat/hannibal2/skyhanni/config/commands/brigadier/BrigadierBuilder\n*L\n1#1,267:1\n13#2,7:268\n21#2,6:285\n167#3,5:275\n172#3,4:281\n24#4:280\n162#5,15:291\n*S KotlinDebug\n*F\n+ 1 UpdateManager.kt\nat/hannibal2/skyhanni/features/misc/update/UpdateManager\n*L\n239#1:268,7\n239#1:285,6\n239#1:275,5\n239#1:281,4\n239#1:280\n223#1:291,15\n*E\n"})
public final class UpdateManager {
    @NotNull
    public static final UpdateManager INSTANCE = new UpdateManager();
    @NotNull
    private static final LorenzLogger logger = new LorenzLogger("update_manager");
    @Nullable
    private static CompletableFuture<?> _activePromise;
    @NotNull
    private static UpdateState updateState;
    private static boolean hasCheckedForUpdate;
    @NotNull
    private static final UpdateContext context;
    @Nullable
    private static PotentialUpdate potentialUpdate;
    @NotNull
    private static Map<String, DiscontinuedMinecraftVersion> discontinuedVersions;
    private static boolean hasWarned;

    private UpdateManager() {
    }

    private final CompletableFuture<?> getActivePromise() {
        return _activePromise;
    }

    private final void setActivePromise(CompletableFuture<?> value) {
        CompletableFuture<?> completableFuture = _activePromise;
        if (completableFuture != null) {
            completableFuture.cancel(true);
        }
        _activePromise = value;
    }

    @NotNull
    public final UpdateState getUpdateState() {
        return updateState;
    }

    @Nullable
    public final String getNextVersion() {
        Object object = potentialUpdate;
        return object != null && (object = ((PotentialUpdate)object).getUpdate()) != null && (object = ((UpdateData)object).getVersionNumber()) != null ? object.getAsString() : null;
    }

    @HandleEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ConditionalUtils.INSTANCE.onToggle(SkyHanniMod.feature.getAbout().getUpdateStream(), UpdateManager::onConfigLoad$lambda$0);
    }

    @HandleEvent
    public final void onTick() {
        if (hasCheckedForUpdate) {
            return;
        }
        hasCheckedForUpdate = true;
        if (this.getConfig().getAutoUpdates() || this.getConfig().getFullAutoUpdates()) {
            UpdateManager.checkUpdate$default(this, false, null, 3, null);
        }
    }

    public final void injectConfigProcessor(@NotNull MoulConfigProcessor<?> processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        processor.registerConfigEditor(ConfigVersionDisplay.class, UpdateManager::injectConfigProcessor$lambda$1);
    }

    private final About getConfig() {
        return SkyHanniMod.feature.getAbout();
    }

    public final void reset() {
        updateState = UpdateState.NONE;
        _activePromise = null;
        potentialUpdate = null;
        logger.log("Reset update state");
    }

    public final void checkUpdate(boolean forceDownload, @NotNull About.UpdateStream forcedUpdateStream) {
        Intrinsics.checkNotNullParameter((Object)forcedUpdateStream, "forcedUpdateStream");
        About.UpdateStream updateStream = forcedUpdateStream;
        if (updateState != UpdateState.NONE) {
            if (updateState == UpdateState.AVAILABLE && forceDownload) {
                updateState = UpdateState.NONE;
                logger.log("Resetting update state to force download");
            } else {
                logger.log("Trying to perform update check while another update is already in progress");
                return;
            }
        }
        logger.log("Starting update check");
        About.UpdateStream currentStream = (About.UpdateStream)((Object)this.getConfig().getUpdateStream().get());
        if (currentStream != About.UpdateStream.BETA && (updateStream == About.UpdateStream.BETA || SkyHanniMod.INSTANCE.isBetaVersion())) {
            this.getConfig().getUpdateStream().set(About.UpdateStream.BETA);
            updateStream = About.UpdateStream.BETA;
        }
        this.setActivePromise((CompletableFuture<?>)context.checkUpdate(updateStream.getStream()).thenAcceptAsync(arg_0 -> UpdateManager.checkUpdate$lambda$4(arg_0 -> UpdateManager.checkUpdate$lambda$3(forceDownload, arg_0), arg_0), DelayedRun.onThread));
    }

    public static /* synthetic */ void checkUpdate$default(UpdateManager updateManager, boolean bl, About.UpdateStream updateStream, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            updateStream = (About.UpdateStream)((Object)updateManager.getConfig().getUpdateStream().get());
        }
        updateManager.checkUpdate(bl, updateStream);
    }

    public final void queueUpdate() {
        if (updateState != UpdateState.AVAILABLE) {
            logger.log("Trying to enqueue an update while another one is already downloaded or none is present");
        }
        updateState = UpdateState.QUEUED;
        this.setActivePromise((CompletableFuture<?>)CompletableFuture.supplyAsync(UpdateManager::queueUpdate$lambda$5).thenAcceptAsync(arg_0 -> UpdateManager.queueUpdate$lambda$7(UpdateManager::queueUpdate$lambda$6, arg_0), DelayedRun.onThread));
    }

    private final void updateCommand(String arg2) {
        boolean switchingToBeta;
        About.UpdateStream currentStream = (About.UpdateStream)((Object)SkyHanniMod.feature.getAbout().getUpdateStream().get());
        About.UpdateStream updateStream = arg2.equals(new Regex("(?i)(?:full|release)s?")) ? About.UpdateStream.RELEASES : (arg2.equals(new Regex("(?i)(?:beta|latest)s?")) ? About.UpdateStream.BETA : currentStream);
        boolean bl = switchingToBeta = updateStream == About.UpdateStream.BETA && (currentStream != About.UpdateStream.BETA || !SkyHanniMod.INSTANCE.isBetaVersion());
        if (switchingToBeta) {
            ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "Are you sure you want to switch to beta? These versions may be less stable.", UpdateManager::updateCommand$lambda$9, "\u00a7eClick to confirm!", 0L, false, null, true, false, 184, null);
        } else {
            Intrinsics.checkNotNull((Object)updateStream);
            this.checkUpdate(true, updateStream);
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.registerBrigadier("shupdate", UpdateManager::onCommandRegistration$lambda$12);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        block7: {
            Object object;
            Intrinsics.checkNotNullParameter(event, "event");
            String constant$iv = "DiscontinuedMinecraftVersions";
            Object type$iv = null;
            Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
            boolean $i$f$getConstant = false;
            AbstractRepoReloadEvent abstractRepoReloadEvent = event;
            try {
                Object $this$getRepoData_u24lambda_u2414$iv$iv;
                void this_$iv$iv;
                AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = abstractRepoReloadEvent;
                boolean bl = false;
                AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
                String directory$iv$iv = "constants";
                boolean $i$f$getRepoData = false;
                Object object2 = this_$iv$iv;
                try {
                    $this$getRepoData_u24lambda_u2414$iv$iv = object2;
                    boolean bl2 = false;
                    String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                    JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                    if (jsonElement == null) {
                        ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                        throw new KotlinNothingValueException();
                    }
                    JsonElement json$iv$iv = jsonElement;
                    Gson $this$fromJson$iv$iv$iv = gson$iv;
                    boolean $i$f$fromJson = false;
                    Object object3 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(DiscontinuedMinecraftVersionsJson.class)));
                    Intrinsics.checkNotNullExpressionValue(object3, "fromJson(...)");
                    $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(object3);
                }
                catch (Throwable bl2) {
                    $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(ResultKt.createFailure(bl2));
                }
                object2 = $this$getRepoData_u24lambda_u2414$iv$iv;
                Throwable throwable = Result.exceptionOrNull-impl(object2);
                if (throwable != null) {
                    Throwable e$iv$iv = throwable;
                    boolean bl3 = false;
                    this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv$iv);
                    throw new KotlinNothingValueException();
                }
                Object constantData$iv = object2;
                $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
                object = constantData$iv;
            }
            catch (Throwable bl) {
                Throwable throwable = Result.exceptionOrNull-impl(Result.constructor-impl(ResultKt.createFailure(bl)));
                if (throwable != null) {
                    Throwable it$iv = throwable;
                    boolean bl4 = false;
                    ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                    ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + '\'', it$iv);
                    throw new KotlinNothingValueException();
                }
                throw new KotlinNothingValueException();
            }
            DiscontinuedMinecraftVersionsJson constant = (DiscontinuedMinecraftVersionsJson)object;
            Map<String, DiscontinuedMinecraftVersion> map2 = constant.getVersions();
            if (map2 == null) break block7;
            Map<String, DiscontinuedMinecraftVersion> it = map2;
            boolean bl = false;
            discontinuedVersions = it;
        }
    }

    @HandleEvent(eventType=HypixelJoinEvent.class)
    public final void onHypixelJoin() {
        if (hasWarned) {
            return;
        }
        if (discontinuedVersions.containsKey(PlatformUtils.INSTANCE.getMC_VERSION())) {
            DiscontinuedMinecraftVersion discontinuedMinecraftVersion = discontinuedVersions.get(PlatformUtils.INSTANCE.getMC_VERSION());
            List<String> list = discontinuedMinecraftVersion != null ? discontinuedMinecraftVersion.getExtraInfo() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List<String> extraInfo = list;
            String[] stringArray = new String[]{"\u00a7cSkyHanni is no longer receiving updates for Minecraft \u00a7e" + PlatformUtils.INSTANCE.getMC_VERSION() + "\u00a7c.", "\u00a7cPlaying on a discontinued version is not recommended and may lead to issues.", "\u00a7cPlease update to a newer Minecraft version."};
            SkyHanniNotification notification = new SkyHanniNotification(CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)extraInfo), Duration.Companion.getINFINITE-UwyO8pc(), false, 4, null);
            NotificationManager.INSTANCE.queueNotification(notification);
        }
        hasWarned = true;
    }

    private static final void onConfigLoad$lambda$0() {
        INSTANCE.reset();
    }

    private static final GuiOptionEditor injectConfigProcessor$lambda$1(ProcessedOption option, ConfigVersionDisplay configVersionDisplay) {
        Intrinsics.checkNotNull(option);
        return new GuiOptionEditorUpdateCheck(option);
    }

    private static final Unit checkUpdate$lambda$3$lambda$2(PotentialUpdate $it) {
        String string = $it.getUpdate().getVersionName();
        Intrinsics.checkNotNullExpressionValue(string, "getVersionName(...)");
        ChangelogViewer.INSTANCE.showChangelog("4.26.0", string);
        return Unit.INSTANCE;
    }

    private static final Unit checkUpdate$lambda$3(boolean $forceDownload, PotentialUpdate it) {
        logger.log("Update check completed");
        if (updateState != UpdateState.NONE) {
            logger.log("This appears to be the second update check. Ignoring this one");
            return Unit.INSTANCE;
        }
        potentialUpdate = it;
        if (it.isUpdateAvailable()) {
            updateState = UpdateState.AVAILABLE;
            if (INSTANCE.getConfig().getFullAutoUpdates() || $forceDownload) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aSkyHanni found a new update: " + it.getUpdate().getVersionName() + ", starting to download now.", false, null, false, false, null, 62, null);
                INSTANCE.queueUpdate();
            } else if (INSTANCE.getConfig().getAutoUpdates()) {
                ChatUtils.INSTANCE.chatAndOpenConfig("\u00a7aSkyHanni found a new update: " + it.getUpdate().getVersionName() + ". Check \u00a7b/sh download update \u00a7afor more info.", new MutablePropertyReference0Impl(INSTANCE.getConfig()){

                    public Object get() {
                        return ((About)this.receiver).getAutoUpdates();
                    }

                    public void set(Object value) {
                        ((About)this.receiver).setAutoUpdates((Boolean)value);
                    }
                });
                ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "\u00a7e\u00a7lCLICK HERE \u00a7r\u00a7eto view changes.", () -> UpdateManager.checkUpdate$lambda$3$lambda$2(it), null, 0L, false, null, false, false, 252, null);
            }
        } else if ($forceDownload) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aSkyHanni didn't find a new update.", false, null, false, false, null, 62, null);
        }
        return Unit.INSTANCE;
    }

    private static final void checkUpdate$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit queueUpdate$lambda$5() {
        logger.log("Update download started");
        PotentialUpdate potentialUpdate = UpdateManager.potentialUpdate;
        Intrinsics.checkNotNull(potentialUpdate);
        potentialUpdate.prepareUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit queueUpdate$lambda$6(Unit it) {
        logger.log("Update download completed, setting exit hook");
        updateState = UpdateState.DOWNLOADED;
        PotentialUpdate potentialUpdate = UpdateManager.potentialUpdate;
        Intrinsics.checkNotNull(potentialUpdate);
        potentialUpdate.executePreparedUpdate();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Download of update complete. ", false, null, false, false, null, 62, null);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aThe update will be installed after your next restart.", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final void queueUpdate$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void _init_$lambda$8(URLConnection it) {
        if (it instanceof HttpsURLConnection) {
            ApiInternalUtils.INSTANCE.patchHttpsRequest((HttpsURLConnection)it);
        }
    }

    private static final Unit updateCommand$lambda$9() {
        Property<About.UpdateStream> newUpdateStream = SkyHanniMod.feature.getAbout().getUpdateStream();
        newUpdateStream.set(About.UpdateStream.BETA);
        Object t = newUpdateStream.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        INSTANCE.checkUpdate(true, (About.UpdateStream)((Object)t));
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$12$lambda$11(ArgContext $this$callback) {
        Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
        INSTANCE.updateCommand("current");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$12(BaseBrigadierBuilder $this$registerBrigadier) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Updates the mod to the specified update stream.");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_BUG_FIX);
        String string = "updateStream";
        ArgumentType argument$iv = BrigadierArguments.INSTANCE.string();
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            ((BrigadierBuilder)$this$registerBrigadier).internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void stream;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2412_u24lambda_u2410 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2412_u24lambda_u2410.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)stream){
                        final /* synthetic */ BrigadierArgument<String> $stream;
                        {
                            this.$stream = $stream;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            String string = $this$callback.getArg(this.$stream);
                            Intrinsics.checkNotNullExpressionValue(string, "getArg(...)");
                            UpdateManager.access$updateCommand(UpdateManager.INSTANCE, string);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            ((BrigadierBuilder)$this$registerBrigadier).literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void stream;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2412_u24lambda_u2410 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2412_u24lambda_u2410.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$registerBrigadier.callback(UpdateManager::onCommandRegistration$lambda$12$lambda$11);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateCommand(UpdateManager $this, String arg2) {
        $this.updateCommand(arg2);
    }

    static {
        updateState = UpdateState.NONE;
        context = new UpdateContext(new CustomGithubReleaseUpdateSource("hannibal002", "SkyHanni"), UpdateTarget.deleteAndSaveInTheSameFolder(UpdateManager.class), new CurrentVersion(){

            private final boolean getDebug() {
                return SkyHanniMod.feature.getDev().getDebug().getAlwaysOutdated();
            }

            public String display() {
                return this.getDebug() ? "Force Outdated" : "4.26.0";
            }

            public boolean isOlderThan(JsonElement element) {
                if (this.getDebug()) {
                    return true;
                }
                Object object = element;
                if (object == null || (object = object.getAsString()) == null) {
                    return true;
                }
                Object asString2 = object;
                ModVersion otherVersion = ModVersion.Companion.fromString((String)asString2);
                return SkyHanniMod.INSTANCE.getModVersion().compareTo(otherVersion) < 0;
            }
        }, "skyhanni");
        context.cleanup();
        UpdateUtils.patchConnection(UpdateManager::_init_$lambda$8);
        discontinuedVersions = MapsKt.emptyMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lat/hannibal2/skyhanni/features/misc/update/UpdateManager$UpdateState;", "", "<init>", "(Ljava/lang/String;I)V", "AVAILABLE", "QUEUED", "DOWNLOADED", "NONE", "1.8.9"})
    public static final class UpdateState
    extends Enum<UpdateState> {
        public static final /* enum */ UpdateState AVAILABLE = new UpdateState();
        public static final /* enum */ UpdateState QUEUED = new UpdateState();
        public static final /* enum */ UpdateState DOWNLOADED = new UpdateState();
        public static final /* enum */ UpdateState NONE = new UpdateState();
        private static final /* synthetic */ UpdateState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UpdateState[] values() {
            return (UpdateState[])$VALUES.clone();
        }

        public static UpdateState valueOf(String value) {
            return Enum.valueOf(UpdateState.class, value);
        }

        @NotNull
        public static EnumEntries<UpdateState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = updateStateArray = new UpdateState[]{UpdateState.AVAILABLE, UpdateState.QUEUED, UpdateState.DOWNLOADED, UpdateState.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

