/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat.end;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.DragonProfitTrackerItemDataJson;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.features.combat.end.DragonFeatures;
import at.hannibal2.skyhanni.features.combat.end.DragonProfitTracker;
import at.hannibal2.skyhanni.features.combat.end.DragonType;
import at.hannibal2.skyhanni.features.combat.end.ProfitPerDragon$scanForLoot$;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0003J\u0017\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000b0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010$R\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/features/combat/end/ProfitPerDragon;", "", "<init>", "()V", "", "scanForLoot", "", "weightIn", "calculateNonUniqueLoot", "(D)V", "reset", "", "placement", "getStandardEnderPearlAmount", "(I)I", "getStandardEnchantedEnderPearlAmount", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;", "event", "onTick", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;)V", "", "finishedLoot", "Z", "getFinishedLoot", "()Z", "setFinishedLoot", "(Z)V", "", "Ljava/util/UUID;", "scannedLootUUIDs", "Ljava/util/Set;", "", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "dragonLoot", "Ljava/util/Map;", "ENCHANTED_ENDER_PEARL", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "ENDER_PEARL", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastScanned", "J", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nProfitPerDragon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfitPerDragon.kt\nat/hannibal2/skyhanni/features/combat/end/ProfitPerDragon\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,142:1\n185#2:143\n477#3:144\n2163#3,2:145\n*S KotlinDebug\n*F\n+ 1 ProfitPerDragon.kt\nat/hannibal2/skyhanni/features/combat/end/ProfitPerDragon\n*L\n29#1:143\n29#1:144\n31#1:145,2\n*E\n"})
public final class ProfitPerDragon {
    @NotNull
    public static final ProfitPerDragon INSTANCE = new ProfitPerDragon();
    private static boolean finishedLoot = true;
    @NotNull
    private static final Set<UUID> scannedLootUUIDs = new LinkedHashSet();
    @NotNull
    private static final Map<NeuInternalName, Integer> dragonLoot = new LinkedHashMap();
    @NotNull
    private static final NeuInternalName ENCHANTED_ENDER_PEARL = NeuInternalName.Companion.toInternalName("ENCHANTED_ENDER_PEARL");
    @NotNull
    private static final NeuInternalName ENDER_PEARL = NeuInternalName.Companion.toInternalName("ENDER_PEARL");
    private static long lastScanned = SimpleTimeMark.Companion.farPast();

    private ProfitPerDragon() {
    }

    public final boolean getFinishedLoot() {
        return finishedLoot;
    }

    public final void setFinishedLoot(boolean bl) {
        finishedLoot = bl;
    }

    private final void scanForLoot() {
        Object this_$iv = EntityUtils.INSTANCE;
        boolean $i$f$getEntities = false;
        Sequence<Entity> $this$filterIsInstance$iv$iv = ((EntityUtils)this_$iv).getAllEntities();
        boolean $i$f$filterIsInstance = false;
        Sequence<Entity> sequence2 = SequencesKt.filter($this$filterIsInstance$iv$iv, scanForLoot$$inlined$getEntities$1.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence<Entity> entities = sequence2;
        scannedLootUUIDs.removeIf(arg_0 -> ProfitPerDragon.scanForLoot$lambda$2(arg_0 -> ProfitPerDragon.scanForLoot$lambda$1(entities, arg_0), arg_0));
        this_$iv = entities.iterator();
        while (this_$iv.hasNext()) {
            EntityArmorStand entity = (EntityArmorStand)this_$iv.next();
            String entityName = entity.func_70005_c_();
            Intrinsics.checkNotNull(entityName);
            String[] stringArray = new String[]{"\u00a78x"};
            Integer n = StringsKt.toIntOrNull((String)CollectionsKt.last(StringsKt.split$default((CharSequence)entityName, stringArray, false, 0, 6, null)));
            int amount = n != null ? n : 1;
            NeuInternalName internalNameFromEntityName = NeuInternalName.Companion.fromItemNameOrNull(entityName);
            if (!CollectionsKt.contains((Iterable)DragonProfitTracker.INSTANCE.getAllowedItems().keySet(), internalNameFromEntityName)) continue;
            if (internalNameFromEntityName == null) {
                ChatUtils.debug$default(ChatUtils.INSTANCE, "Could not find internal name for entity name: " + entityName, false, 2, null);
                continue;
            }
            if (scannedLootUUIDs.contains(entity.func_110124_au())) continue;
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Adding " + internalNameFromEntityName + " x" + amount + " to dragon loot", false, 2, null);
            CollectionUtils.INSTANCE.addOrPut(dragonLoot, internalNameFromEntityName, amount);
            UUID uUID = entity.func_110124_au();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueID(...)");
            scannedLootUUIDs.add(uUID);
        }
        if (!dragonLoot.isEmpty() && DragonFeatures.INSTANCE.getWeight() >= 290.0) {
            double weight = DragonFeatures.INSTANCE.getWeight();
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Weight: " + weight, false, 2, null);
            DragonProfitTrackerItemDataJson dragonProfitTrackerItemDataJson = DragonProfitTracker.INSTANCE.getAllowedItems().get(CollectionsKt.first((Iterable)dragonLoot.keySet()));
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Weight: " + (weight -= (double)(dragonProfitTrackerItemDataJson != null ? dragonProfitTrackerItemDataJson.getWeight() : 0)) + " after main drop (" + CollectionsKt.first((Iterable)dragonLoot.keySet()) + ')', false, 2, null);
            this.calculateNonUniqueLoot(weight);
        } else if (DragonFeatures.INSTANCE.getWeight() < 290.0) {
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Weight: " + DragonFeatures.INSTANCE.getWeight() + " < 290", false, 2, null);
            this.calculateNonUniqueLoot(DragonFeatures.INSTANCE.getWeight());
        }
    }

    private final void calculateNonUniqueLoot(double weightIn) {
        double weight = weightIn;
        DragonType dragonType = DragonProfitTracker.INSTANCE.getLastDragonKill();
        if (dragonType == null) {
            dragonType = DragonType.UNKNOWN;
        }
        DragonType type2 = dragonType;
        int fragmentWeight = 22;
        double fragAmount = Math.floor(weight / (double)fragmentWeight);
        ChatUtils.debug$default(ChatUtils.INSTANCE, "Weight: " + (weight -= fragAmount * (double)fragmentWeight) + " after frags(" + (int)fragAmount + " frags)", false, 2, null);
        if (type2 != DragonType.UNKNOWN) {
            CollectionUtils.INSTANCE.addOrPut(dragonLoot, type2.getFragment(), (int)fragAmount);
        }
        int enchantedEnderPearlWeight = 15;
        double enchantedEnderPearlAmount = Math.floor(weight / (double)enchantedEnderPearlWeight);
        weight -= enchantedEnderPearlAmount * (double)enchantedEnderPearlWeight;
        Integer n = DragonProfitTracker.INSTANCE.getLastDragonPlacement();
        ChatUtils.debug$default(ChatUtils.INSTANCE, "Weight: " + weight + " after enchanted ender pearls (" + (int)(enchantedEnderPearlAmount += (double)this.getStandardEnchantedEnderPearlAmount(n != null ? n : 0)) + " epearls)", false, 2, null);
        CollectionUtils.INSTANCE.addOrPut(dragonLoot, ENCHANTED_ENDER_PEARL, (int)enchantedEnderPearlAmount);
        int enderPearlWeight = 5;
        double enderPearlAmount = Math.floor(weight / (double)enderPearlWeight);
        weight -= enderPearlAmount * (double)enderPearlWeight;
        Integer n2 = DragonProfitTracker.INSTANCE.getLastDragonPlacement();
        ChatUtils.debug$default(ChatUtils.INSTANCE, "Weight: " + weight + " after ender pearls (" + (int)(enderPearlAmount += (double)this.getStandardEnderPearlAmount(n2 != null ? n2 : 0)) + " pearls)", false, 2, null);
        CollectionUtils.INSTANCE.addOrPut(dragonLoot, ENDER_PEARL, (int)enderPearlAmount);
        DragonProfitTracker.INSTANCE.addDragonLootFromList(type2, MapsKt.toList(dragonLoot));
        dragonLoot.clear();
        finishedLoot = true;
    }

    public final void reset() {
        scannedLootUUIDs.clear();
        dragonLoot.clear();
    }

    private final int getStandardEnderPearlAmount(int placement) {
        int n;
        switch (placement) {
            case 1: {
                n = 30;
                break;
            }
            case 2: {
                n = 25;
                break;
            }
            case 3: {
                n = 22;
                break;
            }
            case 4: {
                n = 20;
                break;
            }
            case 5: {
                n = 18;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n = 15;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n = 12;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n = 10;
                break;
            }
            default: {
                n = 5;
            }
        }
        return n;
    }

    private final int getStandardEnchantedEnderPearlAmount(int placement) {
        int n;
        switch (placement) {
            case 1: {
                n = 7;
                break;
            }
            case 2: {
                n = 6;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n = 2;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_END)
    public final void onTick(@NotNull SkyHanniTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastScanned), DurationKt.toDuration(1, DurationUnit.SECONDS)) >= 0 && !DragonFeatures.INSTANCE.getEggSpawned() && !finishedLoot) {
            this.scanForLoot();
            lastScanned = SimpleTimeMark.Companion.now-uFjCsEo();
        }
    }

    private static final boolean scanForLoot$lambda$1(Sequence $entities, UUID uuid) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($entities, "$entities");
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Sequence $this$none$iv = $entities;
            boolean $i$f$none = false;
            Iterator iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                EntityArmorStand it = (EntityArmorStand)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.func_110124_au(), uuid)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final boolean scanForLoot$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

