/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.rift;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.rift.RiftConfig;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.skyblock.GraphAreaChangeEvent;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u001b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001b\u0010\u0006J\r\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u0006J\r\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u0006J\r\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u0006J\r\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001f\u0010\u0006J\r\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010\u0006J\r\u0010!\u001a\u00020\u0004\u00a2\u0006\u0004\b!\u0010\u0006R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R.\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0017\u0010-\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u0010.R\u0017\u00102\u001a\u00020\u0004*\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\"\u00104\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u0010\u0006\"\u0004\b7\u00108R\u0016\u0010\u001e\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u00105R\"\u00109\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u00105\u001a\u0004\b:\u0010\u0006\"\u0004\b;\u00108R\"\u0010<\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u00105\u001a\u0004\b=\u0010\u0006\"\u0004\b>\u00108R\"\u0010?\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u00105\u001a\u0004\b@\u0010\u0006\"\u0004\bA\u00108R\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020C0B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010E\u00a8\u0006F"}, d2={"Lat/hannibal2/skyhanni/features/rift/RiftApi;", "", "<init>", "()V", "", "inRift", "()Z", "Lnet/minecraft/item/ItemStack;", "", "motesNpcPrice", "(Lnet/minecraft/item/ItemStack;)Ljava/lang/Double;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;)Ljava/lang/Double;", "Lat/hannibal2/skyhanni/events/skyblock/GraphAreaChangeEvent;", "event", "", "onAreaChange", "(Lat/hannibal2/skyhanni/events/skyblock/GraphAreaChangeEvent;)V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDeSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "inLivingCave", "inLivingStillness", "inStillgoreChateau", "inColosseum", "inDreadfarm", "inWestVillage", "inMountainTop", "Lat/hannibal2/skyhanni/config/features/rift/RiftConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/rift/RiftConfig;", "config", "", "motesPrice", "Ljava/util/Map;", "getMotesPrice", "()Ljava/util/Map;", "setMotesPrice", "(Ljava/util/Map;)V", "farmingTool", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "getFarmingTool", "()Lat/hannibal2/skyhanni/utils/NeuInternalName;", "blowgun", "isBlowgun", "(Lnet/minecraft/item/ItemStack;)Z", "inMirrorVerse", "Z", "getInMirrorVerse", "setInMirrorVerse", "(Z)V", "inRiftRace", "getInRiftRace", "setInRiftRace", "trackingButtons", "getTrackingButtons", "setTrackingButtons", "allButtonsHit", "getAllButtonsHit", "setAllButtonsHit", "", "Lat/hannibal2/skyhanni/data/mob/Mob;", "temporalPillars", "Ljava/util/List;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nRiftApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiftApi.kt\nat/hannibal2/skyhanni/features/rift/RiftApi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class RiftApi {
    @NotNull
    public static final RiftApi INSTANCE = new RiftApi();
    @NotNull
    private static Map<NeuInternalName, Double> motesPrice = MapsKt.emptyMap();
    @NotNull
    private static final NeuInternalName farmingTool = NeuInternalName.Companion.toInternalName("FARMING_WAND");
    @NotNull
    private static final NeuInternalName blowgun = NeuInternalName.Companion.toInternalName("BERBERIS_BLOWGUN");
    private static boolean inMirrorVerse;
    private static boolean inColosseum;
    private static boolean inRiftRace;
    private static boolean trackingButtons;
    private static boolean allButtonsHit;
    @NotNull
    private static final List<Mob> temporalPillars;

    private RiftApi() {
    }

    public final boolean inRift() {
        return IslandType.THE_RIFT.isCurrent();
    }

    @NotNull
    public final RiftConfig getConfig() {
        return SkyHanniMod.feature.getRift();
    }

    @NotNull
    public final Map<NeuInternalName, Double> getMotesPrice() {
        return motesPrice;
    }

    public final void setMotesPrice(@NotNull Map<NeuInternalName, Double> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        motesPrice = map2;
    }

    @NotNull
    public final NeuInternalName getFarmingTool() {
        return farmingTool;
    }

    public final boolean isBlowgun(@Nullable ItemStack $this$isBlowgun) {
        ItemStack itemStack = $this$isBlowgun;
        return Intrinsics.areEqual(itemStack != null ? ItemUtils.INSTANCE.getInternalName(itemStack) : null, blowgun);
    }

    @Nullable
    public final Double motesNpcPrice(@NotNull ItemStack $this$motesNpcPrice) {
        Intrinsics.checkNotNullParameter($this$motesNpcPrice, "<this>");
        if (SkyBlockItemModifierUtils.INSTANCE.isRiftExportable($this$motesNpcPrice) && SkyBlockItemModifierUtils.INSTANCE.wasRiftTransferred($this$motesNpcPrice)) {
            return null;
        }
        Double d = this.motesNpcPrice(ItemUtils.INSTANCE.getInternalName($this$motesNpcPrice));
        return d != null ? Double.valueOf(d * (double)$this$motesNpcPrice.field_77994_a) : null;
    }

    @Nullable
    public final Double motesNpcPrice(@NotNull NeuInternalName $this$motesNpcPrice) {
        Intrinsics.checkNotNullParameter($this$motesNpcPrice, "<this>");
        Double d = motesPrice.get($this$motesNpcPrice);
        if (d == null) {
            return null;
        }
        double baseMotes = d;
        int burgerStacks = this.getConfig().getMotes().getBurgerStacks();
        return baseMotes + (double)(burgerStacks * 5) * baseMotes / (double)100;
    }

    public final boolean getInMirrorVerse() {
        return inMirrorVerse;
    }

    public final void setInMirrorVerse(boolean bl) {
        inMirrorVerse = bl;
    }

    public final boolean getInRiftRace() {
        return inRiftRace;
    }

    public final void setInRiftRace(boolean bl) {
        inRiftRace = bl;
    }

    public final boolean getTrackingButtons() {
        return trackingButtons;
    }

    public final void setTrackingButtons(boolean bl) {
        trackingButtons = bl;
    }

    public final boolean getAllButtonsHit() {
        return allButtonsHit;
    }

    public final void setAllButtonsHit(boolean bl) {
        allButtonsHit = bl;
    }

    @HandleEvent
    public final void onAreaChange(@NotNull GraphAreaChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        inMirrorVerse = Intrinsics.areEqual(event.getArea(), "Mirrorverse");
        inColosseum = Intrinsics.areEqual(event.getArea(), "Colosseum");
    }

    @HandleEvent
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (Intrinsics.areEqual(event.getMob().getName(), "Temporal Pillar")) {
            temporalPillars.add(event.getMob());
        }
    }

    @HandleEvent
    public final void onMobDeSpawn(@NotNull MobEvent.DeSpawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (Intrinsics.areEqual(event.getMob().getName(), "Temporal Pillar")) {
            temporalPillars.remove(event.getMob());
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getTemporalPillarDodge()) {
            if (Intrinsics.areEqual(IslandGraphs.INSTANCE.getDisabledNodesReason(), "Temporal Pillar")) {
                IslandGraphs.INSTANCE.enableAllNodes();
            }
            return;
        }
        String string = IslandGraphs.INSTANCE.getDisabledNodesReason();
        if (string != null) {
            String it = string;
            boolean bl = false;
            IslandGraphs.INSTANCE.enableAllNodes();
            if (temporalPillars.isEmpty()) {
                IslandGraphs.INSTANCE.update(true);
            }
        }
        if (!((Collection)temporalPillars).isEmpty()) {
            for (Mob mob : temporalPillars) {
                LorenzVec location = LorenzVecKt.getLorenzVec((Entity)mob.getBaseEntity());
                IslandGraphs.INSTANCE.disableNodes("Temporal Pillar", location, 7.0);
            }
            IslandGraphs.INSTANCE.update(true);
        }
    }

    public final boolean inLivingCave() {
        return Intrinsics.areEqual(SkyBlockUtils.INSTANCE.getScoreboardArea(), "Living Cave");
    }

    public final boolean inLivingStillness() {
        return Intrinsics.areEqual(SkyBlockUtils.INSTANCE.getScoreboardArea(), "Living Stillness");
    }

    public final boolean inStillgoreChateau() {
        String it = SkyBlockUtils.INSTANCE.getScoreboardArea();
        boolean bl = false;
        return Intrinsics.areEqual(it, "Stillgore Ch\u00e2teau") || Intrinsics.areEqual(it, "Oubliette");
    }

    public final boolean inColosseum() {
        return Intrinsics.areEqual(SkyBlockUtils.INSTANCE.getScoreboardArea(), "Colosseum") || inColosseum;
    }

    public final boolean inDreadfarm() {
        return Intrinsics.areEqual(SkyBlockUtils.INSTANCE.getScoreboardArea(), "Dreadfarm");
    }

    public final boolean inWestVillage() {
        String it = SkyBlockUtils.INSTANCE.getScoreboardArea();
        boolean bl = false;
        return Intrinsics.areEqual(it, "West Village") || Intrinsics.areEqual(it, "Infested House");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean inMountainTop() {
        String string = SkyBlockUtils.INSTANCE.getScoreboardArea();
        if (string == null) return false;
        switch (string.hashCode()) {
            case 1600555638: {
                if (string.equals("Continuum")) return true;
                return false;
            }
            case 89905643: {
                if (string.equals("Wizardman Bureau")) return true;
                return false;
            }
            case 1858211249: {
                if (string.equals("Wizard Brawl")) return true;
                return false;
            }
            case 209529401: {
                if (string.equals("The Mountaintop")) return true;
                return false;
            }
            case 1333089410: {
                if (string.equals("Trial Grounds")) return true;
                return false;
            }
            case -1417091803: {
                if (string.equals("Walk of Fame")) return true;
                return false;
            }
            case -1513776821: {
                if (string.equals("Time Chamber")) return true;
                return false;
            }
            case -1931976665: {
                if (!string.equals("Time-Torn Isles")) return false;
                return true;
            }
        }
        return false;
    }

    static {
        temporalPillars = new ArrayList();
    }
}

