/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSignatureBuildingComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureBuildingComponents.kt\norg/jetbrains/kotlin/load/kotlin/SignatureBuildingComponents\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,39:1\n11065#2:40\n11400#2,3:41\n11400#2,3:46\n37#3,2:44\n*S KotlinDebug\n*F\n+ 1 SignatureBuildingComponents.kt\norg/jetbrains/kotlin/load/kotlin/SignatureBuildingComponents\n*L\n20#1:40\n20#1:41,3\n25#1:46,3\n20#1:44,2\n*E\n"})
public final class SignatureBuildingComponents {
    @NotNull
    public static final SignatureBuildingComponents INSTANCE = new SignatureBuildingComponents();

    private SignatureBuildingComponents() {
    }

    @NotNull
    public final String javaLang(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "java/lang/" + name2;
    }

    @NotNull
    public final String javaUtil(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "java/util/" + name2;
    }

    @NotNull
    public final String javaFunction(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "java/util/function/" + name2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] constructors(String ... signatures) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(signatures, "signatures");
        String[] $this$map$iv = signatures;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("<init>(" + (String)it + ")V");
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public final Set<String> inJavaLang(@NotNull String name2, String ... signatures) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(signatures, "signatures");
        return this.inClass(this.javaLang(name2), Arrays.copyOf(signatures, signatures.length));
    }

    @NotNull
    public final Set<String> inJavaUtil(@NotNull String name2, String ... signatures) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(signatures, "signatures");
        return this.inClass(this.javaUtil(name2), Arrays.copyOf(signatures, signatures.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> inClass(@NotNull String internalName2, String ... signatures) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(internalName2, "internalName");
        Intrinsics.checkNotNullParameter(signatures, "signatures");
        String[] stringArray = signatures;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv;
            void var9_9 = item$iv = $this$mapTo$iv[j];
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(internalName2 + '.' + (String)it);
        }
        return (Set)destination$iv;
    }

    @NotNull
    public final String signature(@NotNull String internalName2, @NotNull String jvmDescriptor2) {
        Intrinsics.checkNotNullParameter(internalName2, "internalName");
        Intrinsics.checkNotNullParameter(jvmDescriptor2, "jvmDescriptor");
        return internalName2 + '.' + jvmDescriptor2;
    }

    @NotNull
    public final String jvmDescriptor(@NotNull String name2, @NotNull List<String> parameters2, @NotNull String ret) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(ret, "ret");
        return name2 + '(' + CollectionsKt.joinToString$default(parameters2, "", null, null, 0, null, jvmDescriptor.1.INSTANCE, 30, null) + ')' + this.escapeClassName(ret);
    }

    private final String escapeClassName(String internalName2) {
        return internalName2.length() > 1 ? 'L' + internalName2 + ';' : internalName2;
    }

    public static final /* synthetic */ String access$escapeClassName(SignatureBuildingComponents $this, String internalName2) {
        return $this.escapeClassName(internalName2);
    }
}

