/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.minecraftevents;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.ActionBarData;
import at.hannibal2.skyhanni.data.ChatManager;
import at.hannibal2.skyhanni.events.minecraft.ClientDisconnectEvent;
import at.hannibal2.skyhanni.events.minecraft.ResourcePackReloadEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.events.minecraft.WorldChangeEvent;
import at.hannibal2.skyhanni.events.player.ClickAction;
import at.hannibal2.skyhanni.events.player.PlayerInteractionEvent;
import at.hannibal2.skyhanni.events.utils.PreInitFinishedEvent;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00188\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/api/minecraftevents/ClientEvents;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/utils/PreInitFinishedEvent;", "event", "", "onInitialize", "(Lat/hannibal2/skyhanni/events/utils/PreInitFinishedEvent;)V", "Lnet/minecraftforge/fml/common/network/FMLNetworkEvent$ClientDisconnectionFromServerEvent;", "onDisconnect", "(Lnet/minecraftforge/fml/common/network/FMLNetworkEvent$ClientDisconnectionFromServerEvent;)V", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "onWorldChange", "(Lnet/minecraftforge/event/world/WorldEvent$Load;)V", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "onTick", "(Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;)V", "Lnet/minecraftforge/client/event/ClientChatReceivedEvent;", "onChatReceive", "(Lnet/minecraftforge/client/event/ClientChatReceivedEvent;)V", "Lnet/minecraftforge/event/entity/player/PlayerInteractEvent;", "onPlayerInteract", "(Lnet/minecraftforge/event/entity/player/PlayerInteractEvent;)V", "", "value", "totalTicks", "I", "getTotalTicks", "()I", "1.8.9"})
public final class ClientEvents {
    @NotNull
    public static final ClientEvents INSTANCE = new ClientEvents();
    private static int totalTicks;

    private ClientEvents() {
    }

    @HandleEvent
    public final void onInitialize(@NotNull PreInitFinishedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        IResourceManager minecraftResourceManager = Minecraft.func_71410_x().func_110442_L();
        if (minecraftResourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)minecraftResourceManager).func_110542_a(ClientEvents::onInitialize$lambda$0);
            new ResourcePackReloadEvent(minecraftResourceManager).post();
        }
    }

    @SubscribeEvent
    public final void onDisconnect(@NotNull FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ClientDisconnectEvent.INSTANCE.post();
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull WorldEvent.Load event) {
        Intrinsics.checkNotNullParameter(event, "event");
        new WorldChangeEvent().post();
    }

    public final int getTotalTicks() {
        return totalTicks;
    }

    @SubscribeEvent
    public final void onTick(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!MinecraftCompat.INSTANCE.getLocalPlayerExists()) {
            return;
        }
        if (!MinecraftCompat.INSTANCE.getLocalWorldExists()) {
            return;
        }
        DelayedRun.INSTANCE.checkRuns();
        int n = totalTicks;
        totalTicks = n + 1;
        new SkyHanniTickEvent(totalTicks).post();
    }

    @SubscribeEvent(receiveCanceled=true)
    public final void onChatReceive(@NotNull ClientChatReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.type == 2) {
            IChatComponent iChatComponent = event.message;
            Intrinsics.checkNotNullExpressionValue(iChatComponent, "message");
            IChatComponent iChatComponent2 = ActionBarData.INSTANCE.onChatReceive(iChatComponent);
            if (iChatComponent2 != null) {
                IChatComponent result2 = iChatComponent2;
                boolean bl = false;
                event.message = result2;
            }
        } else {
            IChatComponent iChatComponent = event.message;
            Intrinsics.checkNotNullExpressionValue(iChatComponent, "message");
            Pair<IChatComponent, Boolean> pair = ChatManager.INSTANCE.onChatReceive(iChatComponent);
            IChatComponent result3 = pair.component1();
            boolean cancel = pair.component2();
            IChatComponent iChatComponent3 = result3;
            if (iChatComponent3 != null) {
                IChatComponent it = iChatComponent3;
                boolean bl = false;
                event.message = it;
            }
            if (cancel) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        PlayerInteractEvent.Action action = event.action;
        Intrinsics.checkNotNullExpressionValue(action, "action");
        new PlayerInteractionEvent(ClickAction.Companion.fromForge(action), event.pos, event.face).post();
    }

    private static final void onInitialize$lambda$0(IResourceManager resourceManager) {
        Intrinsics.checkNotNull(resourceManager);
        new ResourcePackReloadEvent(resourceManager).post();
    }
}

