/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.internal;

import at.hannibal2.skyhanni.deps.moulconfig.internal.MathUtil;

public class LerpingInteger2 {
    private int value;
    private int target;
    private final int speed;
    private final int scale;
    private long lastUpdate = System.currentTimeMillis();

    public LerpingInteger2(int value, int speed, int scale) {
        this.value = this.target = value;
        this.speed = speed;
        this.scale = scale;
    }

    public void setTarget(int target) {
        this.target = target * this.scale;
    }

    public void update() {
        int d = this.target - this.value;
        long currentTime = System.currentTimeMillis();
        int distance = (int)(currentTime - this.lastUpdate) * this.speed;
        this.lastUpdate = currentTime;
        this.value += MathUtil.copySign(d, Math.min(distance, Math.abs(d)));
    }

    public int getValue() {
        this.update();
        return this.value / this.scale;
    }

    public String toString() {
        return "LerpingInteger2(value=" + this.getValue() + ", target=" + this.target + ", speed=" + this.speed + ", scale=" + this.scale + ", lastUpdate=" + this.lastUpdate + ")";
    }
}

