/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.Features;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.data.NotificationManager;
import at.hannibal2.skyhanni.data.SkyHanniNotification;
import at.hannibal2.skyhanni.events.hypixel.HypixelJoinEvent;
import at.hannibal2.skyhanni.test.SkyHanniConfigSearchResetCommand;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LorenzLogger;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.json.Shimmy;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0017\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dR(\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/config/UpdateKeybinds;", "", "<init>", "()V", "", "", "makeMap", "()Ljava/util/Map;", "", "shouldFlip", "", "fixKeybinds", "(Z)V", "", "keybind", "Lkotlin/Pair;", "Lat/hannibal2/skyhanni/utils/json/Shimmy;", "readKeybindConfig", "(Ljava/lang/String;)Lkotlin/Pair;", "Lat/hannibal2/skyhanni/events/hypixel/HypixelJoinEvent;", "event", "onTick", "(Lat/hannibal2/skyhanni/events/hypixel/HypixelJoinEvent;)V", "tryFixLegacyKeybinds", "key", "resetKeybind", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "keybinds", "Ljava/util/Set;", "getKeybinds", "()Ljava/util/Set;", "setKeybinds", "(Ljava/util/Set;)V", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "logger", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "hasUpdated", "Z", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nUpdateKeybinds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateKeybinds.kt\nat/hannibal2/skyhanni/config/UpdateKeybinds\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n1222#2,2:255\n1252#2,4:257\n*S KotlinDebug\n*F\n+ 1 UpdateKeybinds.kt\nat/hannibal2/skyhanni/config/UpdateKeybinds\n*L\n155#1:255,2\n155#1:257,4\n*E\n"})
public final class UpdateKeybinds {
    @NotNull
    public static final UpdateKeybinds INSTANCE = new UpdateKeybinds();
    @NotNull
    private static Set<String> keybinds = new LinkedHashSet();
    @NotNull
    private static final LorenzLogger logger = new LorenzLogger("keybind_upgrader");
    private static boolean hasUpdated;

    private UpdateKeybinds() {
    }

    private final Map<Integer, Integer> makeMap() {
        Map map = new LinkedHashMap();
        map.put(0, -1);
        map.put(11, 48);
        map.put(2, 49);
        map.put(3, 50);
        map.put(4, 51);
        map.put(5, 52);
        map.put(6, 53);
        map.put(7, 54);
        map.put(8, 55);
        map.put(9, 56);
        map.put(10, 57);
        map.put(30, 65);
        map.put(40, 39);
        map.put(48, 66);
        map.put(43, 92);
        map.put(14, 259);
        map.put(46, 67);
        map.put(58, 280);
        map.put(51, 44);
        map.put(32, 68);
        map.put(211, 261);
        map.put(208, 264);
        map.put(18, 69);
        map.put(207, 269);
        map.put(28, 257);
        map.put(13, 61);
        map.put(1, 256);
        map.put(33, 70);
        map.put(59, 290);
        map.put(68, 299);
        map.put(87, 300);
        map.put(88, 301);
        map.put(100, 302);
        map.put(101, 303);
        map.put(102, 304);
        map.put(103, 305);
        map.put(104, 306);
        map.put(105, 307);
        map.put(113, 308);
        map.put(60, 291);
        map.put(61, 292);
        map.put(62, 293);
        map.put(63, 294);
        map.put(64, 295);
        map.put(65, 296);
        map.put(66, 297);
        map.put(67, 298);
        map.put(34, 71);
        map.put(41, 96);
        map.put(35, 72);
        map.put(199, 268);
        map.put(23, 73);
        map.put(210, 260);
        map.put(36, 74);
        map.put(37, 75);
        map.put(82, 320);
        map.put(79, 321);
        map.put(80, 322);
        map.put(81, 323);
        map.put(75, 324);
        map.put(76, 325);
        map.put(77, 326);
        map.put(71, 327);
        map.put(72, 328);
        map.put(73, 329);
        map.put(78, 334);
        map.put(83, 330);
        map.put(181, 331);
        map.put(156, 335);
        map.put(141, 336);
        map.put(55, 332);
        map.put(74, 333);
        map.put(38, 76);
        map.put(203, 263);
        map.put(56, 342);
        map.put(26, 91);
        map.put(29, 341);
        map.put(42, 340);
        map.put(219, 343);
        map.put(50, 77);
        map.put(12, 45);
        map.put(49, 78);
        map.put(69, 282);
        map.put(24, 79);
        map.put(25, 80);
        map.put(209, 267);
        map.put(201, 266);
        map.put(197, 284);
        map.put(52, 46);
        map.put(183, 283);
        map.put(16, 81);
        map.put(19, 82);
        map.put(205, 262);
        map.put(184, 346);
        map.put(27, 93);
        map.put(157, 345);
        map.put(54, 344);
        map.put(220, 347);
        map.put(31, 83);
        map.put(70, 281);
        map.put(39, 59);
        map.put(53, 47);
        map.put(57, 32);
        map.put(20, 84);
        map.put(15, 258);
        map.put(22, 85);
        map.put(200, 265);
        map.put(47, 86);
        map.put(17, 87);
        map.put(45, 88);
        map.put(21, 89);
        map.put(44, 90);
        map.put(-100, 0);
        map.put(-99, 1);
        map.put(-98, 2);
        map.put(-97, 3);
        map.put(-96, 4);
        return map;
    }

    @NotNull
    public final Set<String> getKeybinds() {
        return keybinds;
    }

    public final void setKeybinds(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        keybinds = set;
    }

    /*
     * WARNING - void declaration
     */
    private final void fixKeybinds(boolean shouldFlip) {
        Pair<Shimmy, Integer> pair;
        Map keybindMap = this.makeMap();
        if (shouldFlip) {
            void $this$associateByTo$iv$iv;
            Pair<Shimmy, Integer> $this$associateBy$iv = (Pair<Shimmy, Integer>)keybindMap.entrySet();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            pair = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Map.Entry it = (Map.Entry)element$iv$iv;
                Integer n = ((Number)it.getValue()).intValue();
                boolean bl2 = false;
                Integer n2 = ((Number)it.getKey()).intValue();
                map.put(n, n2);
            }
            keybindMap = destination$iv$iv;
        }
        boolean shouldNotify = false;
        for (String keybind : keybinds) {
            if (this.readKeybindConfig(keybind) == null) continue;
            Shimmy shimmy = (Shimmy)pair.component1();
            int currentValue = ((Number)pair.component2()).intValue();
            if (keybindMap.containsKey(currentValue)) {
                Integer newValue = (Integer)keybindMap.get(currentValue);
                shimmy.set(newValue);
                logger.log(keybind + " old " + currentValue);
                logger.log(keybind + " new " + newValue);
                continue;
            }
            shouldNotify = true;
            this.resetKeybind(keybind);
            logger.log("Couldn't find a mapping for " + keybind + " value: " + currentValue);
            SimpleTimeMark.box-impl(DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS), (Function0<Unit>)((Function0)() -> UpdateKeybinds.fixKeybinds$lambda$2(keybind))));
        }
        if (shouldNotify) {
            Object[] objectArray = new String[]{"\u00a7c\u00a7lMissing Keybind Mapping Data", "\u00a7cData used to convert your skyhanni keybinds between versions is outdated", "\u00a7cPlease join the SkyHanni Discord and message in \u00a7l#support\u00a7r\u00a7c to get support."};
            List text = CollectionsKt.listOf((Object[])objectArray);
            NotificationManager.INSTANCE.queueNotification(new SkyHanniNotification(text, Duration.Companion.getINFINITE-UwyO8pc(), false, null));
        }
    }

    private final Pair<Shimmy, Integer> readKeybindConfig(String keybind) {
        String[] stringArray = new String[]{"."};
        Shimmy shimmy = Shimmy.Companion.makeShimmy(SkyHanniMod.feature, StringsKt.split$default((CharSequence)keybind, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (shimmy == null) {
            try {
                ErrorManager.INSTANCE.skyHanniError("Could not create shimmy for path " + keybind, new Pair[0]);
                throw new KotlinNothingValueException();
            }
            catch (Exception exception) {
                return null;
            }
        }
        Shimmy shimmy2 = shimmy;
        return TuplesKt.to((Object)shimmy2, (Object)shimmy2.getJson().getAsInt());
    }

    @HandleEvent(priority=-1)
    public final void onTick(@NotNull HypixelJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (hasUpdated) {
            return;
        }
        hasUpdated = true;
        Features config = SkyHanniMod.feature;
        String string = config.getLastMinecraftVersion();
        if (string == null) {
            string = "1.8.9";
        }
        String lastMcVersion = string;
        String currentMcVersion = PlatformUtils.INSTANCE.getMC_VERSION();
        config.setLastMinecraftVersion(currentMcVersion);
        if (!config.getStorage().getHasPlayedBefore()) {
            return;
        }
        if (Intrinsics.areEqual((Object)lastMcVersion, (Object)currentMcVersion) || !Intrinsics.areEqual((Object)lastMcVersion, (Object)"1.8.9") && !Intrinsics.areEqual((Object)currentMcVersion, (Object)"1.8.9")) {
            this.tryFixLegacyKeybinds();
            return;
        }
        this.fixKeybinds(!Intrinsics.areEqual((Object)lastMcVersion, (Object)"1.8.9"));
    }

    private final void tryFixLegacyKeybinds() {
        if (!PlatformUtils.INSTANCE.getIS_LEGACY()) {
            return;
        }
        for (String keybind : keybinds) {
            int currentValue;
            Pair<Shimmy, Integer> pair = this.readKeybindConfig(keybind);
            if (pair == null || (currentValue = ((Number)pair.component2()).intValue()) < 255) continue;
            String[] stringArray = new String[]{"reset", "config." + keybind};
            SkyHanniConfigSearchResetCommand.INSTANCE.resetCommand(stringArray);
            logger.log(keybind + " old " + currentValue);
            logger.log(keybind + " resetting to default because it was above 255 on 1.8");
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS), (Function0<Unit>)((Function0)() -> UpdateKeybinds.tryFixLegacyKeybinds$lambda$3(keybind)));
        }
    }

    private final void resetKeybind(String key) {
        String[] stringArray = new String[]{"reset", "config." + key};
        SkyHanniConfigSearchResetCommand.INSTANCE.resetCommand(stringArray);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.registerBrigadier("shresetkeybinds", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)UpdateKeybinds::onCommandRegistration$lambda$5));
    }

    private static final Unit fixKeybinds$lambda$2(String $keybind) {
        Intrinsics.checkNotNullParameter((Object)$keybind, (String)"$keybind");
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Could not convert keybind for " + $keybind + ", please set it manually in /sh", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit tryFixLegacyKeybinds$lambda$3(String $keybind) {
        Intrinsics.checkNotNullParameter((Object)$keybind, (String)"$keybind");
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Keybind " + $keybind + " was invalid and it has been reset, please set it manually in /sh", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$5$lambda$4() {
        for (String keybind : keybinds) {
            INSTANCE.resetKeybind(keybind);
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aSuccessfully reset all SkyHanni Keybinds", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$5(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_RESET);
        $this$registerBrigadier.setDescription("Resets all of your skyhanni keybinds");
        $this$registerBrigadier.setAliases(CollectionsKt.listOf((Object)"shkeybindreset"));
        $this$registerBrigadier.simpleCallback((Function0<Unit>)((Function0)UpdateKeybinds::onCommandRegistration$lambda$5$lambda$4));
        return Unit.INSTANCE;
    }
}

