/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.component;

import at.hannibal2.skyhanni.deps.moulconfig.common.IFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.observer.GetSetter;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 !2\u00020\u0001:\u0001!B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001a\u001a\u0004\b\u001d\u0010\u001cR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lat/hannibal2/skyhanni/deps/moulconfig/gui/component/CollapsibleComponent;", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiComponent;", "Ljava/util/function/Supplier;", "title", "body", "Lat/hannibal2/skyhanni/deps/moulconfig/observer/GetSetter;", "", "collapsedState", "<init>", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Lio/github/notenoughupdates/moulconfig/observer/GetSetter;)V", "", "getWidth", "()I", "getHeight", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiImmediateContext;", "context", "", "render", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)V", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/MouseEvent;", "mouseEvent", "(Lio/github/notenoughupdates/moulconfig/gui/MouseEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/KeyboardEvent;", "event", "keyboardEvent", "(Lio/github/notenoughupdates/moulconfig/gui/KeyboardEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Ljava/util/function/Supplier;", "getTitle", "()Ljava/util/function/Supplier;", "getBody", "Lat/hannibal2/skyhanni/deps/moulconfig/observer/GetSetter;", "getCollapsedState", "()Lio/github/notenoughupdates/moulconfig/observer/GetSetter;", "Companion", "common"})
public final class CollapsibleComponent
extends GuiComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<GuiComponent> title;
    @NotNull
    private final Supplier<GuiComponent> body;
    @NotNull
    private final GetSetter<Boolean> collapsedState;
    private static final IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
    private static final int padding = 2;
    private static final int trim = 3;
    private static final int iconWidth = 9;

    public CollapsibleComponent(@NotNull Supplier<GuiComponent> title, @NotNull Supplier<GuiComponent> body, @NotNull GetSetter<Boolean> collapsedState) {
        Intrinsics.checkNotNullParameter(title, (String)"title");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Intrinsics.checkNotNullParameter(collapsedState, (String)"collapsedState");
        this.title = title;
        this.body = body;
        this.collapsedState = collapsedState;
    }

    public /* synthetic */ CollapsibleComponent(Supplier supplier, Supplier supplier2, GetSetter getSetter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            getSetter = GetSetter.floating(true);
        }
        this(supplier, supplier2, getSetter);
    }

    @NotNull
    public final Supplier<GuiComponent> getTitle() {
        return this.title;
    }

    @NotNull
    public final Supplier<GuiComponent> getBody() {
        return this.body;
    }

    @NotNull
    public final GetSetter<Boolean> getCollapsedState() {
        return this.collapsedState;
    }

    @Override
    public int getWidth() {
        return Math.max(this.title.get().getWidth() + padding + iconWidth, this.body.get().getWidth());
    }

    @Override
    public int getHeight() {
        return this.collapsedState.get() != false ? Math.max(this.title.get().getHeight(), fr.getHeight()) : Math.max(this.title.get().getHeight(), fr.getHeight()) + trim + this.body.get().getHeight();
    }

    @Override
    public void render(@NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Boolean collapsed = this.collapsedState.get();
        context2.getRenderContext().drawOpenCloseTriangle(collapsed == false, 0.0f, 0.0f, iconWidth, iconWidth, -1);
        int barHeight = Math.max(this.title.get().getHeight(), fr.getHeight());
        context2.getRenderContext().pushMatrix();
        context2.getRenderContext().translate(iconWidth, 0.0f);
        this.title.get().render(context2.translated(iconWidth, 0, context2.getWidth() - iconWidth, barHeight));
        context2.getRenderContext().popMatrix();
        if (!collapsed.booleanValue()) {
            context2.getRenderContext().drawColoredRect(0.0f, (float)barHeight + 1.0f, context2.getWidth(), (float)barHeight + 2.0f, -16777216);
            context2.getRenderContext().pushMatrix();
            context2.getRenderContext().translate(0.0f, barHeight);
            this.body.get().render(context2.translated(0, barHeight, context2.getWidth(), context2.getHeight() - barHeight));
            context2.getRenderContext().popMatrix();
        }
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        int barHeight = Math.max(this.title.get().getHeight(), fr.getHeight());
        if (mouseEvent instanceof MouseEvent.Click && context2.translated(0, 0, context2.getWidth(), barHeight).isHovered()) {
            if (((MouseEvent.Click)mouseEvent).getMouseState()) {
                this.collapsedState.set(this.collapsedState.get() == false);
            }
            return true;
        }
        return this.title.get().mouseEvent(mouseEvent, context2.translated(iconWidth, 0, context2.getWidth() - iconWidth, barHeight)) || this.body.get().mouseEvent(mouseEvent, context2.translated(0, barHeight, context2.getWidth(), context2.getHeight() - barHeight));
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        int barHeight = Math.max(this.title.get().getHeight(), fr.getHeight());
        return this.title.get().keyboardEvent(event, context2.translated(iconWidth, 0, context2.getWidth() - iconWidth, barHeight)) || this.body.get().keyboardEvent(event, context2.translated(0, barHeight, context2.getWidth(), context2.getHeight() - barHeight));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\u00020\n8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\n8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\n8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lat/hannibal2/skyhanni/deps/moulconfig/gui/component/CollapsibleComponent$Companion;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/deps/moulconfig/common/IFontRenderer;", "kotlin.jvm.PlatformType", "fr", "Lat/hannibal2/skyhanni/deps/moulconfig/common/IFontRenderer;", "getFr", "()Lio/github/notenoughupdates/moulconfig/common/IFontRenderer;", "", "padding", "I", "getPadding", "()I", "trim", "getTrim", "iconWidth", "getIconWidth", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final IFontRenderer getFr() {
            return fr;
        }

        public final int getPadding() {
            return padding;
        }

        public final int getTrim() {
            return trim;
        }

        public final int getIconWidth() {
            return iconWidth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

