/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.dungeon.HighlightClickedBlocksConfig;
import at.hannibal2.skyhanni.data.ClickedBlockType;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonBlockClickEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.ExtendedChatColor;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.collection.TimeLimitedCache;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00029:B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010 \u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001b\u0010)\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001b\u0010,\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010&\u001a\u0004\b+\u0010(R \u00100\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00103\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u0004058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\u0004058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00107\u00a8\u0006;"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "getRandomColor", "()Lat/hannibal2/skyhanni/utils/LorenzColor;", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/dungeon/DungeonBlockClickEvent;", "onDungeonClickedBlock", "(Lat/hannibal2/skyhanni/events/dungeon/DungeonBlockClickEvent;)V", "Lat/hannibal2/skyhanni/data/ClickedBlockType;", "type", "Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$BlockProperties;", "getBlockProperties", "(Lat/hannibal2/skyhanni/data/ClickedBlockType;)Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$BlockProperties;", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/dungeon/HighlightClickedBlocksConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/HighlightClickedBlocksConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "leverPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getLeverPattern", "()Ljava/util/regex/Pattern;", "leverPattern", "lockedPattern$delegate", "getLockedPattern", "lockedPattern", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$ClickedBlock;", "blocks", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "", "colorIndex", "I", "", "undesirableColors", "Ljava/util/List;", "randomColors", "ClickedBlock", "BlockProperties", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nDungeonHighlightClickedBlocks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonHighlightClickedBlocks.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,114:1\n528#2,7:115\n774#2:124\n865#2,2:125\n216#3,2:122\n*S KotlinDebug\n*F\n+ 1 DungeonHighlightClickedBlocks.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks\n*L\n65#1:115,7\n47#1:124\n47#1:125,2\n95#1:122,2\n*E\n"})
public final class DungeonHighlightClickedBlocks {
    @NotNull
    public static final DungeonHighlightClickedBlocks INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern leverPattern$delegate;
    @NotNull
    private static final RepoPattern lockedPattern$delegate;
    @NotNull
    private static final TimeLimitedCache<LorenzVec, ClickedBlock> blocks;
    private static int colorIndex;
    @NotNull
    private static final List<LorenzColor> undesirableColors;
    @NotNull
    private static final List<LorenzColor> randomColors;

    private DungeonHighlightClickedBlocks() {
    }

    private final HighlightClickedBlocksConfig getConfig() {
        return SkyHanniMod.feature.getDungeon().getClickedBlocks();
    }

    private final Pattern getLeverPattern() {
        return (Pattern)leverPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getLockedPattern() {
        return (Pattern)lockedPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final LorenzColor getRandomColor() {
        int id = colorIndex + 1;
        if (id == randomColors.size()) {
            id = 0;
        }
        colorIndex = id;
        return randomColors.get(colorIndex);
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.isEnabled()) {
                return;
            }
            if (RegexUtils.INSTANCE.matches(this.getLeverPattern(), event.getMessage())) {
                event.setBlockedReason("dungeon_highlight_clicked_block");
            }
            if (!RegexUtils.INSTANCE.matches(this.getLockedPattern(), event.getMessage())) break block4;
            Iterable $this$lastOrNull$iv = blocks.values();
            boolean $i$f$lastOrNull = false;
            Object last$iv = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                ClickedBlock it = (ClickedBlock)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it.getDisplayText(), (CharSequence)"Chest", (boolean)false, (int)2, null)) continue;
                last$iv = element$iv;
            }
            ClickedBlock clickedBlock = last$iv;
            if (clickedBlock != null) {
                clickedBlock.setColor(this.getConfig().getLockedChestColor());
            }
        }
    }

    @HandleEvent
    public final void onDungeonClickedBlock(@NotNull DungeonBlockClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (DungeonApi.INSTANCE.getInWaterRoom() && event.getBlockType() == ClickedBlockType.LEVER) {
            return;
        }
        ClickedBlockType type2 = event.getBlockType();
        ChromaColour color = this.getConfig().getRandomColor() ? LorenzColor.toChromaColor$default(this.getRandomColor(), 0, 0, 3, null) : this.getBlockProperties(type2).getColor();
        String displayText = new ExtendedChatColor(ColorUtils.INSTANCE.getRgb(color), false) + "Clicked " + this.getBlockProperties(type2).getName();
        blocks.set(event.getPosition(), new ClickedBlock(displayText, color));
    }

    private final BlockProperties getBlockProperties(ClickedBlockType type2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> new BlockProperties("Lever", this.getConfig().getLeverColor());
            case 2 -> new BlockProperties("Chest", this.getConfig().getChestColor());
            case 3 -> new BlockProperties("Trapped Chest", this.getConfig().getTrappedChestColor());
            case 4 -> new BlockProperties("Wither Essence", this.getConfig().getWitherEssenceColor());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        Map $this$forEach$iv = blocks;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            LorenzVec position = (LorenzVec)entry.getKey();
            ClickedBlock block = (ClickedBlock)entry.getValue();
            WorldRenderUtils.drawColor$default(WorldRenderUtils.INSTANCE, event, position, block.getColor(), false, 0.0f, false, 28, null);
            if (!INSTANCE.getConfig().getShowText()) continue;
            WorldRenderUtils.drawString$default(WorldRenderUtils.INSTANCE, event, position.blockCenter(), block.getDisplayText(), true, null, 0.0, false, 0.0f, 0, 248, null);
        }
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 56, "dungeon.highlightClickedBlocks", "dungeon.clickedBlocks.enabled", null, 8, null);
    }

    private final boolean isEnabled() {
        return !DungeonApi.INSTANCE.getInBossRoom() && DungeonApi.INSTANCE.inDungeon() && this.getConfig().getEnabled();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DungeonHighlightClickedBlocks.class, "leverPattern", "getLeverPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DungeonHighlightClickedBlocks.class, "lockedPattern", "getLockedPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = objectArray;
        INSTANCE = new DungeonHighlightClickedBlocks();
        patternGroup = RepoPattern.Companion.group("dungeons.highlightclickedblock");
        leverPattern$delegate = patternGroup.pattern("lever", "\u00a7cYou hear the sound of something opening\\.\\.\\.");
        lockedPattern$delegate = patternGroup.pattern("locked", "\u00a7cThat chest is locked!");
        blocks = new TimeLimitedCache(DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS), null, 2, null);
        objectArray = new LorenzColor[]{LorenzColor.BLACK, LorenzColor.WHITE, LorenzColor.CHROMA, LorenzColor.GRAY, LorenzColor.DARK_GRAY};
        undesirableColors = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$filter$iv = (Iterable)LorenzColor.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LorenzColor it = (LorenzColor)((Object)element$iv$iv);
            boolean bl = false;
            if (!(!undesirableColors.contains((Object)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        randomColors = (List)var3_3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$BlockProperties;", "", "", "name", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "color", "<init>", "(Ljava/lang/String;Lio/github/notenoughupdates/moulconfig/ChromaColour;)V", "component1", "()Ljava/lang/String;", "component2", "()Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "copy", "(Ljava/lang/String;Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;)Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$BlockProperties;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getName", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "getColor", "()Lio/github/notenoughupdates/moulconfig/ChromaColour;", "1.21.7"})
    private static final class BlockProperties {
        @NotNull
        private final String name;
        @NotNull
        private final ChromaColour color;

        public BlockProperties(@NotNull String name2, @NotNull ChromaColour color) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.name = name2;
            this.color = color;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final ChromaColour getColor() {
            return this.color;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final ChromaColour component2() {
            return this.color;
        }

        @NotNull
        public final BlockProperties copy(@NotNull String name2, @NotNull ChromaColour color) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            return new BlockProperties(name2, color);
        }

        public static /* synthetic */ BlockProperties copy$default(BlockProperties blockProperties, String string, ChromaColour chromaColour, int n, Object object) {
            if ((n & 1) != 0) {
                string = blockProperties.name;
            }
            if ((n & 2) != 0) {
                chromaColour = blockProperties.color;
            }
            return blockProperties.copy(string, chromaColour);
        }

        @NotNull
        public String toString() {
            return "BlockProperties(name=" + this.name + ", color=" + this.color + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.color.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockProperties)) {
                return false;
            }
            BlockProperties blockProperties = (BlockProperties)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)blockProperties.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.color, (Object)blockProperties.color);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$ClickedBlock;", "", "", "displayText", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "color", "<init>", "(Ljava/lang/String;Lio/github/notenoughupdates/moulconfig/ChromaColour;)V", "component1", "()Ljava/lang/String;", "component2", "()Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "copy", "(Ljava/lang/String;Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;)Lat/hannibal2/skyhanni/features/dungeon/DungeonHighlightClickedBlocks$ClickedBlock;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getDisplayText", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "getColor", "()Lio/github/notenoughupdates/moulconfig/ChromaColour;", "setColor", "(Lio/github/notenoughupdates/moulconfig/ChromaColour;)V", "1.21.7"})
    private static final class ClickedBlock {
        @NotNull
        private final String displayText;
        @NotNull
        private ChromaColour color;

        public ClickedBlock(@NotNull String displayText, @NotNull ChromaColour color) {
            Intrinsics.checkNotNullParameter((Object)displayText, (String)"displayText");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.displayText = displayText;
            this.color = color;
        }

        @NotNull
        public final String getDisplayText() {
            return this.displayText;
        }

        @NotNull
        public final ChromaColour getColor() {
            return this.color;
        }

        public final void setColor(@NotNull ChromaColour chromaColour) {
            Intrinsics.checkNotNullParameter((Object)chromaColour, (String)"<set-?>");
            this.color = chromaColour;
        }

        @NotNull
        public final String component1() {
            return this.displayText;
        }

        @NotNull
        public final ChromaColour component2() {
            return this.color;
        }

        @NotNull
        public final ClickedBlock copy(@NotNull String displayText, @NotNull ChromaColour color) {
            Intrinsics.checkNotNullParameter((Object)displayText, (String)"displayText");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            return new ClickedBlock(displayText, color);
        }

        public static /* synthetic */ ClickedBlock copy$default(ClickedBlock clickedBlock, String string, ChromaColour chromaColour, int n, Object object) {
            if ((n & 1) != 0) {
                string = clickedBlock.displayText;
            }
            if ((n & 2) != 0) {
                chromaColour = clickedBlock.color;
            }
            return clickedBlock.copy(string, chromaColour);
        }

        @NotNull
        public String toString() {
            return "ClickedBlock(displayText=" + this.displayText + ", color=" + this.color + ")";
        }

        public int hashCode() {
            int result2 = this.displayText.hashCode();
            result2 = result2 * 31 + this.color.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClickedBlock)) {
                return false;
            }
            ClickedBlock clickedBlock = (ClickedBlock)other;
            if (!Intrinsics.areEqual((Object)this.displayText, (Object)clickedBlock.displayText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.color, (Object)clickedBlock.color);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClickedBlockType.values().length];
            try {
                nArray[ClickedBlockType.LEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.CHEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.TRAPPED_CHEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickedBlockType.WITHER_ESSENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

