/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.diana;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.event.diana.DianaConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.diana.BurrowGuessEvent;
import at.hannibal2.skyhanni.features.event.diana.DianaApi;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.ParticlePathBezierFitter;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1799;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010$\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/features/event/diana/PreciseGuessBurrow;", "", "<init>", "()V", "", "onIslandChange", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "event", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "guessBurrowLocation", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "onUseAbility", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/event/diana/DianaConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/diana/DianaConfig;", "config", "Lat/hannibal2/skyhanni/utils/ParticlePathBezierFitter;", "bezierFitter", "Lat/hannibal2/skyhanni/utils/ParticlePathBezierFitter;", "newBurrow", "Z", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastDianaSpade", "J", "lastLavaParticle", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nPreciseGuessBurrow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreciseGuessBurrow.kt\nat/hannibal2/skyhanni/features/event/diana/PreciseGuessBurrow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1573#2:110\n1604#2,4:111\n*S KotlinDebug\n*F\n+ 1 PreciseGuessBurrow.kt\nat/hannibal2/skyhanni/features/event/diana/PreciseGuessBurrow\n*L\n95#1:110\n95#1:111,4\n*E\n"})
public final class PreciseGuessBurrow {
    @NotNull
    public static final PreciseGuessBurrow INSTANCE = new PreciseGuessBurrow();
    @NotNull
    private static final ParticlePathBezierFitter bezierFitter = new ParticlePathBezierFitter(3);
    private static boolean newBurrow = true;
    private static long lastDianaSpade = SimpleTimeMark.Companion.farPast();
    private static long lastLavaParticle = SimpleTimeMark.Companion.farPast();

    private PreciseGuessBurrow() {
    }

    private final DianaConfig getConfig() {
        return SkyHanniMod.feature.getEvent().getDiana();
    }

    @HandleEvent(onlyOnIsland=IslandType.HUB)
    public final void onIslandChange() {
        bezierFitter.reset();
        newBurrow = true;
    }

    @HandleEvent(onlyOnIsland=IslandType.HUB, receiveCancelled=true)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        class_2396<?> type2 = event.getType();
        if (!Intrinsics.areEqual(type2, (Object)class_2398.field_11223)) {
            return;
        }
        if (event.getCount() != 2) {
            return;
        }
        if (!(event.getSpeed() == -0.5f)) {
            return;
        }
        lastLavaParticle = SimpleTimeMark.Companion.now-uFjCsEo();
        LorenzVec currLoc = event.getLocation();
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastDianaSpade), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)) > 0) {
            return;
        }
        if (bezierFitter.isEmpty()) {
            bezierFitter.addPoint(currLoc);
            return;
        }
        LorenzVec lorenzVec = bezierFitter.getLastPoint();
        if (lorenzVec == null) {
            return;
        }
        double distToLast = lorenzVec.distance(currLoc);
        if (distToLast == 0.0 || distToLast > 3.0) {
            return;
        }
        bezierFitter.addPoint(currLoc);
        LorenzVec lorenzVec2 = this.guessBurrowLocation();
        if (lorenzVec2 == null) {
            return;
        }
        LorenzVec guessPosition = lorenzVec2;
        new BurrowGuessEvent(guessPosition.down(0.5).roundToBlock(), bezierFitter.count() > 5, newBurrow).post();
        newBurrow = false;
    }

    private final LorenzVec guessBurrowLocation() {
        return bezierFitter.solve();
    }

    @HandleEvent(onlyOnIsland=IslandType.HUB)
    public final void onUseAbility(@NotNull ItemClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getClickType() != ClickType.RIGHT_CLICK) {
            return;
        }
        class_1799 class_17992 = event.getItemInHand();
        if (class_17992 == null) {
            return;
        }
        class_1799 item2 = class_17992;
        if (!DianaApi.INSTANCE.isDianaSpade(item2)) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastLavaParticle), (long)DurationKt.toDuration((double)0.2, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            event.cancel();
            return;
        }
        bezierFitter.reset();
        lastDianaSpade = SimpleTimeMark.Companion.now-uFjCsEo();
        newBurrow = true;
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.title("Precise Burrow Guess");
        if (!DianaApi.INSTANCE.isDoingDiana()) {
            event.addIrrelevant("not doing diana");
            return;
        }
        LorenzVec guess = this.guessBurrowLocation();
        event.addIrrelevant((Function1<? super List<String>, Unit>)((Function1)arg_0 -> PreciseGuessBurrow.onDebug$lambda$1(guess, arg_0)));
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 74, "event.diana.burrowsSoopyGuess", "event.diana.guess", null, 8, null);
    }

    private final boolean isEnabled() {
        return DianaApi.INSTANCE.isDoingDiana() && this.getConfig().getGuess() && this.getConfig().getGuessLogic() == DianaConfig.GuessLogic.PRECISE_GUESS;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onDebug$lambda$1(LorenzVec $guess, List $this$addIrrelevant) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addIrrelevant, (String)"$this$addIrrelevant");
        Object object = $guess;
        if (object == null || (object = LorenzVec.toCleanString$default((LorenzVec)object, null, 1, null)) == null) {
            object = "No Guess";
        }
        $this$addIrrelevant.add("Burrow Guess: " + (String)object);
        Object object2 = $guess;
        if (object2 == null || (object2 = ((LorenzVec)object2).down(0.5)) == null || (object2 = ((LorenzVec)object2).roundToBlock()) == null || (object2 = LorenzVec.toCleanString$default((LorenzVec)object2, null, 1, null)) == null) {
            object2 = "No Guess";
        }
        $this$addIrrelevant.add("Rounded Guess: " + (String)object2);
        $this$addIrrelevant.add("Particle Locations:");
        Iterable iterable = bezierFitter.getPoints();
        List list = $this$addIrrelevant;
        boolean $i$f$mapIndexed = false;
        void var4_5 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void lorenzVec;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LorenzVec lorenzVec2 = (LorenzVec)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)index + ":  " + LorenzVec.toCleanString$default((LorenzVec)lorenzVec, null, 1, null));
        }
        list.addAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }
}

