/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.jerry;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.event.MayorJerryConfig;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobData;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\r\u0010\u0003R\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0017\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lat/hannibal2/skyhanni/features/event/jerry/HighlightJerries;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "event", "", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/data/mob/Mob;", "mob", "parseJerry", "(Lat/hannibal2/skyhanni/data/mob/Mob;)V", "onConfigLoad", "Lat/hannibal2/skyhanni/config/features/event/MayorJerryConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/MayorJerryConfig;", "config", "Ljava/util/regex/Pattern;", "jerryPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getJerryPattern", "()Ljava/util/regex/Pattern;", "jerryPattern", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nHighlightJerries.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightJerries.kt\nat/hannibal2/skyhanni/features/event/jerry/HighlightJerries\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1869#2,2:52\n1869#2,2:54\n*S KotlinDebug\n*F\n+ 1 HighlightJerries.kt\nat/hannibal2/skyhanni/features/event/jerry/HighlightJerries\n*L\n47#1:52,2\n48#1:54,2\n*E\n"})
public final class HighlightJerries {
    @NotNull
    public static final HighlightJerries INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern jerryPattern$delegate;

    private HighlightJerries() {
    }

    private final MayorJerryConfig getConfig() {
        return SkyHanniMod.feature.getEvent().getJerry();
    }

    private final Pattern getJerryPattern() {
        return (Pattern)jerryPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!((Boolean)this.getConfig().getHighlightJerries().get()).booleanValue() && !((Boolean)this.getConfig().getLineJerries().get()).booleanValue()) {
            return;
        }
        this.parseJerry(event.getMob());
    }

    private final void parseJerry(Mob mob) {
        LorenzColor lorenzColor;
        String string = RegexUtils.INSTANCE.matchGroup(this.getJerryPattern(), mob.getName(), "color");
        if (string == null) {
            return;
        }
        String type2 = string;
        if (!Mob.Companion.belongsToPlayer(mob)) {
            return;
        }
        switch (type2) {
            case "Green": {
                lorenzColor = LorenzColor.GREEN;
                break;
            }
            case "Blue": {
                lorenzColor = LorenzColor.BLUE;
                break;
            }
            case "Purple": {
                lorenzColor = LorenzColor.DARK_PURPLE;
                break;
            }
            case "Golden": {
                lorenzColor = LorenzColor.GOLD;
                break;
            }
            default: {
                return;
            }
        }
        ChromaColour color = LorenzColor.toChromaColor$default(lorenzColor, 0, 0, 3, null);
        mob.highlight(color, (Function0<Boolean>)((Function0)HighlightJerries::parseJerry$lambda$0));
        Mob.lineToPlayer$default(mob, color, 0, false, HighlightJerries::parseJerry$lambda$1, 6, null);
    }

    @HandleEvent(eventType=ConfigLoadEvent.class)
    public final void onConfigLoad() {
        ConditionalUtils.INSTANCE.onEnable(this.getConfig().getHighlightJerries(), HighlightJerries::onConfigLoad$lambda$3);
        ConditionalUtils.INSTANCE.onEnable(this.getConfig().getLineJerries(), HighlightJerries::onConfigLoad$lambda$5);
    }

    private static final boolean parseJerry$lambda$0() {
        Object t = INSTANCE.getConfig().getHighlightJerries().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (Boolean)t;
    }

    private static final boolean parseJerry$lambda$1() {
        Object t = INSTANCE.getConfig().getLineJerries().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (Boolean)t;
    }

    private static final void onConfigLoad$lambda$3() {
        Iterable $this$forEach$iv = MobData.INSTANCE.getSkyblockMobs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob it = (Mob)element$iv;
            boolean bl = false;
            INSTANCE.parseJerry(it);
        }
    }

    private static final void onConfigLoad$lambda$5() {
        Iterable $this$forEach$iv = MobData.INSTANCE.getSkyblockMobs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob it = (Mob)element$iv;
            boolean bl = false;
            INSTANCE.parseJerry(it);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(HighlightJerries.class, "jerryPattern", "getJerryPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new HighlightJerries();
        jerryPattern$delegate = RepoPattern.Companion.pattern("jerry.highlight", "(?<color>\\w+) Jerry");
    }
}

