/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.mining.HotmConfig;
import at.hannibal2.skyhanni.data.hotx.HotmData;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lat/hannibal2/skyhanni/features/mining/PowderPerHotmPerk;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "event", "", "onToolTip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;)V", "Lat/hannibal2/skyhanni/data/hotx/HotmData;", "perk", "handlePowderFor10Levels", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;Lat/hannibal2/skyhanni/data/hotx/HotmData;)V", "", "handlePowderSpend", "(Lat/hannibal2/skyhanni/data/hotx/HotmData;)Ljava/lang/String;", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/mining/HotmConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/HotmConfig;", "config", "PowderSpentDesign", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nPowderPerHotmPerk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PowderPerHotmPerk.kt\nat/hannibal2/skyhanni/features/mining/PowderPerHotmPerk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n360#2,7:95\n*S KotlinDebug\n*F\n+ 1 PowderPerHotmPerk.kt\nat/hannibal2/skyhanni/features/mining/PowderPerHotmPerk\n*L\n39#1:95,7\n*E\n"})
public final class PowderPerHotmPerk {
    @NotNull
    public static final PowderPerHotmPerk INSTANCE = new PowderPerHotmPerk();

    private PowderPerHotmPerk() {
    }

    private final HotmConfig getConfig() {
        return SkyHanniMod.feature.getMining().getHotm();
    }

    @HandleEvent
    public final void onToolTip(@NotNull ToolTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        String itemName2 = TextCompatKt.formattedTextCompatLeadingWhiteLessResets(event.getItemStack().method_7964());
        HotmData hotmData = (HotmData)HotmData.Companion.getPerkByNameOrNull(StringUtils.removeColor$default(StringUtils.INSTANCE, itemName2, false, 1, null));
        if (hotmData == null) {
            return;
        }
        HotmData perk = hotmData;
        if (perk.getLevelUpCost() == null) {
            return;
        }
        if (this.getConfig().getPowderSpent()) {
            event.getToolTip().add(2, this.handlePowderSpend(perk));
        }
        if (this.getConfig().getPowderFor10Levels()) {
            this.handlePowderFor10Levels(event, perk);
        }
    }

    private final void handlePowderFor10Levels(ToolTipEvent event, HotmData perk) {
        int indexOfCost;
        block4: {
            int n;
            if (!KeyboardManager.INSTANCE.isKeyHeld(340)) {
                return;
            }
            List<String> $this$indexOfFirst$iv = event.getToolTip();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                String item$iv;
                String it = item$iv = iterator2.next();
                boolean bl = false;
                if (RegexUtils.INSTANCE.matches(HotmData.Companion.getPerkCostPattern(), it)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = indexOfCost = -1;
        }
        if (indexOfCost == -1) {
            return;
        }
        int powderFor10Levels = perk.calculateTotalCost(RangesKt.coerceAtMost((int)(perk.getRawLevel() + 10), (int)perk.getMaxLevel())) - perk.calculateTotalCost(perk.getRawLevel());
        int numberOfLevels = RangesKt.coerceAtMost((int)(perk.getMaxLevel() - perk.getRawLevel()), (int)10);
        String levelsFormat = StringUtils.pluralize$default(StringUtils.INSTANCE, numberOfLevels, "level", null, false, 12, null);
        event.getToolTip().add(indexOfCost + 2, "\u00a77Powder for " + numberOfLevels + " " + levelsFormat + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(powderFor10Levels));
    }

    private final String handlePowderSpend(HotmData perk) {
        int currentPowderSpend = perk.calculateTotalCost(perk.getRawLevel());
        int maxPowderNeeded = perk.getTotalCostMaxLevel();
        double percentage = NumberUtil.INSTANCE.roundTo(NumberUtil.INSTANCE.fractionOf(currentPowderSpend, maxPowderNeeded) * (double)100, 2);
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getConfig().getPowderSpentDesign().ordinal()]) {
            case 1 -> {
                if (perk.getRawLevel() == perk.getMaxLevel()) {
                    yield "\u00a77Powder spent: \u00a7e" + NumberUtil.INSTANCE.addSeparators(maxPowderNeeded) + " \u00a77(\u00a7aMax level\u00a77)";
                }
                yield "\u00a77Powder spent: \u00a7e" + NumberUtil.INSTANCE.addSeparators(currentPowderSpend) + "\u00a77 / \u00a7e" + NumberUtil.INSTANCE.addSeparators(maxPowderNeeded);
            }
            case 2 -> {
                if (perk.getRawLevel() == perk.getMaxLevel()) {
                    yield "\u00a77Powder spent: \u00a7e" + percentage + "% \u00a77(\u00a7aMax level\u00a77)";
                }
                yield "\u00a77Powder spent: \u00a7e" + percentage + "%\u00a77 of max";
            }
            case 3 -> {
                if (perk.getRawLevel() == perk.getMaxLevel()) {
                    yield "\u00a77Powder spent: \u00a7e" + NumberUtil.INSTANCE.addSeparators(maxPowderNeeded) + " \u00a77(\u00a7aMax level\u00a77)";
                }
                yield "\u00a77Powder spent: \u00a7e" + NumberUtil.INSTANCE.addSeparators(currentPowderSpend) + "\u00a77/\u00a7e" + NumberUtil.INSTANCE.addSeparators(maxPowderNeeded) + "\u00a77 (\u00a7e" + percentage + "%\u00a77)";
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && HotmData.Companion.getInInventory() && (this.getConfig().getPowderSpent() || this.getConfig().getPowderFor10Levels());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\u0007j\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lat/hannibal2/skyhanni/features/mining/PowderPerHotmPerk$PowderSpentDesign;", "", "", "str", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getStr", "NUMBER", "PERCENTAGE", "NUMBER_AND_PERCENTAGE", "1.21.7"})
    public static final class PowderSpentDesign
    extends Enum<PowderSpentDesign> {
        @NotNull
        private final String str;
        public static final /* enum */ PowderSpentDesign NUMBER = new PowderSpentDesign("Number");
        public static final /* enum */ PowderSpentDesign PERCENTAGE = new PowderSpentDesign("Percentage");
        public static final /* enum */ PowderSpentDesign NUMBER_AND_PERCENTAGE = new PowderSpentDesign("Number and Percentage");
        private static final /* synthetic */ PowderSpentDesign[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PowderSpentDesign(String str) {
            this.str = str;
        }

        @NotNull
        public final String getStr() {
            return this.str;
        }

        @NotNull
        public String toString() {
            return this.str;
        }

        public static PowderSpentDesign[] values() {
            return (PowderSpentDesign[])$VALUES.clone();
        }

        public static PowderSpentDesign valueOf(String value) {
            return Enum.valueOf(PowderSpentDesign.class, value);
        }

        @NotNull
        public static EnumEntries<PowderSpentDesign> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = powderSpentDesignArray = new PowderSpentDesign[]{PowderSpentDesign.NUMBER, PowderSpentDesign.PERCENTAGE, PowderSpentDesign.NUMBER_AND_PERCENTAGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PowderSpentDesign.values().length];
            try {
                nArray[PowderSpentDesign.NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PowderSpentDesign.PERCENTAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PowderSpentDesign.NUMBER_AND_PERCENTAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

