/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.massconfiguration;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ConfigStructureReader;
import at.hannibal2.skyhanni.features.misc.massconfiguration.Category;
import at.hannibal2.skyhanni.features.misc.massconfiguration.FeatureToggleableOption;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\f\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0003J5\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0003J'\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\"R\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R-\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0+0*8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lat/hannibal2/skyhanni/features/misc/massconfiguration/FeatureToggleProcessor;", "Lat/hannibal2/skyhanni/deps/moulconfig/processor/ConfigStructureReader;", "<init>", "()V", "", "baseObject", "Ljava/lang/reflect/Field;", "field", "", "name", "description", "", "beginCategory", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Ljava/lang/String;Ljava/lang/String;)V", "endCategory", "Lat/hannibal2/skyhanni/deps/moulconfig/annotations/ConfigOption;", "o", "", "id", "beginAccordion", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Lat/hannibal2/skyhanni/deps/moulconfig/annotations/ConfigOption;I)V", "endAccordion", "fieldPath", "pushPath", "(Ljava/lang/String;)V", "popPath", "option", "emitOption", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Lat/hannibal2/skyhanni/deps/moulconfig/annotations/ConfigOption;)V", "Lat/hannibal2/skyhanni/features/misc/massconfiguration/Category;", "latestCategory", "Lat/hannibal2/skyhanni/features/misc/massconfiguration/Category;", "Ljava/util/Stack;", "pathStack", "Ljava/util/Stack;", "accordionStack", "", "Lat/hannibal2/skyhanni/features/misc/massconfiguration/FeatureToggleableOption;", "allOptions", "Ljava/util/List;", "getAllOptions", "()Ljava/util/List;", "", "", "orderedOptions$delegate", "Lkotlin/Lazy;", "getOrderedOptions", "()Ljava/util/Map;", "orderedOptions", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nFeatureToggleProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureToggleProcessor.kt\nat/hannibal2/skyhanni/features/misc/massconfiguration/FeatureToggleProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,88:1\n1491#2:89\n1516#2,3:90\n1519#2,3:100\n384#3,7:93\n*S KotlinDebug\n*F\n+ 1 FeatureToggleProcessor.kt\nat/hannibal2/skyhanni/features/misc/massconfiguration/FeatureToggleProcessor\n*L\n20#1:89\n20#1:90,3\n20#1:100,3\n20#1:93,7\n*E\n"})
public final class FeatureToggleProcessor
implements ConfigStructureReader {
    @Nullable
    private Category latestCategory;
    @NotNull
    private final Stack<String> pathStack = new Stack();
    @NotNull
    private final Stack<String> accordionStack = new Stack();
    @NotNull
    private final List<FeatureToggleableOption> allOptions = new ArrayList();
    @NotNull
    private final Lazy orderedOptions$delegate = LazyKt.lazy(() -> FeatureToggleProcessor.orderedOptions_delegate$lambda$1(this));

    @NotNull
    public final List<FeatureToggleableOption> getAllOptions() {
        return this.allOptions;
    }

    @NotNull
    public final Map<Category, List<FeatureToggleableOption>> getOrderedOptions() {
        Lazy lazy = this.orderedOptions$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    public void beginCategory(@Nullable Object baseObject, @Nullable Field field, @NotNull String name2, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.latestCategory = new Category(name2, description);
    }

    @Override
    public void endCategory() {
    }

    @Override
    public void beginAccordion(@Nullable Object baseObject, @Nullable Field field, @Nullable ConfigOption o, int id) {
        ConfigOption configOption = o;
        if (configOption == null) {
            return;
        }
        ConfigOption option = configOption;
        this.accordionStack.push(option.name());
    }

    @Override
    public void endAccordion() {
        this.accordionStack.pop();
    }

    @Override
    public void pushPath(@NotNull String fieldPath) {
        Intrinsics.checkNotNullParameter((Object)fieldPath, (String)"fieldPath");
        this.pathStack.push(fieldPath);
    }

    @Override
    public void popPath() {
        this.pathStack.pop();
    }

    @Override
    public void emitOption(@NotNull Object baseObject, @NotNull Field field, @NotNull ConfigOption option) {
        Intrinsics.checkNotNullParameter((Object)baseObject, (String)"baseObject");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        FeatureToggle featureToggle = field.getAnnotation(FeatureToggle.class);
        if (featureToggle == null) {
            return;
        }
        FeatureToggle featureToggle2 = featureToggle;
        if (field.getAnnotation(ConfigEditorBoolean.class) == null) {
            throw new IllegalStateException(("Feature toggle found without ConfigEditorBoolean: " + field).toString());
        }
        Function1 setter = null;
        boolean value = false;
        Class<?> clazz = field.getType();
        if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
            setter = arg_0 -> FeatureToggleProcessor.emitOption$lambda$2(field, baseObject, arg_0);
            value = field.getBoolean(baseObject);
        } else if (Intrinsics.areEqual(clazz, Property.class)) {
            Type genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedType)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Type type2 = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            if (!Intrinsics.areEqual((Object)((Class)type2), Boolean.class)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Object object = field.get(baseObject);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.github.notenoughupdates.moulconfig.observer.Property<kotlin.Boolean>");
            Property prop = (Property)object;
            setter = arg_0 -> FeatureToggleProcessor.emitOption$lambda$3(prop, arg_0);
            value = (Boolean)prop.get();
        } else {
            throw new IllegalStateException(("Invalid FeatureToggle type: " + field).toString());
        }
        String name2 = option.name();
        if ((Intrinsics.areEqual((Object)name2, (Object)"Enable") || Intrinsics.areEqual((Object)name2, (Object)"Enabled")) && !this.accordionStack.empty()) {
            name2 = this.accordionStack.peek();
        }
        String string = option.desc();
        boolean bl = featureToggle2.trueIsEnabled();
        Category category = this.latestCategory;
        Intrinsics.checkNotNull((Object)category);
        this.allOptions.add(new FeatureToggleableOption(name2, string, value, bl, category, setter, CollectionsKt.joinToString$default((Iterable)this.pathStack, (CharSequence)".", null, null, (int)0, null, null, (int)62, null) + "." + field.getName(), null, 128, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map orderedOptions_delegate$lambda$1(FeatureToggleProcessor this$0) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$groupBy$iv = this$0.allOptions;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FeatureToggleableOption it = (FeatureToggleableOption)element$iv$iv;
            boolean bl = false;
            Category key$iv$iv = it.getCategory();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    private static final Unit emitOption$lambda$2(Field $field, Object $baseObject, boolean it) {
        Intrinsics.checkNotNullParameter((Object)$field, (String)"$field");
        Intrinsics.checkNotNullParameter((Object)$baseObject, (String)"$baseObject");
        $field.setBoolean($baseObject, it);
        return Unit.INSTANCE;
    }

    private static final Unit emitOption$lambda$3(Property $prop, boolean it) {
        Intrinsics.checkNotNullParameter((Object)$prop, (String)"$prop");
        $prop.set(it);
        return Unit.INSTANCE;
    }
}

