/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.utils.BezierCurve;
import at.hannibal2.skyhanni.utils.BezierFitter;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/utils/ParticlePathBezierFitter;", "Lat/hannibal2/skyhanni/utils/BezierFitter;", "", "degree", "<init>", "(I)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "solve", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "1.21.7"})
public final class ParticlePathBezierFitter
extends BezierFitter {
    public ParticlePathBezierFitter(int degree) {
        super(degree);
    }

    @Nullable
    public final LorenzVec solve() {
        BezierCurve bezierCurve = this.fit();
        if (bezierCurve == null) {
            return null;
        }
        BezierCurve bezierCurve2 = bezierCurve;
        LorenzVec startPointDerivative = bezierCurve2.derivativeAt(0.0);
        double controlPointDistance = LocationUtils.INSTANCE.computePitchWeight(startPointDerivative);
        double t = (double)3 * controlPointDistance / startPointDerivative.length();
        return bezierCurve2.at(t);
    }
}

